/*
 * Decompiled with CFR 0.152.
 */
package net.anumbrella.seaweedfs.core.content;

public class LookupVolumeParams {
    private long volumeId;
    private String collection;

    public LookupVolumeParams(long volumeId) {
        this.volumeId = volumeId;
    }

    public LookupVolumeParams(String volumeId) {
        this.volumeId = this.convertVolumeId(volumeId);
    }

    public LookupVolumeParams(long volumeId, String collection) {
        this.volumeId = volumeId;
        this.collection = collection;
    }

    public LookupVolumeParams(String volumeId, String collection) {
        this.volumeId = this.convertVolumeId(volumeId);
        this.collection = collection;
    }

    public long getVolumeId() {
        return this.volumeId;
    }

    public String getCollection() {
        return this.collection;
    }

    private long convertVolumeId(String rawVolumeId) {
        int index = rawVolumeId.indexOf(",");
        if (index < 1) {
            return Long.parseLong(rawVolumeId);
        }
        return Long.parseLong(rawVolumeId.substring(0, rawVolumeId.indexOf(",")));
    }

    public String toUrlParams() {
        String result = "?";
        result = result + "volumeId=" + String.valueOf(this.volumeId) + "&";
        if (this.collection != null) {
            result = result + "collection=" + this.collection;
        }
        return result;
    }

    public String toString() {
        return "LookupVolumeParams{volumeId='" + this.volumeId + '\'' + ", collection='" + this.collection + '\'' + '}';
    }
}

