/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.logging.appender;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.pattern.ThrowableHandlingConverter;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.encoder.Encoder;
import java.util.HashMap;
import net.dreamlu.mica.core.utils.JsonUtil;
import net.dreamlu.mica.logging.appender.ILoggingAppender;
import net.dreamlu.mica.logging.config.MicaLoggingProperties;
import net.dreamlu.mica.logging.utils.LogStashUtil;
import net.logstash.logback.appender.LogstashTcpSocketAppender;
import net.logstash.logback.encoder.LogstashEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class LoggingLogStashAppender
implements ILoggingAppender {
    private static final Logger log = LoggerFactory.getLogger(LoggingLogStashAppender.class);
    private static final String ASYNC_LOG_STASH_APPENDER_NAME = "ASYNC_LOG_STASH";
    private final MicaLoggingProperties properties;
    private final String customFieldsJson;

    public LoggingLogStashAppender(Environment environment, MicaLoggingProperties properties) {
        this.properties = properties;
        String appName = environment.getRequiredProperty("spring.application.name");
        String profile = environment.getRequiredProperty("spring.profiles.active");
        HashMap<String, String> customFields = new HashMap<String, String>(4);
        customFields.put("appName", appName);
        customFields.put("profile", profile);
        this.customFieldsJson = JsonUtil.toJson(customFields);
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        this.start(context);
    }

    @Override
    public void start(LoggerContext context) {
        log.info("LogStash logging start.");
        this.reload(context);
    }

    @Override
    public void reset(LoggerContext context) {
        log.info("LogStash logging reset.");
        this.reload(context);
    }

    private void reload(LoggerContext context) {
        MicaLoggingProperties.Logstash logStash = this.properties.getLogstash();
        if (logStash.isEnabled()) {
            LoggingLogStashAppender.addLogStashTcpSocketAppender(context, this.customFieldsJson, logStash);
        }
    }

    private static void addLogStashTcpSocketAppender(LoggerContext context, String customFields, MicaLoggingProperties.Logstash logStashProperties) {
        LogstashTcpSocketAppender logStashAppender = new LogstashTcpSocketAppender();
        logStashAppender.addDestination(logStashProperties.getDestinations());
        logStashAppender.setContext((Context)context);
        logStashAppender.setEncoder((Encoder)LoggingLogStashAppender.logstashEncoder(customFields));
        logStashAppender.setName(ASYNC_LOG_STASH_APPENDER_NAME);
        logStashAppender.setQueueSize(logStashProperties.getQueueSize());
        logStashAppender.start();
        context.getLogger("ROOT").detachAppender(ASYNC_LOG_STASH_APPENDER_NAME);
        context.getLogger("ROOT").addAppender((Appender)logStashAppender);
    }

    private static LogstashEncoder logstashEncoder(String customFields) {
        LogstashEncoder logstashEncoder = new LogstashEncoder();
        logstashEncoder.setThrowableConverter((ThrowableHandlingConverter)LogStashUtil.throwableConverter());
        logstashEncoder.setCustomFields(customFields);
        return logstashEncoder;
    }
}

