/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.common;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.tio.http.common.HttpConst;
import org.tio.utils.hutool.CollUtil;

public class HeaderName {
    private static final ConcurrentMap<String, HeaderName> map = new ConcurrentHashMap<String, HeaderName>();
    public static final HeaderName SET_COOKIE = HeaderName.from(HttpConst.ResponseHeaderKey.Set_Cookie);
    public static final HeaderName CONTENT_TYPE = HeaderName.from(HttpConst.ResponseHeaderKey.Content_Type);
    public static final HeaderName CACHE_CONTROL = HeaderName.from(HttpConst.ResponseHeaderKey.Cache_Control);
    public static final HeaderName LOCATION = HeaderName.from(HttpConst.ResponseHeaderKey.Location);
    public static final HeaderName Connection = HeaderName.from(HttpConst.ResponseHeaderKey.Connection);
    public static final HeaderName Keep_Alive = HeaderName.from(HttpConst.ResponseHeaderKey.Keep_Alive);
    public static final HeaderName Content_Length = HeaderName.from(HttpConst.ResponseHeaderKey.Content_Length);
    public static final HeaderName Access_Control_Allow_Origin = HeaderName.from(HttpConst.ResponseHeaderKey.Access_Control_Allow_Origin);
    public static final HeaderName Access_Control_Allow_Headers = HeaderName.from(HttpConst.ResponseHeaderKey.Access_Control_Allow_Headers);
    public static final HeaderName Access_Control_Allow_Methods = HeaderName.from(HttpConst.ResponseHeaderKey.Access_Control_Allow_Methods);
    public static final HeaderName Access_Control_Max_Age = HeaderName.from(HttpConst.ResponseHeaderKey.Access_Control_Max_Age);
    public static final HeaderName Content_Disposition = HeaderName.from(HttpConst.ResponseHeaderKey.Content_Disposition);
    public static final HeaderName Content_Encoding = HeaderName.from(HttpConst.ResponseHeaderKey.Content_Encoding);
    public static final HeaderName Date = HeaderName.from(HttpConst.ResponseHeaderKey.Date);
    public static final HeaderName Expires = HeaderName.from(HttpConst.ResponseHeaderKey.Expires);
    public static final HeaderName Last_Modified = HeaderName.from(HttpConst.ResponseHeaderKey.Last_Modified);
    public static final HeaderName Refresh = HeaderName.from(HttpConst.ResponseHeaderKey.Refresh);
    public static final HeaderName Sec_WebSocket_Accept = HeaderName.from(HttpConst.ResponseHeaderKey.Sec_WebSocket_Accept);
    public static final HeaderName Server = HeaderName.from(HttpConst.ResponseHeaderKey.Server);
    public static final HeaderName Upgrade = HeaderName.from(HttpConst.ResponseHeaderKey.Upgrade);
    public static final HeaderName Content_Type = HeaderName.from(HttpConst.ResponseHeaderKey.Content_Type);
    public static final HeaderName Location = HeaderName.from(HttpConst.ResponseHeaderKey.Location);
    public static final HeaderName Cache_Control = HeaderName.from(HttpConst.ResponseHeaderKey.Cache_Control);
    public static final HeaderName tio_from_cache = HeaderName.from("tio-from-cache");
    public static final HeaderName tio_webpack_used_cache = HeaderName.from("tio-webpack-used-cache");
    public static final HeaderName Access_Control_Allow_Credentials = HeaderName.from(HttpConst.ResponseHeaderKey.Access_Control_Allow_Credentials);
    public static final HeaderName Sec_Websocket_Protocol = HeaderName.from("sec-websocket-protocol");
    public final String name;
    public final byte[] bytes;

    private HeaderName(String name) {
        this.name = name;
        this.bytes = name.getBytes();
    }

    public static HeaderName from(String name) {
        return (HeaderName)CollUtil.computeIfAbsent(map, (Object)name, HeaderName::new);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HeaderName other = (HeaderName)obj;
        if (this.name == null) {
            return other.name == null;
        }
        return this.name.equals(other.name);
    }

    public String toString() {
        return this.name;
    }
}

