/*
 * Decompiled with CFR 0.152.
 */
package org.tio.websocket.common;

import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.exception.TioDecodeException;
import org.tio.core.utils.ByteBufferUtils;
import org.tio.websocket.common.Opcode;
import org.tio.websocket.common.WsRequest;

public class WsServerDecoder {
    private static final Logger log = LoggerFactory.getLogger(WsServerDecoder.class);

    private WsServerDecoder() {
    }

    public static WsRequest decode(ByteBuffer buf, ChannelContext channelContext) throws TioDecodeException {
        byte second;
        boolean hasMask;
        int headLength;
        int initPosition = buf.position();
        int readableLength = buf.limit() - initPosition;
        if (readableLength < (headLength = 2)) {
            return null;
        }
        byte first = buf.get();
        boolean fin = (first & 0x80) > 0;
        int rsv = (first & 0x70) >>> 4;
        byte opCodeByte = (byte)(first & 0xF);
        Opcode opcode = Opcode.valueOf(opCodeByte);
        if (opcode == Opcode.CLOSE) {
            // empty if block
        }
        boolean bl = hasMask = ((second = buf.get()) & 0xFF) >> 7 == 1;
        if (hasMask) {
            headLength += 4;
        }
        int payloadLength = second & 0x7F;
        byte[] mask = null;
        if (payloadLength == 126) {
            if (readableLength < (headLength += 2)) {
                return null;
            }
            payloadLength = ByteBufferUtils.readUB2WithBigEdian((ByteBuffer)buf);
            log.debug("{} payloadLengthFlag: 126\uff0cpayloadLength {}", (Object)channelContext, (Object)payloadLength);
        } else if (payloadLength == 127) {
            if (readableLength < (headLength += 8)) {
                return null;
            }
            payloadLength = (int)buf.getLong();
            log.debug("{} payloadLengthFlag: 127\uff0cpayloadLength {}", (Object)channelContext, (Object)payloadLength);
        }
        if (payloadLength < 0 || payloadLength > 524288) {
            throw new TioDecodeException("body length(" + payloadLength + ") is not right");
        }
        if (readableLength < headLength + payloadLength) {
            return null;
        }
        if (hasMask) {
            mask = ByteBufferUtils.readBytes((ByteBuffer)buf, (int)4);
        }
        WsRequest websocketPacket = new WsRequest();
        websocketPacket.setWsEof(fin);
        websocketPacket.setWsHasMask(hasMask);
        websocketPacket.setWsMask(mask);
        websocketPacket.setWsOpcode(opcode);
        websocketPacket.setWsBodyLength(payloadLength);
        if (payloadLength == 0) {
            return websocketPacket;
        }
        byte[] array = ByteBufferUtils.readBytes((ByteBuffer)buf, (int)payloadLength);
        if (hasMask) {
            for (int i = 0; i < array.length; ++i) {
                array[i] = (byte)(array[i] ^ mask[i % 4]);
            }
        }
        websocketPacket.setBody(array);
        return websocketPacket;
    }
}

