/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent.status;

import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.status.CountersManager;

public class AtomicCounter
implements AutoCloseable {
    private final int counterId;
    private final int offset;
    private final AtomicBuffer buffer;
    private final CountersManager countersManager;

    AtomicCounter(AtomicBuffer buffer, int counterId, CountersManager countersManager) {
        this.buffer = buffer;
        this.counterId = counterId;
        this.countersManager = countersManager;
        this.offset = CountersManager.counterOffset(counterId);
        buffer.putLong(this.offset, 0L);
    }

    public long increment() {
        return this.buffer.getAndAddLong(this.offset, 1L);
    }

    public long orderedIncrement() {
        return this.buffer.addLongOrdered(this.offset, 1L);
    }

    public void set(long value) {
        this.buffer.putLongVolatile(this.offset, value);
    }

    public void setOrdered(long value) {
        this.buffer.putLongOrdered(this.offset, value);
    }

    public long add(long increment) {
        return this.buffer.getAndAddLong(this.offset, increment);
    }

    public long addOrdered(long increment) {
        return this.buffer.addLongOrdered(this.offset, increment);
    }

    public long get() {
        return this.buffer.getLongVolatile(this.offset);
    }

    public long getWeak() {
        return this.buffer.getLong(this.offset);
    }

    @Override
    public void close() {
        this.countersManager.free(this.counterId);
    }
}

