/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.component;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.artemis.utils.SpawnedVMSupport;

public class WebTmpCleaner {
    public static void main(String[] filesToClean) throws Exception {
        boolean allCleaned = false;
        int maxRetries = 100;
        while (!allCleaned && maxRetries-- > 0) {
            allCleaned = true;
            for (String f : filesToClean) {
                URI url;
                File file;
                if (f.trim().isEmpty() || !(file = new File(url = new URI(f))).exists()) continue;
                WebTmpCleaner.deleteFolder(file);
                allCleaned = false;
            }
            Thread.sleep(200L);
        }
    }

    public static Process cleanupTmpFiles(File libFolder, List<File> temporaryFiles) throws Exception {
        ArrayList<String> files = new ArrayList<String>(temporaryFiles.size());
        for (File f : temporaryFiles) {
            files.add(f.toURI().toString());
        }
        String classPath = SpawnedVMSupport.getClassPath((File)libFolder);
        return SpawnedVMSupport.spawnVM((String)classPath, (String)WebTmpCleaner.class.getName(), (boolean)false, (String[])files.toArray(new String[files.size()]));
    }

    public static final void deleteFolder(File file) {
        String[] files;
        if (file.isDirectory() && (files = file.list()) != null) {
            for (String path : files) {
                File f = new File(file, path);
                WebTmpCleaner.deleteFolder(f);
            }
        }
        file.delete();
    }
}

