/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.file;

import java.util.Iterator;
import org.apache.calcite.adapter.file.FileRowConverter;
import org.apache.calcite.linq4j.Enumerator;
import org.jsoup.select.Elements;

class FileEnumerator
implements Enumerator<Object> {
    private final Iterator<Elements> iterator;
    private final FileRowConverter converter;
    private final int[] fields;
    private Object current;

    FileEnumerator(Iterator<Elements> iterator, FileRowConverter converter) {
        this(iterator, converter, FileEnumerator.identityList(converter.width()));
    }

    FileEnumerator(Iterator<Elements> iterator, FileRowConverter converter, int[] fields) {
        this.iterator = iterator;
        this.converter = converter;
        this.fields = fields;
    }

    public Object current() {
        if (this.current == null) {
            this.moveNext();
        }
        return this.current;
    }

    public boolean moveNext() {
        try {
            if (this.iterator.hasNext()) {
                Elements row = this.iterator.next();
                this.current = this.converter.toRow(row, this.fields);
                return true;
            }
            this.current = null;
            return false;
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void reset() {
        throw new UnsupportedOperationException();
    }

    public void close() {
    }

    private static int[] identityList(int n) {
        int[] integers = new int[n];
        for (int i = 0; i < n; ++i) {
            integers[i] = i;
        }
        return integers;
    }
}

