/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.provider;

import java.util.Collections;
import java.util.List;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenRegistration;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.OAuthPermission;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.provider.OAuthDataProvider;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.tokens.bearer.BearerAccessToken;
import org.apache.cxf.rs.security.oauth2.tokens.refresh.RefreshToken;

public abstract class AbstractOAuthDataProvider
implements OAuthDataProvider {
    private long accessTokenLifetime = 3600L;
    private long refreshTokenLifetime = -1L;

    protected AbstractOAuthDataProvider() {
    }

    @Override
    public ServerAccessToken createAccessToken(AccessTokenRegistration accessToken) throws OAuthServiceException {
        return this.doCreateAccessToken(accessToken);
    }

    @Override
    public void removeAccessToken(ServerAccessToken token) throws OAuthServiceException {
        this.revokeAccessToken(token.getTokenKey());
    }

    @Override
    public ServerAccessToken refreshAccessToken(Client client, String refreshTokenKey, List<String> restrictedScopes) throws OAuthServiceException {
        RefreshToken oldRefreshToken = this.revokeRefreshAndAccessTokens(client, refreshTokenKey);
        return this.doRefreshAccessToken(client, oldRefreshToken, restrictedScopes);
    }

    @Override
    public void revokeToken(Client client, String tokenKey, String tokenTypeHint) throws OAuthServiceException {
        if (this.revokeAccessToken(tokenKey)) {
            return;
        }
        this.revokeRefreshAndAccessTokens(client, tokenKey);
    }

    protected RefreshToken revokeRefreshAndAccessTokens(Client client, String tokenKey) {
        RefreshToken oldRefreshToken = this.revokeRefreshToken(client, tokenKey);
        if (oldRefreshToken != null) {
            for (String accessTokenKey : oldRefreshToken.getAccessTokens()) {
                this.revokeAccessToken(accessTokenKey);
            }
        }
        return oldRefreshToken;
    }

    @Override
    public List<OAuthPermission> convertScopeToPermissions(Client client, List<String> requestedScope) {
        if (requestedScope.isEmpty()) {
            return Collections.emptyList();
        }
        throw new OAuthServiceException("Requested scopes can not be mapped");
    }

    @Override
    public ServerAccessToken getPreauthorizedToken(Client client, List<String> requestedScopes, UserSubject subject, String grantType) throws OAuthServiceException {
        return null;
    }

    protected ServerAccessToken doCreateAccessToken(AccessTokenRegistration accessToken) {
        ServerAccessToken at = this.createNewAccessToken(accessToken.getClient());
        at.setAudience(accessToken.getAudience());
        at.setGrantType(accessToken.getGrantType());
        List<String> theScopes = accessToken.getApprovedScope();
        List<OAuthPermission> thePermissions = this.convertScopeToPermissions(accessToken.getClient(), theScopes);
        at.setScopes(thePermissions);
        at.setSubject(accessToken.getSubject());
        this.saveAccessToken(at);
        if (this.isRefreshTokenSupported(theScopes)) {
            this.createNewRefreshToken(at);
        }
        return at;
    }

    protected boolean isRefreshTokenSupported(List<String> theScopes) {
        return theScopes.contains("refreshToken");
    }

    protected ServerAccessToken createNewAccessToken(Client client) {
        return new BearerAccessToken(client, this.accessTokenLifetime);
    }

    protected RefreshToken createNewRefreshToken(ServerAccessToken at) {
        RefreshToken rt = new RefreshToken(at.getClient(), this.refreshTokenLifetime);
        rt.setAudience(at.getAudience());
        rt.setGrantType(at.getGrantType());
        rt.setScopes(at.getScopes());
        rt.setSubject(at.getSubject());
        rt.getAccessTokens().add(at.getTokenKey());
        at.setRefreshToken(rt.getTokenKey());
        this.saveRefreshToken(at, rt);
        return rt;
    }

    protected ServerAccessToken doRefreshAccessToken(Client client, RefreshToken oldRefreshToken, List<String> restrictedScopes) {
        ServerAccessToken at = this.createNewAccessToken(client);
        at.setAudience(oldRefreshToken.getAudience());
        at.setGrantType(oldRefreshToken.getGrantType());
        at.setSubject(oldRefreshToken.getSubject());
        if (restrictedScopes.isEmpty()) {
            at.setScopes(oldRefreshToken.getScopes());
        } else {
            List<OAuthPermission> theNewScopes = this.convertScopeToPermissions(client, restrictedScopes);
            if (oldRefreshToken.getScopes().containsAll(theNewScopes)) {
                at.setScopes(theNewScopes);
            } else {
                throw new OAuthServiceException("Invalid scopes");
            }
        }
        this.saveAccessToken(at);
        this.createNewRefreshToken(at);
        return at;
    }

    public void setAccessTokenLifetime(long accessTokenLifetime) {
        this.accessTokenLifetime = accessTokenLifetime;
    }

    public void setRefreshTokenLifetime(long refreshTokenLifetime) {
        this.refreshTokenLifetime = refreshTokenLifetime;
    }

    protected abstract void saveAccessToken(ServerAccessToken var1);

    protected abstract void saveRefreshToken(ServerAccessToken var1, RefreshToken var2);

    protected abstract boolean revokeAccessToken(String var1);

    protected abstract RefreshToken revokeRefreshToken(Client var1, String var2);
}

