/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.Environment;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.common.utils.UrlUtils;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.config.support.Parameter;

public class ConfigCenterConfig
extends AbstractConfig {
    private AtomicBoolean inited = new AtomicBoolean(false);
    private String protocol;
    private String address;
    private String cluster;
    private String namespace = "dubbo";
    private String group = "dubbo";
    private String username;
    private String password;
    private Long timeout = 3000L;
    private Boolean highestPriority = true;
    private Boolean check = true;
    private String configFile = "dubbo.properties";
    private String appConfigFile;
    private Map<String, String> parameters;

    public URL toUrl() {
        Map<String, String> map = this.getMetaData();
        if (StringUtils.isEmpty((String)this.address)) {
            this.address = "0.0.0.0";
        }
        map.put("path", ConfigCenterConfig.class.getSimpleName());
        if (StringUtils.isEmpty((String)map.get("protocol"))) {
            map.put("protocol", "zookeeper");
        }
        return UrlUtils.parseURL((String)this.address, map);
    }

    public boolean checkOrUpdateInited() {
        return this.inited.compareAndSet(false, true);
    }

    public void setExternalConfig(Map<String, String> externalConfiguration) {
        Environment.getInstance().setExternalConfigMap(externalConfiguration);
    }

    public void setAppExternalConfig(Map<String, String> appExternalConfiguration) {
        Environment.getInstance().setAppExternalConfigMap(appExternalConfiguration);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @Parameter(excluded=true)
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    @Parameter(key="config.cluster", useKeyAsProperty=false)
    public String getCluster() {
        return this.cluster;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    @Parameter(key="config.namespace", useKeyAsProperty=false)
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Parameter(key="config.group", useKeyAsProperty=false)
    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    @Parameter(key="config.check", useKeyAsProperty=false)
    public Boolean isCheck() {
        return this.check;
    }

    public void setCheck(Boolean check) {
        this.check = check;
    }

    @Parameter(key="config.highest-priority", useKeyAsProperty=false)
    public Boolean isHighestPriority() {
        return this.highestPriority;
    }

    public void setHighestPriority(Boolean highestPriority) {
        this.highestPriority = highestPriority;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Parameter(key="config.timeout", useKeyAsProperty=false)
    public Long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    @Parameter(key="config.config-file", useKeyAsProperty=false)
    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    @Parameter(excluded=true)
    public String getAppConfigFile() {
        return this.appConfigFile;
    }

    public void setAppConfigFile(String appConfigFile) {
        this.appConfigFile = appConfigFile;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        ConfigCenterConfig.checkParameterName(parameters);
        this.parameters = parameters;
    }

    @Override
    @Parameter(excluded=true)
    public boolean isValid() {
        if (StringUtils.isEmpty((String)this.address)) {
            return false;
        }
        return this.address.contains("://") || StringUtils.isNotEmpty((String)this.protocol);
    }
}

