/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.store.etcd;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.report.identifier.BaseMetadataIdentifier;
import org.apache.dubbo.metadata.report.identifier.KeyTypeEnum;
import org.apache.dubbo.metadata.report.identifier.MetadataIdentifier;
import org.apache.dubbo.metadata.report.identifier.ServiceMetadataIdentifier;
import org.apache.dubbo.metadata.report.identifier.SubscriberMetadataIdentifier;
import org.apache.dubbo.metadata.report.support.AbstractMetadataReport;
import org.apache.dubbo.remoting.etcd.jetcd.JEtcdClient;

public class EtcdMetadataReport
extends AbstractMetadataReport {
    private static final Logger logger = LoggerFactory.getLogger(EtcdMetadataReport.class);
    private final String root;
    private final JEtcdClient etcdClient;

    public EtcdMetadataReport(URL url) {
        super(url);
        if (url.isAnyHost()) {
            throw new IllegalStateException("registry address == null");
        }
        String group = url.getParameter("group", "dubbo");
        if (!group.startsWith("/")) {
            group = "/" + group;
        }
        this.root = group;
        this.etcdClient = new JEtcdClient(url);
    }

    protected void doStoreProviderMetadata(MetadataIdentifier providerMetadataIdentifier, String serviceDefinitions) {
        this.storeMetadata(providerMetadataIdentifier, serviceDefinitions);
    }

    protected void doStoreConsumerMetadata(MetadataIdentifier consumerMetadataIdentifier, String value) {
        this.storeMetadata(consumerMetadataIdentifier, value);
    }

    protected void doSaveMetadata(ServiceMetadataIdentifier serviceMetadataIdentifier, URL url) {
        String key = this.getNodeKey((BaseMetadataIdentifier)serviceMetadataIdentifier);
        if (!this.etcdClient.put(key, URL.encode((String)url.toFullString()))) {
            logger.error("Failed to put " + serviceMetadataIdentifier + " to etcd, value: " + url);
        }
    }

    protected void doRemoveMetadata(ServiceMetadataIdentifier serviceMetadataIdentifier) {
        this.etcdClient.delete(this.getNodeKey((BaseMetadataIdentifier)serviceMetadataIdentifier));
    }

    protected List<String> doGetExportedURLs(ServiceMetadataIdentifier metadataIdentifier) {
        String content = this.etcdClient.getKVValue(this.getNodeKey((BaseMetadataIdentifier)metadataIdentifier));
        if (StringUtils.isEmpty((String)content)) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(Arrays.asList(URL.decode((String)content)));
    }

    protected void doSaveSubscriberData(SubscriberMetadataIdentifier subscriberMetadataIdentifier, String urlListStr) {
        String key = this.getNodeKey((BaseMetadataIdentifier)subscriberMetadataIdentifier);
        if (!this.etcdClient.put(key, urlListStr)) {
            logger.error("Failed to put " + subscriberMetadataIdentifier + " to etcd, value: " + urlListStr);
        }
    }

    protected String doGetSubscribedURLs(SubscriberMetadataIdentifier subscriberMetadataIdentifier) {
        return this.etcdClient.getKVValue(this.getNodeKey((BaseMetadataIdentifier)subscriberMetadataIdentifier));
    }

    public String getServiceDefinition(MetadataIdentifier metadataIdentifier) {
        return this.etcdClient.getKVValue(this.getNodeKey((BaseMetadataIdentifier)metadataIdentifier));
    }

    private void storeMetadata(MetadataIdentifier identifier, String v) {
        String key = this.getNodeKey((BaseMetadataIdentifier)identifier);
        if (!this.etcdClient.put(key, v)) {
            logger.error("Failed to put " + identifier + " to etcd, value: " + v);
        }
    }

    String getNodeKey(BaseMetadataIdentifier identifier) {
        return this.toRootDir() + identifier.getUniqueKey(KeyTypeEnum.PATH);
    }

    String toRootDir() {
        if (this.root.equals("/")) {
            return this.root;
        }
        return this.root + "/";
    }
}

