/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.dubbo;

import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.bytecode.Wrapper;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.rpc.Exporter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.ProxyFactory;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.protocol.AsyncToSyncInvoker;
import org.apache.dubbo.rpc.protocol.dubbo.ChannelWrappedInvoker;
import org.apache.dubbo.rpc.protocol.dubbo.DubboProtocol;

class CallbackServiceCodec {
    private static final Logger logger = LoggerFactory.getLogger(CallbackServiceCodec.class);
    private static final ProxyFactory PROXY_FACTORY = (ProxyFactory)ExtensionLoader.getExtensionLoader(ProxyFactory.class).getAdaptiveExtension();
    private static final DubboProtocol protocol = DubboProtocol.getDubboProtocol();
    private static final byte CALLBACK_NONE = 0;
    private static final byte CALLBACK_CREATE = 1;
    private static final byte CALLBACK_DESTROY = 2;
    private static final String INV_ATT_CALLBACK_KEY = "sys_callback_arg-";

    CallbackServiceCodec() {
    }

    private static byte isCallBack(URL url, String methodName, int argIndex) {
        String callback;
        int isCallback = 0;
        if (url != null && (callback = url.getParameter(methodName + "." + argIndex + ".callback")) != null) {
            if (callback.equalsIgnoreCase("true")) {
                isCallback = 1;
            } else if (callback.equalsIgnoreCase("false")) {
                isCallback = 2;
            }
        }
        return (byte)isCallback;
    }

    private static String exportOrUnexportCallbackService(Channel channel, URL url, Class clazz, Object inst, Boolean export) throws IOException {
        String group;
        int instid = System.identityHashCode(inst);
        HashMap<String, String> params = new HashMap<String, String>(3);
        params.put("isserver", Boolean.FALSE.toString());
        params.put("is_callback_service", Boolean.TRUE.toString());
        String string = group = url == null ? null : url.getParameter("group");
        if (group != null && group.length() > 0) {
            params.put("group", group);
        }
        params.put("methods", StringUtils.join((String[])Wrapper.getWrapper((Class)clazz).getDeclaredMethodNames(), (String)","));
        HashMap<String, String> tmpMap = new HashMap<String, String>(url.getParameters());
        tmpMap.putAll(params);
        tmpMap.remove("version");
        tmpMap.put("interface", clazz.getName());
        URL exportUrl = new URL("dubbo", channel.getLocalAddress().getAddress().getHostAddress(), channel.getLocalAddress().getPort(), clazz.getName() + "." + instid, tmpMap);
        String cacheKey = CallbackServiceCodec.getClientSideCallbackServiceCacheKey(instid);
        String countKey = CallbackServiceCodec.getClientSideCountKey(clazz.getName());
        if (export.booleanValue()) {
            if (!channel.hasAttribute(cacheKey) && !CallbackServiceCodec.isInstancesOverLimit(channel, url, clazz.getName(), instid, false)) {
                Invoker invoker = PROXY_FACTORY.getInvoker(inst, clazz, exportUrl);
                Exporter exporter = protocol.export(invoker);
                channel.setAttribute(cacheKey, exporter);
                logger.info("Export a callback service :" + exportUrl + ", on " + channel + ", url is: " + url);
                CallbackServiceCodec.increaseInstanceCount(channel, countKey);
            }
        } else if (channel.hasAttribute(cacheKey)) {
            Exporter exporter = (Exporter)channel.getAttribute(cacheKey);
            exporter.unexport();
            channel.removeAttribute(cacheKey);
            CallbackServiceCodec.decreaseInstanceCount(channel, countKey);
        }
        return String.valueOf(instid);
    }

    private static Object referOrDestroyCallbackService(Channel channel, URL url, Class<?> clazz, Invocation inv, int instid, boolean isRefer) {
        Object proxy = null;
        String invokerCacheKey = CallbackServiceCodec.getServerSideCallbackInvokerCacheKey(channel, clazz.getName(), instid);
        String proxyCacheKey = CallbackServiceCodec.getServerSideCallbackServiceCacheKey(channel, clazz.getName(), instid);
        proxy = channel.getAttribute(proxyCacheKey);
        String countkey = CallbackServiceCodec.getServerSideCountKey(channel, clazz.getName());
        if (isRefer) {
            if (proxy == null) {
                URL referurl = URL.valueOf((String)("callback://" + url.getAddress() + "/" + clazz.getName() + "?" + "interface" + "=" + clazz.getName()));
                if (!CallbackServiceCodec.isInstancesOverLimit(channel, referurl = referurl.addParametersIfAbsent(url.getParameters()).removeParameter("methods"), clazz.getName(), instid, true)) {
                    ChannelWrappedInvoker invoker = new ChannelWrappedInvoker(clazz, channel, referurl, String.valueOf(instid));
                    proxy = PROXY_FACTORY.getProxy((Invoker)new AsyncToSyncInvoker(invoker));
                    channel.setAttribute(proxyCacheKey, proxy);
                    channel.setAttribute(invokerCacheKey, invoker);
                    CallbackServiceCodec.increaseInstanceCount(channel, countkey);
                    Set callbackInvokers = (Set)channel.getAttribute("channel.callback.invokers.key");
                    if (callbackInvokers == null) {
                        callbackInvokers = new ConcurrentHashSet(1);
                        callbackInvokers.add(invoker);
                        channel.setAttribute("channel.callback.invokers.key", (Object)callbackInvokers);
                    }
                    logger.info("method " + inv.getMethodName() + " include a callback service :" + invoker.getUrl() + ", a proxy :" + invoker + " has been created.");
                }
            }
        } else if (proxy != null) {
            Invoker invoker = (Invoker)channel.getAttribute(invokerCacheKey);
            try {
                Set callbackInvokers = (Set)channel.getAttribute("channel.callback.invokers.key");
                if (callbackInvokers != null) {
                    callbackInvokers.remove(invoker);
                }
                invoker.destroy();
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            channel.removeAttribute(proxyCacheKey);
            channel.removeAttribute(invokerCacheKey);
            CallbackServiceCodec.decreaseInstanceCount(channel, countkey);
        }
        return proxy;
    }

    private static String getClientSideCallbackServiceCacheKey(int instid) {
        return "callback.service.instid." + instid;
    }

    private static String getServerSideCallbackServiceCacheKey(Channel channel, String interfaceClass, int instid) {
        return "callback.service.proxy." + System.identityHashCode(channel) + "." + interfaceClass + "." + instid;
    }

    private static String getServerSideCallbackInvokerCacheKey(Channel channel, String interfaceClass, int instid) {
        return CallbackServiceCodec.getServerSideCallbackServiceCacheKey(channel, interfaceClass, instid) + ".invoker";
    }

    private static String getClientSideCountKey(String interfaceClass) {
        return "callback.service.instid." + interfaceClass + ".COUNT";
    }

    private static String getServerSideCountKey(Channel channel, String interfaceClass) {
        return "callback.service.proxy." + System.identityHashCode(channel) + "." + interfaceClass + ".COUNT";
    }

    private static boolean isInstancesOverLimit(Channel channel, URL url, String interfaceClass, int instid, boolean isServer) {
        Integer count = (Integer)channel.getAttribute(isServer ? CallbackServiceCodec.getServerSideCountKey(channel, interfaceClass) : CallbackServiceCodec.getClientSideCountKey(interfaceClass));
        int limit = url.getParameter("callbacks", 1);
        if (count != null && count >= limit) {
            throw new IllegalStateException("interface " + interfaceClass + " `s callback instances num exceed providers limit :" + limit + " ,current num: " + (count + 1) + ". The new callback service will not work !!! you can cancle the callback service which exported before. channel :" + channel);
        }
        return false;
    }

    private static void increaseInstanceCount(Channel channel, String countkey) {
        try {
            Integer count = (Integer)channel.getAttribute(countkey);
            if (count == null) {
                count = 1;
            } else {
                Integer n = count;
                Integer n2 = count = Integer.valueOf(count + 1);
            }
            channel.setAttribute(countkey, (Object)count);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private static void decreaseInstanceCount(Channel channel, String countkey) {
        try {
            Integer count = (Integer)channel.getAttribute(countkey);
            if (count == null || count <= 0) {
                return;
            }
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count - 1);
            channel.setAttribute(countkey, (Object)count);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static Object encodeInvocationArgument(Channel channel, RpcInvocation inv, int paraIndex) throws IOException {
        URL url = inv.getInvoker() == null ? null : inv.getInvoker().getUrl();
        byte callbackStatus = CallbackServiceCodec.isCallBack(url, inv.getMethodName(), paraIndex);
        Object[] args = inv.getArguments();
        Class[] pts = inv.getParameterTypes();
        switch (callbackStatus) {
            case 0: {
                return args[paraIndex];
            }
            case 1: {
                inv.setAttachment(INV_ATT_CALLBACK_KEY + paraIndex, CallbackServiceCodec.exportOrUnexportCallbackService(channel, url, pts[paraIndex], args[paraIndex], true));
                return null;
            }
            case 2: {
                inv.setAttachment(INV_ATT_CALLBACK_KEY + paraIndex, CallbackServiceCodec.exportOrUnexportCallbackService(channel, url, pts[paraIndex], args[paraIndex], false));
                return null;
            }
        }
        return args[paraIndex];
    }

    public static Object decodeInvocationArgument(Channel channel, RpcInvocation inv, Class<?>[] pts, int paraIndex, Object inObject) throws IOException {
        URL url = null;
        try {
            url = DubboProtocol.getDubboProtocol().getInvoker(channel, (Invocation)inv).getUrl();
        }
        catch (RemotingException e) {
            if (logger.isInfoEnabled()) {
                logger.info(e.getMessage(), (Throwable)e);
            }
            return inObject;
        }
        byte callbackstatus = CallbackServiceCodec.isCallBack(url, inv.getMethodName(), paraIndex);
        switch (callbackstatus) {
            case 0: {
                return inObject;
            }
            case 1: {
                try {
                    return CallbackServiceCodec.referOrDestroyCallbackService(channel, url, pts[paraIndex], (Invocation)inv, Integer.parseInt(inv.getAttachment(INV_ATT_CALLBACK_KEY + paraIndex)), true);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new IOException(StringUtils.toString((Throwable)e));
                }
            }
            case 2: {
                try {
                    return CallbackServiceCodec.referOrDestroyCallbackService(channel, url, pts[paraIndex], (Invocation)inv, Integer.parseInt(inv.getAttachment(INV_ATT_CALLBACK_KEY + paraIndex)), false);
                }
                catch (Exception e) {
                    throw new IOException(StringUtils.toString((Throwable)e));
                }
            }
        }
        return inObject;
    }
}

