/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.integration;

import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.localserver.LocalServerTestBase;
import org.apache.http.localserver.LocalTestServer;
import org.apache.http.util.EntityUtils;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class TestIdleConnectionEviction
extends LocalServerTestBase {
    @Before
    public void setUp() throws Exception {
        this.localServer = new LocalTestServer(null, null);
        this.localServer.registerDefaultHandlers();
        this.localServer.start();
    }

    @Test
    @Ignore(value="We have a concurrency bug in HttpCore which will be addressed after HttpClient 4.3.2 is released")
    public void testIdleConnectionEviction() throws Exception {
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setDefaultMaxPerRoute(10);
        cm.setMaxTotal(50);
        CloseableHttpClient httpclient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
        IdleConnectionMonitor idleConnectionMonitor = new IdleConnectionMonitor((HttpClientConnectionManager)cm);
        idleConnectionMonitor.start();
        InetSocketAddress address = this.localServer.getServiceAddress();
        HttpHost target = new HttpHost(address.getHostName(), address.getPort());
        HttpGet httpget = new HttpGet("/random/1024");
        WorkerThread[] workers = new WorkerThread[5];
        for (int i = 0; i < workers.length; ++i) {
            workers[i] = new WorkerThread((HttpClient)httpclient, target, (HttpUriRequest)httpget, 200);
        }
        for (WorkerThread worker : workers) {
            worker.start();
        }
        for (WorkerThread worker : workers) {
            worker.join();
            Exception ex = worker.getException();
            if (ex == null) continue;
            throw ex;
        }
        idleConnectionMonitor.shutdown();
    }

    public static class IdleConnectionMonitor
    extends Thread {
        private final HttpClientConnectionManager cm;
        private volatile boolean shutdown;

        public IdleConnectionMonitor(HttpClientConnectionManager cm) {
            this.cm = cm;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                while (!this.shutdown) {
                    IdleConnectionMonitor idleConnectionMonitor = this;
                    synchronized (idleConnectionMonitor) {
                        this.wait(250L);
                        this.cm.closeIdleConnections(1L, TimeUnit.MILLISECONDS);
                    }
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.shutdown = true;
            IdleConnectionMonitor idleConnectionMonitor = this;
            synchronized (idleConnectionMonitor) {
                this.notifyAll();
            }
        }
    }

    static class WorkerThread
    extends Thread {
        private final HttpClient httpclient;
        private final HttpHost target;
        private final HttpUriRequest request;
        private final int count;
        private volatile Exception ex;

        public WorkerThread(HttpClient httpclient, HttpHost target, HttpUriRequest request, int count) {
            this.httpclient = httpclient;
            this.target = target;
            this.request = request;
            this.count = count;
        }

        public void run() {
            try {
                for (int i = 0; i < this.count; ++i) {
                    HttpResponse response = this.httpclient.execute(this.target, (HttpRequest)this.request);
                    int status = response.getStatusLine().getStatusCode();
                    if (status != 200) {
                        this.request.abort();
                        throw new ClientProtocolException("Unexpected status code: " + status);
                    }
                    EntityUtils.consume((HttpEntity)response.getEntity());
                    Thread.sleep(10L);
                }
            }
            catch (Exception ex) {
                this.ex = ex;
            }
        }

        public Exception getException() {
            return this.ex;
        }
    }
}

