/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.junit.Assert;
import org.junit.Test;

public class TestBasicClientCookie {
    @Test
    public void testConstructor() {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        Assert.assertEquals((Object)"name", (Object)cookie.getName());
        Assert.assertEquals((Object)"value", (Object)cookie.getValue());
        try {
            new BasicClientCookie(null, null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testCloning() throws Exception {
        BasicClientCookie orig = new BasicClientCookie("name", "value");
        orig.setDomain("domain");
        orig.setPath("/");
        orig.setAttribute("attrib", "stuff");
        BasicClientCookie clone = (BasicClientCookie)orig.clone();
        Assert.assertEquals((Object)orig.getName(), (Object)clone.getName());
        Assert.assertEquals((Object)orig.getValue(), (Object)clone.getValue());
        Assert.assertEquals((Object)orig.getDomain(), (Object)clone.getDomain());
        Assert.assertEquals((Object)orig.getPath(), (Object)clone.getPath());
        Assert.assertEquals((Object)orig.getAttribute("attrib"), (Object)clone.getAttribute("attrib"));
    }

    @Test
    public void testSerialization() throws Exception {
        BasicClientCookie orig = new BasicClientCookie("name", "value");
        orig.setDomain("domain");
        orig.setPath("/");
        orig.setAttribute("attrib", "stuff");
        ByteArrayOutputStream outbuffer = new ByteArrayOutputStream();
        ObjectOutputStream outstream = new ObjectOutputStream(outbuffer);
        outstream.writeObject(orig);
        outstream.close();
        byte[] raw = outbuffer.toByteArray();
        ByteArrayInputStream inbuffer = new ByteArrayInputStream(raw);
        ObjectInputStream instream = new ObjectInputStream(inbuffer);
        BasicClientCookie clone = (BasicClientCookie)instream.readObject();
        Assert.assertEquals((Object)orig.getName(), (Object)clone.getName());
        Assert.assertEquals((Object)orig.getValue(), (Object)clone.getValue());
        Assert.assertEquals((Object)orig.getDomain(), (Object)clone.getDomain());
        Assert.assertEquals((Object)orig.getPath(), (Object)clone.getPath());
        Assert.assertEquals((Object)orig.getAttribute("attrib"), (Object)clone.getAttribute("attrib"));
    }
}

