/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.model.mementos;

import com.google.common.base.Function;
import java.io.Serializable;
import java.util.List;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.OidMarshaller;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.adapter.oid.TypedOid;
import org.apache.isis.core.metamodel.facets.object.encodeable.EncodableFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.core.runtime.memento.Memento;
import org.apache.isis.core.runtime.persistence.ObjectNotFoundException;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.viewer.wicket.model.mementos.ActionMemento;
import org.apache.isis.viewer.wicket.model.mementos.ActionParameterMemento;
import org.apache.isis.viewer.wicket.model.mementos.CollectionMemento;
import org.apache.isis.viewer.wicket.model.mementos.PropertyMemento;
import org.apache.isis.viewer.wicket.model.mementos.SpecUtils;
import org.hamcrest.Matcher;

public class ObjectAdapterMemento
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Type type;
    private final ObjectSpecId objectSpecId;
    private String titleHint;
    private String encodableValue;
    private String persistentOidStr;
    private Memento transientMemento;

    public static ObjectAdapterMemento createOrNull(ObjectAdapter adapter) {
        if (adapter == null) {
            return null;
        }
        return new ObjectAdapterMemento(adapter);
    }

    public static ObjectAdapterMemento createPersistent(RootOid rootOid) {
        return new ObjectAdapterMemento(rootOid);
    }

    private ObjectAdapterMemento(RootOid rootOid) {
        Ensure.ensureThatArg((Object)rootOid, (Matcher)Oid.Matchers.isPersistent());
        this.persistentOidStr = rootOid.enString(ObjectAdapterMemento.getOidMarshaller());
        this.objectSpecId = rootOid.getObjectSpecId();
        this.type = Type.PERSISTENT;
    }

    private ObjectAdapterMemento(ObjectAdapter adapter) {
        if (adapter == null) {
            throw new IllegalArgumentException("adapter cannot be null");
        }
        ObjectSpecification specification = adapter.getSpecification();
        this.objectSpecId = specification.getSpecId();
        this.init(adapter);
    }

    private void init(ObjectAdapter adapter) {
        boolean isEncodable;
        ObjectSpecification specification = adapter.getSpecification();
        EncodableFacet encodableFacet = (EncodableFacet)specification.getFacet(EncodableFacet.class);
        boolean bl = isEncodable = encodableFacet != null;
        if (isEncodable) {
            this.encodableValue = encodableFacet.toEncodedString(adapter);
            this.type = Type.ENCODEABLE;
            return;
        }
        RootOid oid = (RootOid)adapter.getOid();
        if (oid.isTransient()) {
            this.transientMemento = new Memento(adapter);
            this.type = Type.TRANSIENT;
            return;
        }
        this.persistentOidStr = oid.enString(ObjectAdapterMemento.getOidMarshaller());
        this.type = Type.PERSISTENT;
    }

    public void resetVersion() {
        this.type.resetVersion(this);
    }

    public ObjectAdapter getObjectAdapter(AdapterManager.ConcurrencyChecking concurrencyChecking) {
        return this.type.getAdapter(this, concurrencyChecking);
    }

    public void setAdapter(ObjectAdapter adapter) {
        this.init(adapter);
    }

    public ObjectSpecId getObjectSpecId() {
        return this.objectSpecId;
    }

    public boolean containedIn(List<ObjectAdapterMemento> list) {
        ObjectAdapter currAdapter = this.getObjectAdapter(AdapterManager.ConcurrencyChecking.NO_CHECK);
        for (ObjectAdapterMemento each : list) {
            ObjectAdapter otherAdapter;
            if (each == null || currAdapter != (otherAdapter = each.getObjectAdapter(AdapterManager.ConcurrencyChecking.NO_CHECK))) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.type.hashCode(this);
    }

    public boolean equals(Object obj) {
        return obj instanceof ObjectAdapterMemento && this.type.equals(this, (ObjectAdapterMemento)obj);
    }

    public String toString() {
        return this.asString();
    }

    public String asString() {
        return this.type.toString(this);
    }

    private static AdapterManager getAdapterManager() {
        return ObjectAdapterMemento.getPersistenceSession().getAdapterManager();
    }

    private static PersistenceSession getPersistenceSession() {
        return IsisContext.getPersistenceSession();
    }

    public static OidMarshaller getOidMarshaller() {
        return IsisContext.getOidMarshaller();
    }

    public static final class Functions {
        private Functions() {
        }

        public static Function<ObjectSpecification, ObjectSpecId> fromSpec() {
            return new Function<ObjectSpecification, ObjectSpecId>(){

                public ObjectSpecId apply(ObjectSpecification from) {
                    return from.getSpecId();
                }
            };
        }

        public static Function<OneToOneAssociation, PropertyMemento> fromProperty() {
            return new Function<OneToOneAssociation, PropertyMemento>(){

                public PropertyMemento apply(OneToOneAssociation from) {
                    return new PropertyMemento(from);
                }
            };
        }

        public static Function<OneToManyAssociation, CollectionMemento> fromCollection() {
            return new Function<OneToManyAssociation, CollectionMemento>(){

                public CollectionMemento apply(OneToManyAssociation from) {
                    return new CollectionMemento(from);
                }
            };
        }

        public static Function<ObjectAction, ActionMemento> fromAction() {
            return new Function<ObjectAction, ActionMemento>(){

                public ActionMemento apply(ObjectAction from) {
                    return new ActionMemento(from);
                }
            };
        }

        public static Function<ObjectActionParameter, ActionParameterMemento> fromActionParameter() {
            return new Function<ObjectActionParameter, ActionParameterMemento>(){

                public ActionParameterMemento apply(ObjectActionParameter from) {
                    return new ActionParameterMemento(from);
                }
            };
        }

        public static Function<Object, ObjectAdapterMemento> fromPojo(final AdapterManager adapterManager) {
            return new Function<Object, ObjectAdapterMemento>(){

                public ObjectAdapterMemento apply(Object pojo) {
                    ObjectAdapter adapter = adapterManager.adapterFor(pojo);
                    return ObjectAdapterMemento.createOrNull(adapter);
                }
            };
        }

        public static Function<ObjectAdapter, ObjectAdapterMemento> fromAdapter() {
            return new Function<ObjectAdapter, ObjectAdapterMemento>(){

                public ObjectAdapterMemento apply(ObjectAdapter adapter) {
                    return ObjectAdapterMemento.createOrNull(adapter);
                }
            };
        }

        public static Function<ObjectAdapterMemento, ObjectAdapter> fromMemento(final AdapterManager.ConcurrencyChecking concurrencyChecking) {
            return new Function<ObjectAdapterMemento, ObjectAdapter>(){

                public ObjectAdapter apply(ObjectAdapterMemento from) {
                    try {
                        return from.getObjectAdapter(concurrencyChecking);
                    }
                    catch (ObjectNotFoundException e) {
                        return null;
                    }
                }
            };
        }

        public static Function<ObjectAdapter, ObjectAdapterMemento> toMemento() {
            return new Function<ObjectAdapter, ObjectAdapterMemento>(){

                public ObjectAdapterMemento apply(ObjectAdapter from) {
                    return ObjectAdapterMemento.createOrNull(from);
                }
            };
        }
    }

    static enum Type {
        ENCODEABLE{

            @Override
            ObjectAdapter recreateAdapter(ObjectAdapterMemento oam, AdapterManager.ConcurrencyChecking concurrencyChecking) {
                ObjectSpecId objectSpecId = oam.objectSpecId;
                ObjectSpecification objectSpec = SpecUtils.getSpecificationFor(objectSpecId);
                EncodableFacet encodableFacet = (EncodableFacet)objectSpec.getFacet(EncodableFacet.class);
                return encodableFacet.fromEncodedString(oam.encodableValue);
            }

            @Override
            public boolean equals(ObjectAdapterMemento oam, ObjectAdapterMemento other) {
                return other.type == ENCODEABLE && oam.encodableValue.equals(other.encodableValue);
            }

            @Override
            public int hashCode(ObjectAdapterMemento oam) {
                return oam.encodableValue.hashCode();
            }

            @Override
            public String toString(ObjectAdapterMemento oam) {
                return oam.encodableValue;
            }

            @Override
            public void resetVersion(ObjectAdapterMemento objectAdapterMemento) {
            }
        }
        ,
        PERSISTENT{

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            ObjectAdapter recreateAdapter(ObjectAdapterMemento oam, AdapterManager.ConcurrencyChecking concurrencyChecking) {
                TypedOid oid = (TypedOid)ObjectAdapterMemento.getOidMarshaller().unmarshal(oam.persistentOidStr, TypedOid.class);
                try {
                    ObjectAdapter adapter;
                    ObjectAdapter objectAdapter = adapter = ObjectAdapterMemento.getAdapterManager().adapterFor(oid, concurrencyChecking);
                    return objectAdapter;
                }
                finally {
                    oam.persistentOidStr = oid.enString(ObjectAdapterMemento.getOidMarshaller());
                }
            }

            @Override
            public void resetVersion(ObjectAdapterMemento oam) {
                ObjectAdapter adapter = this.recreateAdapter(oam, AdapterManager.ConcurrencyChecking.NO_CHECK);
                Oid oid = adapter.getOid();
                oam.persistentOidStr = oid.enString(ObjectAdapterMemento.getOidMarshaller());
            }

            @Override
            public boolean equals(ObjectAdapterMemento oam, ObjectAdapterMemento other) {
                return other.type == PERSISTENT && oam.persistentOidStr.equals(other.persistentOidStr);
            }

            @Override
            public int hashCode(ObjectAdapterMemento oam) {
                return oam.persistentOidStr.hashCode();
            }

            @Override
            public String toString(ObjectAdapterMemento oam) {
                return oam.persistentOidStr;
            }
        }
        ,
        TRANSIENT{

            @Override
            ObjectAdapter recreateAdapter(ObjectAdapterMemento oam, AdapterManager.ConcurrencyChecking concurrencyChecking) {
                return oam.transientMemento.recreateObject();
            }

            @Override
            public boolean equals(ObjectAdapterMemento oam, ObjectAdapterMemento other) {
                return other.type == TRANSIENT && oam.transientMemento.equals(other.transientMemento);
            }

            @Override
            public int hashCode(ObjectAdapterMemento oam) {
                return oam.transientMemento.hashCode();
            }

            @Override
            public String toString(ObjectAdapterMemento oam) {
                return oam.transientMemento.toString();
            }

            @Override
            public void resetVersion(ObjectAdapterMemento objectAdapterMemento) {
            }
        };


        public synchronized ObjectAdapter getAdapter(ObjectAdapterMemento nom, AdapterManager.ConcurrencyChecking concurrencyChecking) {
            return this.recreateAdapter(nom, concurrencyChecking);
        }

        abstract ObjectAdapter recreateAdapter(ObjectAdapterMemento var1, AdapterManager.ConcurrencyChecking var2);

        public abstract boolean equals(ObjectAdapterMemento var1, ObjectAdapterMemento var2);

        public abstract int hashCode(ObjectAdapterMemento var1);

        public abstract String toString(ObjectAdapterMemento var1);

        public abstract void resetVersion(ObjectAdapterMemento var1);
    }
}

