/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.widgets.valuechoices;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.vaynberg.wicket.select2.ChoiceProvider;
import com.vaynberg.wicket.select2.Select2Choice;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.deployment.DeploymentCategory;
import org.apache.isis.core.metamodel.facets.all.named.NamedFacet;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;
import org.apache.isis.viewer.wicket.model.links.LinkAndLabel;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.model.models.ScalarModelWithPending;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.entityactions.EntityActionUtil;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelAbstract;
import org.apache.isis.viewer.wicket.ui.components.widgets.ObjectAdapterMementoProviderAbstract;
import org.apache.isis.viewer.wicket.ui.components.widgets.bootstrap.FormGroup;
import org.apache.isis.viewer.wicket.ui.components.widgets.select2.Select2ChoiceUtil;
import org.apache.isis.viewer.wicket.ui.util.CssClassAppender;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.LabeledWebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class ValueChoicesSelect2Panel
extends ScalarPanelAbstract
implements ScalarModelWithPending {
    private static final long serialVersionUID = 1L;
    private Select2Choice<ObjectAdapterMemento> select2Field;
    private ObjectAdapterMemento pending;
    @Inject
    private WicketViewerSettings wicketViewerSettings;

    public ValueChoicesSelect2Panel(String id, ScalarModel scalarModel) {
        super(id, scalarModel);
        this.pending = scalarModel.getObjectAdapterMemento();
    }

    @Override
    protected MarkupContainer addComponentForRegular() {
        Model modelObject = ScalarModelWithPending.Util.createModel((ScalarModelWithPending)this);
        ObjectAdapter[] actionArgsHint = this.getScalarModel().getActionArgsHint();
        if (this.select2Field == null) {
            this.select2Field = Select2ChoiceUtil.newSelect2Choice("scalarValue", (IModel<ObjectAdapterMemento>)modelObject, this.getScalarModel());
            this.setChoices(actionArgsHint);
            this.addStandardSemantics();
        } else {
            this.select2Field.clearInput();
        }
        MarkupContainer labelIfRegular = this.createFormComponentLabel();
        if (((ScalarModel)this.getModel()).isRequired()) {
            labelIfRegular.add(new Behavior[]{new CssClassAppender("mandatory")});
        }
        this.addOrReplace(new Component[]{labelIfRegular});
        Label scalarName = new Label("scalarName", this.getRendering().getLabelCaption((LabeledWebMarkupContainer)this.select2Field));
        labelIfRegular.addOrReplace(new Component[]{scalarName});
        NamedFacet namedFacet = (NamedFacet)((ScalarModel)this.getModel()).getFacet(NamedFacet.class);
        if (namedFacet != null) {
            scalarName.setEscapeModelStrings(namedFacet.escaped());
        }
        List<LinkAndLabel> entityActions = EntityActionUtil.getEntityActionLinksForAssociation(this.scalarModel, this.getDeploymentType());
        this.addPositioningCssTo(labelIfRegular, entityActions);
        this.addFeedbackTo(labelIfRegular, (Component)this.select2Field);
        this.addEntityActionLinksBelowAndRight(labelIfRegular, entityActions);
        return labelIfRegular;
    }

    private List<ObjectAdapterMemento> getChoiceMementos(ObjectAdapter[] argumentsIfAvailable) {
        List choices = this.scalarModel.getChoices(argumentsIfAvailable, this.getAuthenticationSession(), this.getDeploymentCategory());
        return Lists.newArrayList((Iterable)Lists.transform((List)choices, (Function)ObjectAdapterMemento.Functions.fromAdapter()));
    }

    protected void addStandardSemantics() {
        this.setRequiredIfSpecified();
    }

    private void setRequiredIfSpecified() {
        ScalarModel scalarModel = (ScalarModel)this.getModel();
        boolean required = scalarModel.isRequired();
        this.select2Field.setRequired(required);
    }

    protected MarkupContainer createFormComponentLabel() {
        String name = ((ScalarModel)this.getModel()).getName();
        this.select2Field.setLabel((IModel)Model.of((Serializable)((Object)name)));
        FormGroup labelIfRegular = new FormGroup("scalarIfRegular", (FormComponent<?>)this.select2Field);
        String describedAs = ((ScalarModel)this.getModel()).getDescribedAs();
        if (describedAs != null) {
            labelIfRegular.add(new Behavior[]{new AttributeModifier("title", (IModel)Model.of((Serializable)((Object)describedAs)))});
        }
        labelIfRegular.add(new Component[]{this.select2Field});
        return labelIfRegular;
    }

    @Override
    protected Component addComponentForCompact() {
        Label labelIfCompact = new Label("scalarIfCompact", ((ScalarModel)this.getModel()).getObjectAsString());
        this.addOrReplace(new Component[]{labelIfCompact});
        return labelIfCompact;
    }

    protected ChoiceProvider<ObjectAdapterMemento> newChoiceProvider(List<ObjectAdapterMemento> choicesMementos) {
        return new FixedObjectAdapterMementoProvider(this.getScalarModel(), choicesMementos, this.wicketViewerSettings);
    }

    @Override
    protected boolean alwaysRebuildGui() {
        return true;
    }

    @Override
    protected void onBeforeRenderWhenViewMode() {
        this.select2Field.setEnabled(false);
    }

    @Override
    protected void onBeforeRenderWhenEnabled() {
        this.select2Field.setEnabled(true);
    }

    @Override
    protected void onBeforeRenderWhenDisabled(String disableReason) {
        super.onBeforeRenderWhenDisabled(disableReason);
        this.setTitleAttribute(disableReason);
        this.select2Field.setEnabled(false);
    }

    private void setTitleAttribute(String titleAttribute) {
        this.getComponentForRegular().add(new Behavior[]{new AttributeModifier("title", (IModel)Model.of((Serializable)((Object)titleAttribute)))});
    }

    @Override
    protected void addFormComponentBehavior(Behavior behavior) {
        for (Behavior b : this.select2Field.getBehaviors(ScalarPanelAbstract.ScalarUpdatingBehavior.class)) {
            this.select2Field.remove(new Behavior[]{b});
        }
        this.select2Field.add(new Behavior[]{behavior});
    }

    @Override
    public boolean updateChoices(ObjectAdapter[] argsIfAvailable) {
        this.setChoices(argsIfAvailable);
        return true;
    }

    private void setChoices(ObjectAdapter[] argsIfAvailable) {
        List<ObjectAdapterMemento> choicesMementos = this.getChoiceMementos(argsIfAvailable);
        ChoiceProvider<ObjectAdapterMemento> provider = this.newChoiceProvider(choicesMementos);
        this.select2Field.setProvider(provider);
        ((ScalarModel)this.getModel()).clearPending();
        ObjectAdapterMemento objectAdapterMemento = ((ScalarModel)this.getModel()).getObjectAdapterMemento();
        if (objectAdapterMemento == null) {
            this.select2Field.getModel().setObject(null);
        } else if (!choicesMementos.contains(objectAdapterMemento)) {
            ObjectAdapterMemento newAdapterMemento = !choicesMementos.isEmpty() ? choicesMementos.get(0) : null;
            this.select2Field.getModel().setObject((Object)newAdapterMemento);
            ((ScalarModel)this.getModel()).setObject(newAdapterMemento != null ? newAdapterMemento.getObjectAdapter(AdapterManager.ConcurrencyChecking.NO_CHECK) : null);
        }
    }

    public ObjectAdapterMemento getPending() {
        return this.pending;
    }

    public void setPending(ObjectAdapterMemento pending) {
        this.pending = pending;
    }

    public ScalarModel getScalarModel() {
        return this.scalarModel;
    }

    private DeploymentCategory getDeploymentCategory() {
        return this.getDeploymentType().getDeploymentCategory();
    }

    static class FixedObjectAdapterMementoProvider
    extends ObjectAdapterMementoProviderAbstract {
        private static final long serialVersionUID = 1L;
        private final List<ObjectAdapterMemento> choicesMementos;

        public FixedObjectAdapterMementoProvider(ScalarModel scalarModel, List<ObjectAdapterMemento> choicesMementos, WicketViewerSettings wicketViewerSettings) {
            super(scalarModel, wicketViewerSettings);
            this.choicesMementos = choicesMementos;
        }

        @Override
        public Collection<ObjectAdapterMemento> toChoices(final Collection<String> ids) {
            final List<ObjectAdapterMemento> mementos = this.obtainMementos(null);
            Predicate<ObjectAdapterMemento> lookupOam = new Predicate<ObjectAdapterMemento>(){

                public boolean apply(ObjectAdapterMemento input) {
                    String id = (String)FixedObjectAdapterMementoProvider.this.getId(input);
                    return ids.contains(id);
                }
            };
            Function<String, ObjectAdapterMemento> toOam = new Function<String, ObjectAdapterMemento>((Predicate)lookupOam){
                final /* synthetic */ Predicate val$lookupOam;
                {
                    this.val$lookupOam = predicate;
                }

                public ObjectAdapterMemento apply(String input) {
                    if ("$$_isis_null_$$".equals(input)) {
                        return null;
                    }
                    Collection filteredCollection = Collections2.filter((Collection)mementos, (Predicate)this.val$lookupOam);
                    return (ObjectAdapterMemento)filteredCollection.iterator().next();
                }
            };
            return Collections2.transform(ids, (Function)toOam);
        }

        @Override
        protected List<ObjectAdapterMemento> obtainMementos(String term) {
            return this.obtainMementos(term, this.choicesMementos);
        }
    }
}

