/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.Serializable;
import kafka.log.CompletedTxn;
import kafka.log.ProducerIdEntry;
import kafka.log.TxnMetadata;
import kafka.log.ValidationType;
import kafka.log.ValidationType$EpochOnly$;
import kafka.log.ValidationType$Full$;
import kafka.log.ValidationType$None$;
import kafka.server.LogOffsetMetadata;
import org.apache.kafka.common.errors.DuplicateSequenceException;
import org.apache.kafka.common.errors.InvalidTxnStateException;
import org.apache.kafka.common.errors.OutOfOrderSequenceException;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.errors.TransactionCoordinatorFencedException;
import org.apache.kafka.common.errors.UnknownProducerIdException;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ud!B\u0001\u0003\u0001\t1!A\u0005)s_\u0012,8-\u001a:BaB,g\u000eZ%oM>T!a\u0001\u0003\u0002\u00071|wMC\u0001\u0006\u0003\u0015Y\u0017MZ6b'\t\u0001q\u0001\u0005\u0002\t\u00175\t\u0011BC\u0001\u000b\u0003\u0015\u00198-\u00197b\u0013\ta\u0011B\u0001\u0004B]f\u0014VM\u001a\u0005\t\u001d\u0001\u0011)\u0019!C\u0001!\u0005Q\u0001O]8ek\u000e,'/\u00133\u0004\u0001U\t\u0011\u0003\u0005\u0002\t%%\u00111#\u0003\u0002\u0005\u0019>tw\r\u0003\u0005\u0016\u0001\t\u0005\t\u0015!\u0003\u0012\u0003-\u0001(o\u001c3vG\u0016\u0014\u0018\n\u001a\u0011\t\u0011]\u0001!\u0011!Q\u0001\na\tAbY;se\u0016tG/\u00128uef\u0004\"!\u0007\u000e\u000e\u0003\tI!a\u0007\u0002\u0003\u001fA\u0013x\u000eZ;dKJLE-\u00128uefD\u0001\"\b\u0001\u0003\u0002\u0003\u0006IAH\u0001\u000fm\u0006d\u0017\u000eZ1uS>tG+\u001f9f!\tIr$\u0003\u0002!\u0005\tqa+\u00197jI\u0006$\u0018n\u001c8UsB,\u0007\"\u0002\u0012\u0001\t\u0003\u0019\u0013A\u0002\u001fj]&$h\b\u0006\u0003%K\u0019:\u0003CA\r\u0001\u0011\u0015q\u0011\u00051\u0001\u0012\u0011\u00159\u0012\u00051\u0001\u0019\u0011\u0015i\u0012\u00051\u0001\u001f\u0011\u001dI\u0003A1A\u0005\n)\nA\u0002\u001e:b]N\f7\r^5p]N,\u0012a\u000b\t\u0004YE\u001aT\"A\u0017\u000b\u00059z\u0013aB7vi\u0006\u0014G.\u001a\u0006\u0003a%\t!bY8mY\u0016\u001cG/[8o\u0013\t\u0011TF\u0001\u0006MSN$()\u001e4gKJ\u0004\"!\u0007\u001b\n\u0005U\u0012!a\u0003+y]6+G/\u00193bi\u0006Daa\u000e\u0001!\u0002\u0013Y\u0013!\u0004;sC:\u001c\u0018m\u0019;j_:\u001c\b\u0005C\u0003:\u0001\u0011%!(A\nnCf\u0014WMV1mS\u0012\fG/Z!qa\u0016tG\r\u0006\u0003<}\rC\u0005C\u0001\u0005=\u0013\ti\u0014B\u0001\u0003V]&$\b\"B 9\u0001\u0004\u0001\u0015!\u00049s_\u0012,8-\u001a:Fa>\u001c\u0007\u000e\u0005\u0002\t\u0003&\u0011!)\u0003\u0002\u0006'\"|'\u000f\u001e\u0005\u0006\tb\u0002\r!R\u0001\tM&\u00148\u000f^*fcB\u0011\u0001BR\u0005\u0003\u000f&\u00111!\u00138u\u0011\u0015I\u0005\b1\u0001F\u0003\u001da\u0017m\u001d;TKFDQa\u0013\u0001\u0005\n1\u000b!b\u00195fG.,\u0005o\\2i)\tYT\nC\u0003@\u0015\u0002\u0007\u0001\tC\u0003P\u0001\u0011%\u0001+A\u0007dQ\u0016\u001c7nU3rk\u0016t7-\u001a\u000b\u0005wE\u00136\u000bC\u0003@\u001d\u0002\u0007\u0001\tC\u0003E\u001d\u0002\u0007Q\tC\u0003J\u001d\u0002\u0007Q\tC\u0003V\u0001\u0011%a+A\u0006jg\u0012+\b\u000f\\5dCR,GcA,[7B\u0011\u0001\u0002W\u0005\u00033&\u0011qAQ8pY\u0016\fg\u000eC\u0003E)\u0002\u0007Q\tC\u0003J)\u0002\u0007Q\tC\u0003^\u0001\u0011%a,\u0001\u0006j]N+\u0017/^3oG\u0016$2aV0a\u0011\u0015!E\f1\u0001F\u0011\u0015IE\f1\u0001F\u0011\u0015\u0011\u0007\u0001\"\u0003d\u0003!I7OR3oG\u0016$GCA,e\u0011\u0015y\u0014\r1\u0001A\u0011\u00151\u0007\u0001\"\u0001h\u0003\u0019\t\u0007\u000f]3oIR\u0011\u0001N\u001c\t\u0004\u0011%\\\u0017B\u00016\n\u0005\u0019y\u0005\u000f^5p]B\u0011\u0011\u0004\\\u0005\u0003[\n\u0011AbQ8na2,G/\u001a3Uq:DQa\\3A\u0002A\fQAY1uG\"\u0004\"!]>\u000e\u0003IT!a\u001d;\u0002\rI,7m\u001c:e\u0015\t)h/\u0001\u0004d_6lwN\u001c\u0006\u0003\u000b]T!\u0001_=\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0018aA8sO&\u0011AP\u001d\u0002\f%\u0016\u001cwN\u001d3CCR\u001c\u0007\u000eC\u0003g\u0001\u0011\u0005a\u0010\u0006\u0007<\u007f\u0006\r\u0011QAA\u0004\u0003\u0017\ty\u0001\u0003\u0004\u0002\u0002u\u0004\r\u0001Q\u0001\u0006KB|7\r\u001b\u0005\u0006\tv\u0004\r!\u0012\u0005\u0006\u0013v\u0004\r!\u0012\u0005\u0007\u0003\u0013i\b\u0019A\t\u0002\u001b1\f7\u000f\u001e+j[\u0016\u001cH/Y7q\u0011\u0019\ti! a\u0001#\u0005QA.Y:u\u001f\u001a47/\u001a;\t\r\u0005EQ\u00101\u0001X\u0003=I7\u000f\u0016:b]N\f7\r^5p]\u0006d\u0007bBA\u000b\u0001\u0011\u0005\u0011qC\u0001\u0013CB\u0004XM\u001c3F]\u0012$\u0006P\\'be.,'\u000fF\u0005l\u00033\t\u0019#!\n\u0002*!A\u00111DA\n\u0001\u0004\ti\"\u0001\u0007f]\u0012$\u0006P\\'be.,'\u000fE\u0002r\u0003?I1!!\ts\u0005Q)e\u000e\u001a+sC:\u001c\u0018m\u0019;j_:l\u0015M]6fe\"1q(a\u0005A\u0002\u0001Cq!a\n\u0002\u0014\u0001\u0007\u0011#\u0001\u0004pM\u001a\u001cX\r\u001e\u0005\b\u0003W\t\u0019\u00021\u0001\u0012\u0003%!\u0018.\\3ti\u0006l\u0007\u000fC\u0004\u00020\u0001!\t!!\r\u0002\u00171\fG/Z:u\u000b:$(/_\u000b\u00021!9\u0011Q\u0007\u0001\u0005\u0002\u0005]\u0012aE:uCJ$X\r\u001a+sC:\u001c\u0018m\u0019;j_:\u001cXCAA\u001d!\u0015\tY$a\u00134\u001d\u0011\ti$a\u0012\u000f\t\u0005}\u0012QI\u0007\u0003\u0003\u0003R1!a\u0011\u0010\u0003\u0019a$o\\8u}%\t!\"C\u0002\u0002J%\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002N\u0005=#\u0001\u0002'jgRT1!!\u0013\n\u0011\u001d\t\u0019\u0006\u0001C\u0001\u0003+\n\u0001%\\1zE\u0016\u001c\u0015m\u00195f)btg)\u001b:ti>3gm]3u\u001b\u0016$\u0018\rZ1uCR\u00191(a\u0016\t\u0011\u0005e\u0013\u0011\u000ba\u0001\u00037\n\u0011\u0003\\8h\u001f\u001a47/\u001a;NKR\fG-\u0019;b!\u0011\ti&a\u0019\u000e\u0005\u0005}#bAA1\t\u000511/\u001a:wKJLA!!\u001a\u0002`\t\tBj\\4PM\u001a\u001cX\r^'fi\u0006$\u0017\r^1\t\u000f\u0005%\u0004\u0001\"\u0011\u0002l\u0005AAo\\*ue&tw\r\u0006\u0002\u0002nA!\u0011qNA<\u001d\u0011\t\t(a\u001d\u0011\u0007\u0005}\u0012\"C\u0002\u0002v%\ta\u0001\u0015:fI\u00164\u0017\u0002BA=\u0003w\u0012aa\u0015;sS:<'bAA;\u0013\u0001")
public class ProducerAppendInfo {
    private final long producerId;
    private final ProducerIdEntry currentEntry;
    private final ValidationType validationType;
    private final ListBuffer<TxnMetadata> transactions;

    public long producerId() {
        return this.producerId;
    }

    private ListBuffer<TxnMetadata> transactions() {
        return this.transactions;
    }

    private void maybeValidateAppend(short producerEpoch, int firstSeq, int lastSeq) {
        ValidationType validationType = this.validationType;
        if (ValidationType$None$.MODULE$.equals(validationType)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ValidationType$EpochOnly$.MODULE$.equals(validationType)) {
            this.checkEpoch(producerEpoch);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ValidationType$Full$.MODULE$.equals(validationType)) {
            this.checkEpoch(producerEpoch);
            this.checkSequence(producerEpoch, firstSeq, lastSeq);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)validationType);
        }
    }

    private void checkEpoch(short producerEpoch) {
        if (this.isFenced(producerEpoch)) {
            throw new ProducerFencedException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Producer's epoch is no longer valid. There is probably another producer "})).s((Seq)Nil$.MODULE$) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"with a newer epoch. ", " (request epoch), ", " (server epoch)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)producerEpoch), BoxesRunTime.boxToShort((short)this.currentEntry.producerEpoch())})));
        }
    }

    private void checkSequence(short producerEpoch, int firstSeq, int lastSeq) {
        if (producerEpoch != this.currentEntry.producerEpoch()) {
            if (firstSeq != 0) {
                if (this.currentEntry.producerEpoch() != -1) {
                    throw new OutOfOrderSequenceException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid sequence number for new epoch: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)producerEpoch)})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(request epoch), ", " (seq. number)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)firstSeq)})));
                }
                throw new UnknownProducerIdException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found no record of producerId=", " on the broker. It is possible "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.producerId())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"that the last message with the producerId=", " has been removed due to hitting the retention limit."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.producerId())})));
            }
        } else {
            if (this.currentEntry.lastSeq() == -1 && firstSeq != 0) {
                throw new OutOfOrderSequenceException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Out of order sequence number for producerId ", ": found ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.producerId()), BoxesRunTime.boxToInteger((int)firstSeq)})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(incoming seq. number), but expected 0"})).s((Seq)Nil$.MODULE$));
            }
            if (this.isDuplicate(firstSeq, lastSeq)) {
                throw new DuplicateSequenceException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Duplicate sequence number for producerId ", ": (incomingBatch.firstSeq, "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.producerId())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"incomingBatch.lastSeq): (", ", ", ")."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)firstSeq), BoxesRunTime.boxToInteger((int)lastSeq)})));
            }
            if (!this.inSequence(firstSeq, lastSeq)) {
                throw new OutOfOrderSequenceException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Out of order sequence number for producerId ", ": ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.producerId()), BoxesRunTime.boxToInteger((int)firstSeq)})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(incoming seq. number), ", " (current end sequence number)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.currentEntry.lastSeq())})));
            }
        }
    }

    private boolean isDuplicate(int firstSeq, int lastSeq) {
        return lastSeq != 0 && this.currentEntry.firstSeq() != Integer.MAX_VALUE && lastSeq < this.currentEntry.firstSeq() || this.currentEntry.batchWithSequenceRange(firstSeq, lastSeq).isDefined();
    }

    private boolean inSequence(int firstSeq, int lastSeq) {
        return (long)firstSeq == (long)this.currentEntry.lastSeq() + 1L || firstSeq == 0 && this.currentEntry.lastSeq() == Integer.MAX_VALUE;
    }

    private boolean isFenced(short producerEpoch) {
        return producerEpoch < this.currentEntry.producerEpoch();
    }

    public Option<CompletedTxn> append(RecordBatch batch) {
        None$ none$;
        if (batch.isControlBatch()) {
            Record record = (Record)batch.iterator().next();
            EndTransactionMarker endTxnMarker = EndTransactionMarker.deserialize((Record)record);
            CompletedTxn completedTxn = this.appendEndTxnMarker(endTxnMarker, batch.producerEpoch(), batch.baseOffset(), record.timestamp());
            none$ = new Some((Object)completedTxn);
        } else {
            this.append(batch.producerEpoch(), batch.baseSequence(), batch.lastSequence(), batch.maxTimestamp(), batch.lastOffset(), batch.isTransactional());
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public void append(short epoch, int firstSeq, int lastSeq, long lastTimestamp, long lastOffset, boolean isTransactional) {
        block1: {
            this.maybeValidateAppend(epoch, firstSeq, lastSeq);
            this.currentEntry.addBatchMetadata(epoch, lastSeq, lastOffset, lastSeq - firstSeq, lastTimestamp);
            if (this.currentEntry.currentTxnFirstOffset().isDefined() && !isTransactional) {
                throw new InvalidTxnStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected transactional write from producer ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.producerId())})));
            }
            if (!isTransactional || !this.currentEntry.currentTxnFirstOffset().isEmpty()) break block1;
            long firstOffset = lastOffset - (long)(lastSeq - firstSeq);
            this.currentEntry.currentTxnFirstOffset_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)firstOffset)));
            this.transactions().$plus$eq((Object)new TxnMetadata(this.producerId(), firstOffset));
        }
    }

    public CompletedTxn appendEndTxnMarker(EndTransactionMarker endTxnMarker, short producerEpoch, long offset, long timestamp) {
        long l;
        if (this.isFenced(producerEpoch)) {
            throw new ProducerFencedException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid producer epoch: ", " (zombie): ", " (current)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)producerEpoch), BoxesRunTime.boxToShort((short)this.currentEntry.producerEpoch())})));
        }
        if (this.currentEntry.coordinatorEpoch() > endTxnMarker.coordinatorEpoch()) {
            throw new TransactionCoordinatorFencedException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid coordinator epoch: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)endTxnMarker.coordinatorEpoch())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(zombie), ", " (current)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.currentEntry.coordinatorEpoch())})));
        }
        this.currentEntry.maybeUpdateEpoch(producerEpoch);
        Option<Object> option = this.currentEntry.currentTxnFirstOffset();
        if (option instanceof Some) {
            long txnFirstOffset;
            Some some = (Some)option;
            l = txnFirstOffset = BoxesRunTime.unboxToLong((Object)some.value());
        } else if (None$.MODULE$.equals(option)) {
            this.transactions().$plus$eq((Object)new TxnMetadata(this.producerId(), offset));
            l = offset;
        } else {
            throw new MatchError(option);
        }
        long firstOffset = l;
        this.currentEntry.currentTxnFirstOffset_$eq((Option<Object>)None$.MODULE$);
        this.currentEntry.coordinatorEpoch_$eq(endTxnMarker.coordinatorEpoch());
        ControlRecordType controlRecordType = endTxnMarker.controlType();
        ControlRecordType controlRecordType2 = ControlRecordType.ABORT;
        return new CompletedTxn(this.producerId(), firstOffset, offset, !(controlRecordType != null ? !controlRecordType.equals(controlRecordType2) : controlRecordType2 != null));
    }

    public ProducerIdEntry latestEntry() {
        return this.currentEntry;
    }

    public List<TxnMetadata> startedTransactions() {
        return this.transactions().toList();
    }

    public void maybeCacheTxnFirstOffsetMetadata(LogOffsetMetadata logOffsetMetadata) {
        this.transactions().headOption().foreach((Function1 & Serializable & scala.Serializable)txn -> {
            ProducerAppendInfo.$anonfun$maybeCacheTxnFirstOffsetMetadata$1(logOffsetMetadata, txn);
            return BoxedUnit.UNIT;
        });
    }

    public String toString() {
        return "ProducerAppendInfo(" + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"producerId=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.producerId())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"producerEpoch=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)this.currentEntry.producerEpoch())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"firstSequence=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.currentEntry.firstSeq())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"lastSequence=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.currentEntry.lastSeq())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"currentTxnFirstOffset=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.currentEntry.currentTxnFirstOffset()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coordinatorEpoch=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.currentEntry.coordinatorEpoch())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"startedTransactions=", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.transactions()}));
    }

    public static final /* synthetic */ void $anonfun$maybeCacheTxnFirstOffsetMetadata$1(LogOffsetMetadata logOffsetMetadata$1, TxnMetadata txn) {
        block0: {
            if (txn.firstOffset().messageOffset() != logOffsetMetadata$1.messageOffset()) break block0;
            txn.firstOffset_$eq(logOffsetMetadata$1);
        }
    }

    public ProducerAppendInfo(long producerId, ProducerIdEntry currentEntry, ValidationType validationType) {
        this.producerId = producerId;
        this.currentEntry = currentEntry;
        this.validationType = validationType;
        this.transactions = (ListBuffer)ListBuffer$.MODULE$.empty();
    }
}

