/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import java.io.Serializable;
import kafka.cluster.BrokerEndPoint;
import kafka.metrics.KafkaYammerMetrics;
import kafka.server.AbstractFetcherManager;
import kafka.server.AbstractFetcherThread;
import kafka.server.InitialFetchState;
import kafka.server.OffsetAndEpoch;
import kafka.server.PartitionFetchState;
import kafka.server.ReplicaState;
import kafka.server.Truncating$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableFactory;
import scala.collection.Map;
import scala.collection.MapFactory;
import scala.collection.MapOps;
import scala.collection.Set;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u00053Aa\u0002\u0005\u0001\u001b!)A\u0003\u0001C\u0001+!)\u0001\u0004\u0001C\u00013!)a\u0005\u0001C\u0005O!)\u0001\b\u0001C\u00013!)Q\b\u0001C\u00013!)q\b\u0001C\u00013\tQ\u0012IY:ue\u0006\u001cGOR3uG\",'/T1oC\u001e,'\u000fV3ti*\u0011\u0011BC\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003-\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\f\u0011\u0005]\u0001Q\"\u0001\u0005\u0002'\rdW-\u00198NKR\u0014\u0018n\u0019*fO&\u001cHO]=\u0015\u0003i\u0001\"aD\u000e\n\u0005q\u0001\"\u0001B+oSRD#A\u0001\u0010\u0011\u0005}!S\"\u0001\u0011\u000b\u0005\u0005\u0012\u0013!\u00026v]&$(\"A\u0012\u0002\u0007=\u0014x-\u0003\u0002&A\t1!)\u001a4pe\u0016\fabZ3u\u001b\u0016$(/[2WC2,X\r\u0006\u0002)WA\u0011q\"K\u0005\u0003UA\u00111!\u00118z\u0011\u0015a3\u00011\u0001.\u0003\u0011q\u0017-\\3\u0011\u00059*dBA\u00184!\t\u0001\u0004#D\u00012\u0015\t\u0011D\"\u0001\u0004=e>|GOP\u0005\u0003iA\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001c8\u0005\u0019\u0019FO]5oO*\u0011A\u0007E\u0001\u001ai\u0016\u001cH/\u00113e\u0003:$'+Z7pm\u0016\u0004\u0016M\u001d;ji&|g\u000e\u000b\u0002\u0005uA\u0011qdO\u0005\u0003y\u0001\u0012A\u0001V3ti\u0006qB/Z:u\u001b\u0016$(/[2GC&dW\r\u001a)beRLG/[8o\u0007>,h\u000e\u001e\u0015\u0003\u000bi\n\u0011\u0004^3ti\u0012+\u0017\r\u001a+ie\u0016\fGmQ8v]RlU\r\u001e:jG\"\u0012aA\u000f")
public class AbstractFetcherManagerTest {
    @Before
    public void cleanMetricRegistry() {
        TestUtils$.MODULE$.clearYammerMetrics();
    }

    private Object getMetricValue(String name) {
        return ((Gauge)((MapOps)AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.Map)KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManagerTest.$anonfun$getMetricValue$1(name, x0$1)))).values().headOption().get()).value();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAddAndRemovePartition() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        void apply_state;
        void apply_elems4;
        void apply_elems5;
        AbstractFetcherThread fetcher = (AbstractFetcherThread)EasyMock.mock(AbstractFetcherThread.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher){
            private final AbstractFetcherThread fetcher$1;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker) {
                return this.fetcher$1;
            }
            {
                this.fetcher$1 = fetcher$1;
                super("fetcher-manager", "fetcher-manager", 2);
            }
        };
        long fetchOffset = 10L;
        int leaderEpoch = 15;
        TopicPartition tp = new TopicPartition("topic", 0);
        InitialFetchState initialFetchState = new InitialFetchState(new BrokerEndPoint(0, "localhost", 9092), leaderEpoch, fetchOffset);
        fetcher.start();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        OffsetAndEpoch $minus$greater$extension_y = new OffsetAndEpoch(fetchOffset, leaderEpoch);
        Object var8_7 = null;
        objectArray[0] = new Tuple2((Object)tp, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp});
        if (set$ == null) {
            throw null;
        }
        arraySeq2 = null;
        EasyMock.expect((Object)fetcher.addPartitions((Map)MapFactory.apply$((MapFactory)map$, (Seq)apply_elems5))).andReturn(IterableFactory.apply$((IterableFactory)set$, (Seq)apply_elems4));
        Truncating$ truncating$ = Truncating$.MODULE$;
        None$ apply_lag = None$.MODULE$;
        Object var14_11 = null;
        truncating$ = null;
        EasyMock.expect((Object)fetcher.fetchState(tp)).andReturn((Object)new Some((Object)new PartitionFetchState(fetchOffset, (Option)apply_lag, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)apply_state)));
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp});
        if (set$2 == null) {
            throw null;
        }
        arraySeq3 = null;
        fetcher.removePartitions((Set)IterableFactory.apply$((IterableFactory)set$2, (Seq)apply_elems3));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)fetcher.fetchState(tp)).andReturn((Object)None$.MODULE$);
        EasyMock.replay((Object[])new Object[]{fetcher});
        Map$ map$2 = Predef$.MODULE$.Map();
        Object[] objectArray2 = new Tuple2[1];
        objectArray2[0] = new Tuple2((Object)tp, (Object)initialFetchState);
        ArraySeq arraySeq4 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray2);
        if (map$2 == null) {
            throw null;
        }
        arraySeq4 = null;
        fetcherManager.addFetcherForPartitions((Map)MapFactory.apply$((MapFactory)map$2, (Seq)apply_elems2));
        Assert.assertEquals((Object)new Some((Object)fetcher), (Object)fetcherManager.getFetcher(tp));
        Set$ set$3 = Predef$.MODULE$.Set();
        ArraySeq arraySeq5 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp});
        if (set$3 == null) {
            throw null;
        }
        arraySeq5 = null;
        fetcherManager.removeFetcherForPartitions((Set)IterableFactory.apply$((IterableFactory)set$3, (Seq)apply_elems));
        Assert.assertEquals((Object)None$.MODULE$, (Object)fetcherManager.getFetcher(tp));
        EasyMock.verify((Object[])new Object[]{fetcher});
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMetricFailedPartitionCount() {
        void apply_elems;
        AbstractFetcherThread fetcher = (AbstractFetcherThread)EasyMock.mock(AbstractFetcherThread.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher){
            private final AbstractFetcherThread fetcher$2;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker) {
                return this.fetcher$2;
            }
            {
                this.fetcher$2 = fetcher$2;
                super("fetcher-manager", "fetcher-manager", 2);
            }
        };
        TopicPartition tp = new TopicPartition("topic", 0);
        String metricName = "FailedPartitionsCount";
        Assert.assertEquals((Object)0, (Object)this.getMetricValue(metricName));
        fetcherManager.failedPartitions().add(tp);
        Assert.assertEquals((Object)1, (Object)this.getMetricValue(metricName));
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        fetcherManager.removeFetcherForPartitions((Set)IterableFactory.apply$((IterableFactory)set$, (Seq)apply_elems));
        Assert.assertEquals((Object)0, (Object)this.getMetricValue(metricName));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeadThreadCountMetric() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        AbstractFetcherThread fetcher = (AbstractFetcherThread)EasyMock.mock(AbstractFetcherThread.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher){
            private final AbstractFetcherThread fetcher$3;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker) {
                return this.fetcher$3;
            }
            {
                this.fetcher$3 = fetcher$3;
                super("fetcher-manager", "fetcher-manager", 2);
            }
        };
        long fetchOffset = 10L;
        int leaderEpoch = 15;
        TopicPartition tp = new TopicPartition("topic", 0);
        InitialFetchState initialFetchState = new InitialFetchState(new BrokerEndPoint(0, "localhost", 9092), leaderEpoch, fetchOffset);
        fetcher.start();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        OffsetAndEpoch $minus$greater$extension_y = new OffsetAndEpoch(fetchOffset, leaderEpoch);
        Object var8_7 = null;
        objectArray[0] = new Tuple2((Object)tp, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp});
        if (set$ == null) {
            throw null;
        }
        arraySeq2 = null;
        EasyMock.expect((Object)fetcher.addPartitions((Map)MapFactory.apply$((MapFactory)map$, (Seq)apply_elems3))).andReturn(IterableFactory.apply$((IterableFactory)set$, (Seq)apply_elems2));
        EasyMock.expect((Object)fetcher.isThreadFailed()).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{fetcher});
        Map$ map$2 = Predef$.MODULE$.Map();
        Object[] objectArray2 = new Tuple2[1];
        objectArray2[0] = new Tuple2((Object)tp, (Object)initialFetchState);
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray2);
        if (map$2 == null) {
            throw null;
        }
        arraySeq3 = null;
        fetcherManager.addFetcherForPartitions((Map)MapFactory.apply$((MapFactory)map$2, (Seq)apply_elems));
        Assert.assertEquals((long)1L, (long)fetcherManager.deadThreadCount());
        EasyMock.verify((Object[])new Object[]{fetcher});
        EasyMock.reset((Object[])new Object[]{fetcher});
        EasyMock.expect((Object)fetcher.isThreadFailed()).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{fetcher});
        Assert.assertEquals((long)0L, (long)fetcherManager.deadThreadCount());
        EasyMock.verify((Object[])new Object[]{fetcher});
    }

    public static final /* synthetic */ boolean $anonfun$getMetricValue$1(String name$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        String string = ((MetricName)x0$1._1()).getName();
        boolean bl = !(string != null ? !string.equals(name$1) : name$1 != null);
        return bl;
    }
}

