/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Optional;
import kafka.cluster.Partition;
import kafka.log.Log$;
import kafka.log.LogOffsetSnapshot;
import kafka.server.DelayedFetch;
import kafka.server.FetchDataInfo;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.FetchMetadata;
import kafka.server.FetchPartitionData;
import kafka.server.FetchPartitionStatus;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.FencedLeaderEpochException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.FetchRequest;
import org.easymock.EasyMock;
import org.easymock.EasyMockSupport;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005m4AAD\b\u0001)!)Q\u0004\u0001C\u0001=!9\u0011\u0005\u0001b\u0001\n\u0013\u0011\u0003BB\u0015\u0001A\u0003%1\u0005C\u0004+\u0001\t\u0007I\u0011B\u0016\t\r=\u0002\u0001\u0015!\u0003-\u0011\u001d\u0001\u0004A1A\u0005\nEBa!\u000e\u0001!\u0002\u0013\u0011\u0004\"\u0002\u001c\u0001\t\u00039\u0004\"\u0002\"\u0001\t\u00039\u0004\"\u0002#\u0001\t\u00039\u0004\"\u0002$\u0001\t\u00139\u0005\"B/\u0001\t\u0013q\u0006\"B;\u0001\t\u00131(\u0001\u0005#fY\u0006LX\r\u001a$fi\u000eDG+Z:u\u0015\t\u0001\u0012#\u0001\u0004tKJ4XM\u001d\u0006\u0002%\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0016!\t12$D\u0001\u0018\u0015\tA\u0012$\u0001\u0005fCNLXn\\2l\u0015\u0005Q\u0012aA8sO&\u0011Ad\u0006\u0002\u0010\u000b\u0006\u001c\u00180T8dWN+\b\u000f]8si\u00061A(\u001b8jiz\"\u0012a\b\t\u0003A\u0001i\u0011aD\u0001\t[\u0006D()\u001f;fgV\t1\u0005\u0005\u0002%O5\tQEC\u0001'\u0003\u0015\u00198-\u00197b\u0013\tASEA\u0002J]R\f\u0011\"\\1y\u0005f$Xm\u001d\u0011\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feV\tA\u0006\u0005\u0002![%\u0011af\u0004\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003=\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\u0013\u0001\u0004:fa2L7-Y)v_R\fW#\u0001\u001a\u0011\u0005\u0001\u001a\u0014B\u0001\u001b\u0010\u00051\u0011V\r\u001d7jG\u0006\fVo\u001c;b\u00035\u0011X\r\u001d7jG\u0006\fVo\u001c;bA\u0005AB/Z:u\r\u0016$8\r[,ji\"4UM\\2fI\u0016\u0003xn\u00195\u0015\u0003a\u0002\"\u0001J\u001d\n\u0005i*#\u0001B+oSRD#\u0001\u0003\u001f\u0011\u0005u\u0002U\"\u0001 \u000b\u0005}J\u0012!\u00026v]&$\u0018BA!?\u0005\u0011!Vm\u001d;\u0002/Q,7\u000f\u001e(pi2+\u0017\rZ3s\u001fJ4u\u000e\u001c7po\u0016\u0014\bFA\u0005=\u0003I!Xm\u001d;ESZ,'oZ5oO\u0016\u0003xn\u00195)\u0005)a\u0014A\u00052vS2$g)\u001a;dQ6+G/\u00193bi\u0006$B\u0001S&N1B\u0011\u0001%S\u0005\u0003\u0015>\u0011QBR3uG\"lU\r^1eCR\f\u0007\"\u0002'\f\u0001\u0004\u0019\u0013!\u0003:fa2L7-Y%e\u0011\u0015q5\u00021\u0001P\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\"\u0001\u0015,\u000e\u0003ES!AU*\u0002\r\r|W.\\8o\u0015\t\u0011BK\u0003\u0002V3\u00051\u0011\r]1dQ\u0016L!aV)\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\")\u0011l\u0003a\u00015\u0006Ya-\u001a;dQN#\u0018\r^;t!\t\u00013,\u0003\u0002]\u001f\t!b)\u001a;dQB\u000b'\u000f^5uS>t7\u000b^1ukN\fQ#\u001a=qK\u000e$(+Z1e\rJ|WNU3qY&\u001c\u0017\rF\u00039?\u0002\fW\u000eC\u0003M\u0019\u0001\u00071\u0005C\u0003O\u0019\u0001\u0007q\nC\u0003c\u0019\u0001\u00071-\u0001\ngKR\u001c\u0007\u000eU1si&$\u0018n\u001c8ECR\f\u0007C\u00013k\u001d\t)\u0007.D\u0001g\u0015\t9\u0017+\u0001\u0005sKF,Xm\u001d;t\u0013\tIg-\u0001\u0007GKR\u001c\u0007NU3rk\u0016\u001cH/\u0003\u0002lY\ni\u0001+\u0019:uSRLwN\u001c#bi\u0006T!!\u001b4\t\u000b9d\u0001\u0019A8\u0002\u000b\u0015\u0014(o\u001c:\u0011\u0005A\u001cX\"A9\u000b\u0005I\f\u0016\u0001\u00039s_R|7m\u001c7\n\u0005Q\f(AB#se>\u00148/A\bck&dGMU3bIJ+7/\u001e7u)\t9(\u0010\u0005\u0002!q&\u0011\u0011p\u0004\u0002\u000e\u0019><'+Z1e%\u0016\u001cX\u000f\u001c;\t\u000b9l\u0001\u0019A8")
public class DelayedFetchTest
extends EasyMockSupport {
    private final int maxBytes;
    private final ReplicaManager replicaManager = (ReplicaManager)this.mock(ReplicaManager.class);
    private final ReplicaQuota replicaQuota = (ReplicaQuota)this.mock(ReplicaQuota.class);

    private int maxBytes() {
        return this.maxBytes;
    }

    private ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    private ReplicaQuota replicaQuota() {
        return this.replicaQuota;
    }

    @Test
    public void testFetchWithFencedEpoch() {
        ObjectRef objectRef;
        TopicPartition topicPartition = new TopicPartition("topic", 0);
        long fetchOffset = 500L;
        long logStartOffset = 0L;
        Optional<Integer> currentLeaderEpoch = Optional.of(10);
        int replicaId = 1;
        FetchPartitionStatus fetchStatus = new FetchPartitionStatus(new LogOffsetMetadata(fetchOffset, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), new FetchRequest.PartitionData(fetchOffset, logStartOffset, this.maxBytes(), currentLeaderEpoch));
        FetchMetadata fetchMetadata = this.buildFetchMetadata(replicaId, topicPartition, fetchStatus);
        None$ create_e = None$.MODULE$;
        ObjectRef objectRef2 = objectRef = new ObjectRef((Object)create_e);
        Object var14_8 = null;
        objectRef = null;
        ObjectRef fetchResultOpt = objectRef2;
        DelayedFetch delayedFetch = new DelayedFetch(500L, fetchMetadata, this.replicaManager(), this.replicaQuota(), (Option)None$.MODULE$, (Function1 & Serializable)responses -> {
            DelayedFetchTest.callback$1(responses, fetchResultOpt);
            return BoxedUnit.UNIT;
        });
        Partition partition = (Partition)this.mock(Partition.class);
        EasyMock.expect((Object)this.replicaManager().getPartitionOrException(topicPartition)).andReturn((Object)partition);
        EasyMock.expect((Object)partition.fetchOffsetSnapshot(currentLeaderEpoch, true)).andThrow((Throwable)new FencedLeaderEpochException("Requested epoch has been fenced"));
        EasyMock.expect((Object)this.replicaManager().isAddingReplica((TopicPartition)EasyMock.anyObject(), EasyMock.anyInt())).andReturn((Object)false);
        this.expectReadFromReplica(replicaId, topicPartition, fetchStatus.fetchInfo(), Errors.FENCED_LEADER_EPOCH);
        this.replayAll();
        Assert.assertTrue((boolean)delayedFetch.tryComplete());
        Assert.assertTrue((boolean)delayedFetch.isCompleted());
        Assert.assertTrue((boolean)((Option)fetchResultOpt.elem).isDefined());
        FetchPartitionData fetchResult = (FetchPartitionData)((Option)fetchResultOpt.elem).get();
        Assert.assertEquals((Object)Errors.FENCED_LEADER_EPOCH, (Object)fetchResult.error());
    }

    @Test
    public void testNotLeaderOrFollower() {
        ObjectRef objectRef;
        TopicPartition topicPartition = new TopicPartition("topic", 0);
        long fetchOffset = 500L;
        long logStartOffset = 0L;
        Optional<Integer> currentLeaderEpoch = Optional.of(10);
        int replicaId = 1;
        FetchPartitionStatus fetchStatus = new FetchPartitionStatus(new LogOffsetMetadata(fetchOffset, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), new FetchRequest.PartitionData(fetchOffset, logStartOffset, this.maxBytes(), currentLeaderEpoch));
        FetchMetadata fetchMetadata = this.buildFetchMetadata(replicaId, topicPartition, fetchStatus);
        None$ create_e = None$.MODULE$;
        ObjectRef objectRef2 = objectRef = new ObjectRef((Object)create_e);
        Object var12_8 = null;
        objectRef = null;
        ObjectRef fetchResultOpt = objectRef2;
        DelayedFetch delayedFetch = new DelayedFetch(500L, fetchMetadata, this.replicaManager(), this.replicaQuota(), (Option)None$.MODULE$, (Function1 & Serializable)responses -> {
            DelayedFetchTest.callback$2(responses, fetchResultOpt);
            return BoxedUnit.UNIT;
        });
        EasyMock.expect((Object)this.replicaManager().getPartitionOrException(topicPartition)).andThrow((Throwable)new NotLeaderOrFollowerException(new StringBuilder(26).append("Replica for ").append(topicPartition).append(" not available").toString()));
        this.expectReadFromReplica(replicaId, topicPartition, fetchStatus.fetchInfo(), Errors.NOT_LEADER_OR_FOLLOWER);
        EasyMock.expect((Object)this.replicaManager().isAddingReplica((TopicPartition)EasyMock.anyObject(), EasyMock.anyInt())).andReturn((Object)false);
        this.replayAll();
        Assert.assertTrue((boolean)delayedFetch.tryComplete());
        Assert.assertTrue((boolean)delayedFetch.isCompleted());
        Assert.assertTrue((boolean)((Option)fetchResultOpt.elem).isDefined());
    }

    @Test
    public void testDivergingEpoch() {
        ObjectRef objectRef;
        TopicPartition topicPartition = new TopicPartition("topic", 0);
        long fetchOffset = 500L;
        long logStartOffset = 0L;
        Optional<Integer> currentLeaderEpoch = Optional.of(10);
        Optional<Integer> lastFetchedEpoch = Optional.of(9);
        int replicaId = 1;
        FetchPartitionStatus fetchStatus = new FetchPartitionStatus(new LogOffsetMetadata(fetchOffset, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), new FetchRequest.PartitionData(fetchOffset, logStartOffset, this.maxBytes(), currentLeaderEpoch, lastFetchedEpoch));
        FetchMetadata fetchMetadata = this.buildFetchMetadata(replicaId, topicPartition, fetchStatus);
        None$ create_e = None$.MODULE$;
        ObjectRef objectRef2 = objectRef = new ObjectRef((Object)create_e);
        Object var15_9 = null;
        objectRef = null;
        ObjectRef fetchResultOpt = objectRef2;
        DelayedFetch delayedFetch = new DelayedFetch(500L, fetchMetadata, this.replicaManager(), this.replicaQuota(), (Option)None$.MODULE$, (Function1 & Serializable)responses -> {
            DelayedFetchTest.callback$3(responses, fetchResultOpt);
            return BoxedUnit.UNIT;
        });
        Partition partition = (Partition)this.mock(Partition.class);
        EasyMock.expect((Object)this.replicaManager().getPartitionOrException(topicPartition)).andReturn((Object)partition);
        LogOffsetMetadata endOffsetMetadata = new LogOffsetMetadata(500L, 0L, 500);
        EasyMock.expect((Object)partition.fetchOffsetSnapshot(currentLeaderEpoch, true)).andReturn((Object)new LogOffsetSnapshot(0L, endOffsetMetadata, endOffsetMetadata, endOffsetMetadata));
        EasyMock.expect((Object)partition.lastOffsetForLeaderEpoch(currentLeaderEpoch, BoxesRunTime.unboxToInt((Object)lastFetchedEpoch.get()), false)).andReturn((Object)new EpochEndOffset(Errors.NONE, BoxesRunTime.unboxToInt((Object)lastFetchedEpoch.get()), fetchOffset - 1L));
        EasyMock.expect((Object)this.replicaManager().isAddingReplica((TopicPartition)EasyMock.anyObject(), EasyMock.anyInt())).andReturn((Object)false);
        this.expectReadFromReplica(replicaId, topicPartition, fetchStatus.fetchInfo(), Errors.NONE);
        this.replayAll();
        Assert.assertTrue((boolean)delayedFetch.tryComplete());
        Assert.assertTrue((boolean)delayedFetch.isCompleted());
        Assert.assertTrue((boolean)((Option)fetchResultOpt.elem).isDefined());
    }

    private FetchMetadata buildFetchMetadata(int replicaId, TopicPartition topicPartition, FetchPartitionStatus fetchStatus) {
        return new FetchMetadata(1, this.maxBytes(), false, true, (FetchIsolation)FetchLogEnd$.MODULE$, true, replicaId, (Seq)new .colon.colon((Object)new Tuple2((Object)topicPartition, (Object)fetchStatus), (List)Nil$.MODULE$));
    }

    private void expectReadFromReplica(int replicaId, TopicPartition topicPartition, FetchRequest.PartitionData fetchPartitionData, Errors error) {
        FetchLogEnd$ x$3 = FetchLogEnd$.MODULE$;
        int x$4 = this.maxBytes();
        .colon.colon x$6 = new .colon.colon((Object)new Tuple2((Object)topicPartition, (Object)fetchPartitionData), (List)Nil$.MODULE$);
        None$ x$7 = None$.MODULE$;
        ReplicaQuota x$8 = this.replicaQuota();
        EasyMock.expect((Object)this.replicaManager().readFromLocalLog(replicaId, true, (FetchIsolation)x$3, x$4, false, (Seq)x$6, x$8, (Option)x$7)).andReturn((Object)new .colon.colon((Object)new Tuple2((Object)topicPartition, (Object)this.buildReadResult(error)), (List)Nil$.MODULE$));
    }

    private LogReadResult buildReadResult(Errors error) {
        None$ none$;
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        None$ x$1 = (errors == null ? errors2 != null : !errors.equals(errors2)) ? new Some((Object)error.exception()) : None$.MODULE$;
        FetchDataInfo x$2 = new FetchDataInfo(LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata(), (Records)MemoryRecords.EMPTY, false, (Option)None$.MODULE$);
        None$ x$3 = None$.MODULE$;
        None$ x$9 = None$.MODULE$;
        None$ none$2 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$10 = none$2;
        return new LogReadResult(x$2, (Option)x$3, -1L, -1L, -1L, -1L, -1L, (Option)x$9, (Option)x$10, (Option)x$1);
    }

    private static final void callback$1(Seq responses, ObjectRef fetchResultOpt$1) {
        fetchResultOpt$1.elem = new Some(((Tuple2)responses.head())._2());
    }

    private static final void callback$2(Seq responses, ObjectRef fetchResultOpt$2) {
        fetchResultOpt$2.elem = new Some(((Tuple2)responses.head())._2());
    }

    private static final void callback$3(Seq responses, ObjectRef fetchResultOpt$3) {
        fetchResultOpt$3.elem = new Some(((Tuple2)responses.head())._2());
    }

    public DelayedFetchTest() {
        this.maxBytes = 1024;
    }
}

