/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.DataInputStream;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.Socket;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.api.KAFKA_0_11_0_IV2$;
import kafka.log.LogConfig$;
import kafka.message.GZIPCompressionCodec$;
import kafka.message.ProducerCompressionCodec$;
import kafka.message.ZStdCompressionCodec$;
import kafka.server.BaseRequestTest;
import kafka.server.FetchRequestTest$;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.AbstractRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.junit.Assert;
import org.junit.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BuildFrom$;
import scala.collection.BuildFromLowPriority2;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.MapFactory;
import scala.collection.Seq;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Builder;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0005\tma\u0001B\u0010!\u0001\u0015BQA\u000b\u0001\u0005\u0002-Bq!\f\u0001A\u0002\u0013%a\u0006C\u0004I\u0001\u0001\u0007I\u0011B%\t\rA\u0003\u0001\u0015)\u00030\u0011\u0015\t\u0006\u0001\"\u0011S\u0011\u0015i\u0006\u0001\"\u0011_\u0011\u0015y\u0006\u0001\"\u0003a\u0011\u001d\tI\u0001\u0001C\u0005\u0003\u0017A\u0011\"a\n\u0001#\u0003%I!!\u000b\t\u000f\u0005}\u0002\u0001\"\u0003\u0002B!1\u0011Q\f\u0001\u0005\nyCa!a\u0018\u0001\t\u0003q\u0006BBA8\u0001\u0011\u0005a\f\u0003\u0004\u0002t\u0001!\tA\u0018\u0005\u0007\u0003o\u0002A\u0011\u00010\t\r\u0005m\u0004\u0001\"\u0001_\u0011\u0019\ty\b\u0001C\u0001=\"1\u00111\u0011\u0001\u0005\u0002yCq!a\"\u0001\t\u0013\tI\t\u0003\u0004\u0002\u0018\u0002!\tA\u0018\u0005\u0007\u00037\u0003A\u0011\u00010\t\r\u0005}\u0005\u0001\"\u0001_\u0011\u0019\t\u0019\u000b\u0001C\u0001=\"1\u0011q\u0015\u0001\u0005\u0002yCa!a+\u0001\t\u0003q\u0006bBAX\u0001\u0011%\u0011\u0011\u0017\u0005\b\u0003\u0017\u0004A\u0011BAg\u0011\u001d\ty\u000e\u0001C\u0005\u0003CD\u0011\"a=\u0001#\u0003%I!!>\t\u000f\u0005e\b\u0001\"\u0003\u0002|\n\u0001b)\u001a;dQJ+\u0017/^3tiR+7\u000f\u001e\u0006\u0003C\t\naa]3sm\u0016\u0014(\"A\u0012\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\n\t\u0003O!j\u0011\u0001I\u0005\u0003S\u0001\u0012qBQ1tKJ+\u0017/^3tiR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00031\u0002\"a\n\u0001\u0002\u0011A\u0014x\u000eZ;dKJ,\u0012a\f\t\u0005aeZ4(D\u00012\u0015\ti#G\u0003\u00024i\u000591\r\\5f]R\u001c(BA\u00126\u0015\t1t'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002q\u0005\u0019qN]4\n\u0005i\n$!D&bM.\f\u0007K]8ek\u000e,'\u000f\u0005\u0002=\u000b:\u0011Qh\u0011\t\u0003}\u0005k\u0011a\u0010\u0006\u0003\u0001\u0012\na\u0001\u0010:p_Rt$\"\u0001\"\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\u000b\u0015A\u0002)sK\u0012,g-\u0003\u0002G\u000f\n11\u000b\u001e:j]\u001eT!\u0001R!\u0002\u0019A\u0014x\u000eZ;dKJ|F%Z9\u0015\u0005)s\u0005CA&M\u001b\u0005\t\u0015BA'B\u0005\u0011)f.\u001b;\t\u000f=\u001b\u0011\u0011!a\u0001_\u0005\u0019\u0001\u0010J\u0019\u0002\u0013A\u0014x\u000eZ;dKJ\u0004\u0013a\u00062s_.,'\u000f\u0015:pa\u0016\u0014H/_(wKJ\u0014\u0018\u000eZ3t)\tQ5\u000bC\u0003U\u000b\u0001\u0007Q+\u0001\u0006qe>\u0004XM\u001d;jKN\u0004\"AV.\u000e\u0003]S!\u0001W-\u0002\tU$\u0018\u000e\u001c\u0006\u00025\u0006!!.\u0019<b\u0013\tavK\u0001\u0006Qe>\u0004XM\u001d;jKN\f\u0001\u0002^3be\u0012{wO\u001c\u000b\u0002\u0015\u0006\u00112M]3bi\u00164U\r^2i%\u0016\fX/Z:u)\u0015\t\u0017N\u001c9}!\t\u0011w-D\u0001d\u0015\t!W-\u0001\u0005sKF,Xm\u001d;t\u0015\t1G'\u0001\u0004d_6lwN\\\u0005\u0003Q\u000e\u0014ABR3uG\"\u0014V-];fgRDQA[\u0004A\u0002-\f\u0001#\\1y%\u0016\u001c\bo\u001c8tK\nKH/Z:\u0011\u0005-c\u0017BA7B\u0005\rIe\u000e\u001e\u0005\u0006_\u001e\u0001\ra[\u0001\u0012[\u0006D\b+\u0019:uSRLwN\u001c\"zi\u0016\u001c\b\"B9\b\u0001\u0004\u0011\u0018a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\:\u0011\u0007M4\b0D\u0001u\u0015\t)\u0018)\u0001\u0006d_2dWm\u0019;j_:L!a\u001e;\u0003\u0007M+\u0017\u000f\u0005\u0002zu6\tQ-\u0003\u0002|K\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007\"B?\b\u0001\u0004q\u0018!C8gMN,G/T1q!\u0015at\u0010_A\u0002\u0013\r\t\ta\u0012\u0002\u0004\u001b\u0006\u0004\bcA&\u0002\u0006%\u0019\u0011qA!\u0003\t1{gnZ\u0001\u0013GJ,\u0017\r^3QCJ$\u0018\u000e^5p]6\u000b\u0007\u000f\u0006\u0005\u0002\u000e\u0005\u0005\u00121EA\u0013!\u00191\u0016q\u0002=\u0002\u0014%\u0019\u0011\u0011C,\u0003\u001b1Kgn[3e\u0011\u0006\u001c\b.T1q!\u0011\t)\"a\u0007\u000f\u0007\t\f9\"C\u0002\u0002\u001a\r\fABR3uG\"\u0014V-];fgRLA!!\b\u0002 \ti\u0001+\u0019:uSRLwN\u001c#bi\u0006T1!!\u0007d\u0011\u0015y\u0007\u00021\u0001l\u0011\u0015\t\b\u00021\u0001s\u0011\u001di\b\u0002%AA\u0002y\fAd\u0019:fCR,\u0007+\u0019:uSRLwN\\'ba\u0012\"WMZ1vYR$3'\u0006\u0002\u0002,)\u001aa0!\f,\u0005\u0005=\u0002\u0003BA\u0019\u0003wi!!a\r\u000b\t\u0005U\u0012qG\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u000fB\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003{\t\u0019DA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0001c]3oI\u001a+Go\u00195SKF,Xm\u001d;\u0015\r\u0005\r\u0013QKA-!\u0015\u0011\u0017QIA%\u0013\r\t9e\u0019\u0002\u000e\r\u0016$8\r\u001b*fgB|gn]3\u0011\t\u0005-\u0013\u0011K\u0007\u0003\u0003\u001bR1!a\u0014f\u0003\u0019\u0011XmY8sI&!\u00111KA'\u00055iU-\\8ssJ+7m\u001c:eg\"1\u0011q\u000b\u0006A\u0002-\f\u0001\u0002\\3bI\u0016\u0014\u0018\n\u001a\u0005\u0007\u00037R\u0001\u0019A1\u0002\u000fI,\u0017/^3ti\u0006a\u0011N\\5u!J|G-^2fe\u0006qC/Z:u\u0005J|7.\u001a:SKN\u0004Xm\u0019;t!\u0006\u0014H/\u001b;j_:\u001cxJ\u001d3fe\u0006sGmU5{K2KW.\u001b;tQ\ra\u00111\r\t\u0005\u0003K\nY'\u0004\u0002\u0002h)\u0019\u0011\u0011N\u001c\u0002\u000b),h.\u001b;\n\t\u00055\u0014q\r\u0002\u0005)\u0016\u001cH/\u0001\u0014uKN$h)\u001a;dQJ+\u0017/^3tiZ\u0013t+\u001b;i\u001fZ,'o]5{K\u0012lUm]:bO\u0016D3!DA2\u0003\r\"Xm\u001d;GKR\u001c\u0007NU3rk\u0016\u001cHO\u0016\u001bXSRD'+Z1e\u0007>lW.\u001b;uK\u0012D3ADA2\u0003q!Xm\u001d;GKR\u001c\u0007NU3rk\u0016\u001cH\u000fV8O_:\u0014V\r\u001d7jG\u0006D3aDA2\u0003y!Xm\u001d;MCN$h)\u001a;dQ\u0016$W\t]8dQZ\u000bG.\u001b3bi&|g\u000eK\u0002\u0011\u0003G\n!\u0004^3ti\u000e+(O]3oi\u0016\u0003xn\u00195WC2LG-\u0019;j_:D3!EA2\u0003\u0015\"Xm\u001d;Fa>\u001c\u0007NV1mS\u0012\fG/[8o/&$\b.\u001b8GKR\u001c\u0007nU3tg&|g\u000eK\u0002\u0013\u0003G\n\u0001D^3sS\u001aLh)\u001a;dQN+7o]5p]\u0016\u0013(o\u001c:t)\u001dQ\u00151RAH\u0003'Ca!!$\u0014\u0001\u0004A\u0018A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\u0007\u0003#\u001b\u0002\u0019A6\u0002\u00171,\u0017\rZ3s\u000bB|7\r\u001b\u0005\u0007\u0003+\u001b\u0002\u0019A6\u0002'\u0011,7\u000f^5oCRLwN\u001c\"s_.,'/\u00133\u0002OQ,7\u000f\u001e#po:\u001cuN\u001c<feNLwN\\,ji\"\u001cuN\u001c8fGRLwN\u001c$bS2,(/\u001a\u0015\u0004)\u0005\r\u0014A\u000e;fgR$un\u001e8D_:4XM]:j_:4%o\\7CCR\u001c\u0007.\u001a3U_Vs'-\u0019;dQ\u0016$'+Z:qK\u000e$8o\u00144gg\u0016$\bfA\u000b\u0002d\u0005yC/Z:u\u0007J,\u0017\r^3J]\u000e\u0014X-\\3oi\u0006dg)\u001a;dQ^KG\u000f\u001b)beRLG/[8og&sWI\u001d:pe\"\u001aa#a\u0019\u0002/Q,7\u000f\u001e.Ti\u0012\u001cu.\u001c9sKN\u001cX\r\u001a+pa&\u001c\u0007fA\f\u0002d\u00059B/Z:u!\u0006\u0014H/\u001b;j_:$\u0015\r^1FcV\fGn\u001d\u0015\u00041\u0005\r\u0014!\u0007;fgRT6\u000b\u001e3D_6\u0004(/Z:tK\u0012\u0014VmY8sIND3!GA2\u0003\u001d\u0011XmY8sIN$B!a-\u0002<B!1O^A[!\u0011\tY%a.\n\t\u0005e\u0016Q\n\u0002\u0007%\u0016\u001cwN\u001d3\t\u000f\u0005u&\u00041\u0001\u0002@\u0006i\u0001/\u0019:uSRLwN\u001c#bi\u0006\u0004b!!1\u0002H\u0006%cb\u00012\u0002D&\u0019\u0011QY2\u0002\u001b\u0019+Go\u00195SKN\u0004xN\\:f\u0013\u0011\ti\"!3\u000b\u0007\u0005\u00157-\u0001\ndQ\u0016\u001c7NR3uG\"\u0014Vm\u001d9p]N,Gc\u0003&\u0002P\u0006M\u0017q[Am\u00037Da!!5\u001c\u0001\u0004\u0011\u0018AE3ya\u0016\u001cG/\u001a3QCJ$\u0018\u000e^5p]NDq!!6\u001c\u0001\u0004\t\u0019%A\u0007gKR\u001c\u0007NU3ta>t7/\u001a\u0005\u0006_n\u0001\ra\u001b\u0005\u0006Un\u0001\ra\u001b\u0005\u0007\u0003;\\\u0002\u0019A6\u0002/9,X.T3tg\u0006<Wm\u001d)feB\u000b'\u000f^5uS>t\u0017\u0001D2sK\u0006$X\rV8qS\u000e\u001cH\u0003CAr\u0003K\fI/!<\u0011\tqz\bp\u001b\u0005\u0007\u0003Od\u0002\u0019A6\u0002\u00139,X\u000eV8qS\u000e\u001c\bBBAv9\u0001\u00071.A\u0007ok6\u0004\u0016M\u001d;ji&|gn\u001d\u0005\n\u0003_d\u0002\u0013!a\u0001\u0003c\fqaY8oM&<7\u000f\u0005\u0003=\u007fnZ\u0014AF2sK\u0006$X\rV8qS\u000e\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005](\u0006BAy\u0003[\t1\u0002\u001d:pIV\u001cW\rR1uCR1\u0011Q B\u0003\u00053\u0001Ba\u001d<\u0002\u0000B\u0019\u0001G!\u0001\n\u0007\t\r\u0011G\u0001\bSK\u000e|'\u000fZ'fi\u0006$\u0017\r^1\t\rEt\u0002\u0019\u0001B\u0004!\u0015\u0011IAa\u0005y\u001d\u0011\u0011YAa\u0004\u000f\u0007y\u0012i!C\u0001C\u0013\r\u0011\t\"Q\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011)Ba\u0006\u0003\u0011%#XM]1cY\u0016T1A!\u0005B\u0011\u0019\tiN\ba\u0001W\u0002")
public class FetchRequestTest
extends BaseRequestTest {
    private KafkaProducer<String, String> producer = null;

    private KafkaProducer<String, String> producer() {
        return this.producer;
    }

    private void producer_$eq(KafkaProducer<String, String> x$1) {
        this.producer = x$1;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.put(KafkaConfig$.MODULE$.FetchMaxBytes(), ((Object)Integer.MAX_VALUE).toString());
    }

    @Override
    public void tearDown() {
        if (this.producer() != null) {
            this.producer().close();
        }
        super.tearDown();
    }

    private FetchRequest createFetchRequest(int maxResponseBytes, int maxPartitionBytes, Seq<TopicPartition> topicPartitions, scala.collection.immutable.Map<TopicPartition, Object> offsetMap) {
        return (FetchRequest)FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(maxPartitionBytes, topicPartitions, offsetMap)).setMaxBytes(maxResponseBytes).build();
    }

    private LinkedHashMap<TopicPartition, FetchRequest.PartitionData> createPartitionMap(int maxPartitionBytes, Seq<TopicPartition> topicPartitions, scala.collection.immutable.Map<TopicPartition, Object> offsetMap) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> partitionMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        topicPartitions.foreach((Function1 & Serializable)tp -> partitionMap.put((TopicPartition)tp, new FetchRequest.PartitionData(BoxesRunTime.unboxToLong((Object)offsetMap.getOrElse(tp, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)), 0L, maxPartitionBytes, Optional.empty())));
        return partitionMap;
    }

    private scala.collection.immutable.Map<TopicPartition, Object> createPartitionMap$default$3() {
        if (Predef$.MODULE$.Map() == null) {
            throw null;
        }
        return Map.EmptyMap$.MODULE$;
    }

    private FetchResponse<MemoryRecords> sendFetchRequest(int leaderId, FetchRequest request) {
        return (FetchResponse)this.connectAndReceive((AbstractRequest)request, this.brokerSocketServer(leaderId), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(FetchResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    private void initProducer() {
        None$ none$;
        None$ none$2;
        SecurityProtocol securityProtocol;
        String string;
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), SecurityProtocol.PLAINTEXT);
        StringSerializer x$2 = new StringSerializer();
        StringSerializer x$3 = new StringSerializer();
        int n = -1;
        long l = 60000L;
        long l2 = 0x100000L;
        int n2 = Integer.MAX_VALUE;
        int n3 = 30000;
        int n4 = 0;
        int n5 = 16384;
        String string2 = string = "none";
        string = null;
        String x$11 = string2;
        int n6 = 20000;
        SecurityProtocol securityProtocol2 = securityProtocol = SecurityProtocol.PLAINTEXT;
        securityProtocol = null;
        SecurityProtocol x$13 = securityProtocol2;
        None$ none$3 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$14 = none$3;
        None$ none$4 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$15 = none$4;
        boolean bl = false;
        this.producer_$eq(TestUtils$.MODULE$.createProducer(x$1, n, l, l2, n2, n3, n4, n5, x$11, n6, x$13, (Option<File>)x$14, (Option<Properties>)x$15, x$2, x$3, bl));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBrokerRespectsPartitionsOrderAndSizeLimits() {
        void apply_elems;
        Long l;
        List list;
        List list2;
        List list3;
        List list4;
        List list5;
        List list6;
        void $plus$plus_suffix;
        List list7;
        void apply_elems2;
        Long l2;
        List list8;
        List list9;
        List list10;
        List list11;
        List list12;
        List list13;
        void $plus$plus_suffix2;
        List list14;
        void takeRight_n;
        this.initProducer();
        int messagesPerPartition = 9;
        int maxResponseBytes = 800;
        int maxPartitionBytes = 190;
        scala.collection.immutable.Map<TopicPartition, Object> topicPartitionToLeader = this.createTopics(5, 6, this.createTopics$default$3());
        Random random = new Random(0);
        Set topicPartitions = topicPartitionToLeader.keySet();
        this.produceData((Iterable<TopicPartition>)topicPartitions, messagesPerPartition);
        int leaderId = ((KafkaServer)this.servers().head()).config().brokerId();
        Vector partitionsForLeader = (Vector)topicPartitionToLeader.toVector().collect((PartialFunction)new Serializable(null, leaderId){
            private static final long serialVersionUID = 0L;
            private final int leaderId$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<TopicPartition, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                if (x1 != null) {
                    TopicPartition tp = (TopicPartition)x1._1();
                    if (x1._2$mcI$sp() == this.leaderId$1) {
                        object = tp;
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<TopicPartition, Object> x1) {
                boolean bl = x1 != null && x1._2$mcI$sp() == this.leaderId$1;
                return bl;
            }
            {
                this.leaderId$1 = leaderId$1;
            }
        });
        int n = 2;
        if (partitionsForLeader == null) {
            throw null;
        }
        Vector partitionsWithLargeMessages = (Vector)partitionsForLeader.slice(partitionsForLeader.length() - Math.max((int)takeRight_n, 0), partitionsForLeader.length());
        TopicPartition partitionWithLargeMessage1 = (TopicPartition)partitionsWithLargeMessages.head();
        TopicPartition partitionWithLargeMessage2 = (TopicPartition)partitionsWithLargeMessages.apply(1);
        this.producer().send(new ProducerRecord(partitionWithLargeMessage1.topic(), Integer.valueOf(partitionWithLargeMessage1.partition()), (Object)"larger than partition limit", (Object)new String(new byte[maxPartitionBytes + 1]))).get();
        this.producer().send(new ProducerRecord(partitionWithLargeMessage2.topic(), Integer.valueOf(partitionWithLargeMessage2.partition()), (Object)"larger than response limit", (Object)new String(new byte[maxResponseBytes + 1]))).get();
        Vector partitionsWithoutLargeMessages = (Vector)partitionsForLeader.filterNot((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)partitionsWithLargeMessages.contains(elem)));
        IterableOps iterableOps = (IterableOps)random.shuffle((IterableOnce)partitionsWithoutLargeMessages, BuildFromLowPriority2.buildFromIterableOps$((BuildFromLowPriority2)BuildFrom$.MODULE$));
        if (iterableOps == null) {
            throw null;
        }
        Vector shuffledTopicPartitions1 = (Vector)iterableOps.concat((IterableOnce)partitionsWithLargeMessages);
        FetchRequest fetchRequest1 = this.createFetchRequest$1((Seq)shuffledTopicPartitions1, FetchRequestTest.createFetchRequest$default$2$1(), maxResponseBytes, maxPartitionBytes);
        FetchResponse<MemoryRecords> fetchResponse1 = this.sendFetchRequest(leaderId, fetchRequest1);
        this.checkFetchResponse((Seq<TopicPartition>)shuffledTopicPartitions1, fetchResponse1, maxPartitionBytes, maxResponseBytes, messagesPerPartition);
        IterableOps iterableOps2 = (IterableOps)random.shuffle((IterableOnce)partitionsWithoutLargeMessages, BuildFromLowPriority2.buildFromIterableOps$((BuildFromLowPriority2)BuildFrom$.MODULE$));
        if (iterableOps2 == null) {
            throw null;
        }
        Vector shuffledTopicPartitions2 = (Vector)iterableOps2.concat((IterableOnce)partitionsWithLargeMessages);
        FetchRequest fetchRequest2 = this.createFetchRequest$1((Seq)shuffledTopicPartitions2, FetchRequestTest.createFetchRequest$default$2$1(), maxResponseBytes, maxPartitionBytes);
        FetchResponse<MemoryRecords> fetchResponse2 = this.sendFetchRequest(leaderId, fetchRequest2);
        this.checkFetchResponse((Seq<TopicPartition>)shuffledTopicPartitions2, fetchResponse2, maxPartitionBytes, maxResponseBytes, messagesPerPartition);
        IterableOnce iterableOnce = (IterableOnce)random.shuffle((IterableOnce)partitionsWithoutLargeMessages, BuildFromLowPriority2.buildFromIterableOps$((BuildFromLowPriority2)BuildFrom$.MODULE$));
        .colon.colon $plus$plus_this = new .colon.colon((Object)partitionWithLargeMessage1, (List)new .colon.colon((Object)partitionWithLargeMessage2, (List)Nil$.MODULE$));
        List list15 = list14 = $plus$plus_this.appendedAll((IterableOnce)$plus$plus_suffix2);
        list14 = null;
        List list16 = list13 = list15;
        list13 = null;
        List list17 = list12 = list16;
        list12 = null;
        List list18 = list11 = list17;
        list11 = null;
        List list19 = list10 = list18;
        list10 = null;
        List list20 = list9 = list19;
        list9 = null;
        List list21 = list8 = list20;
        Object var31_21 = null;
        iterableOnce = null;
        list8 = null;
        List shuffledTopicPartitions3 = list21;
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        Long l3 = l2 = Long.valueOf(messagesPerPartition);
        l2 = null;
        Long $minus$greater$extension_y = l3;
        Object var34_31 = null;
        objectArray[0] = new Tuple2((Object)partitionWithLargeMessage1, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        FetchRequest fetchRequest3 = this.createFetchRequest$1((Seq)shuffledTopicPartitions3, (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems2), maxResponseBytes, maxPartitionBytes);
        FetchResponse<MemoryRecords> fetchResponse3 = this.sendFetchRequest(leaderId, fetchRequest3);
        Assert.assertEquals((Object)shuffledTopicPartitions3, (Object)AsScalaExtensions.SetHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, fetchResponse3.responseData().keySet()).asScala().toSeq());
        Assert.assertTrue((BoxesRunTime.unboxToInt((Object)((IterableOnceOps)AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.Map)fetchResponse3.responseData()).asScala().values().map((Function1 & Serializable)partitionData -> BoxesRunTime.boxToInteger((int)FetchRequestTest.$anonfun$testBrokerRespectsPartitionsOrderAndSizeLimits$2(this, partitionData)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) <= maxResponseBytes ? 1 : 0) != 0);
        FetchResponse.PartitionData partitionData3 = (FetchResponse.PartitionData)fetchResponse3.responseData().get(partitionWithLargeMessage1);
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionData3.error());
        Assert.assertTrue((partitionData3.highWatermark() > 0L ? 1 : 0) != 0);
        int size3 = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)partitionData3).map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.sizeInBytes()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertTrue((String)new StringBuilder(29).append("Expected ").append(size3).append(" to be smaller than ").append(maxResponseBytes).toString(), (size3 <= maxResponseBytes ? 1 : 0) != 0);
        Assert.assertTrue((String)new StringBuilder(28).append("Expected ").append(size3).append(" to be larger than ").append(maxPartitionBytes).toString(), (size3 > maxPartitionBytes ? 1 : 0) != 0);
        Assert.assertTrue((maxPartitionBytes < ((MemoryRecords)partitionData3.records()).sizeInBytes() ? 1 : 0) != 0);
        IterableOnce iterableOnce2 = (IterableOnce)random.shuffle((IterableOnce)partitionsWithoutLargeMessages, BuildFromLowPriority2.buildFromIterableOps$((BuildFromLowPriority2)BuildFrom$.MODULE$));
        .colon.colon $plus$plus_this2 = new .colon.colon((Object)partitionWithLargeMessage2, (List)new .colon.colon((Object)partitionWithLargeMessage1, (List)Nil$.MODULE$));
        List list22 = list7 = $plus$plus_this2.appendedAll((IterableOnce)$plus$plus_suffix);
        list7 = null;
        List list23 = list6 = list22;
        list6 = null;
        List list24 = list5 = list23;
        list5 = null;
        List list25 = list4 = list24;
        list4 = null;
        List list26 = list3 = list25;
        list3 = null;
        List list27 = list2 = list26;
        list2 = null;
        List list28 = list = list27;
        Object var35_38 = null;
        iterableOnce2 = null;
        list = null;
        List shuffledTopicPartitions4 = list28;
        Map$ map$2 = Predef$.MODULE$.Map();
        Object[] objectArray2 = new Tuple2[1];
        Long l4 = l = Long.valueOf(messagesPerPartition);
        l = null;
        Long $minus$greater$extension_y2 = l4;
        Object var38_48 = null;
        objectArray2[0] = new Tuple2((Object)partitionWithLargeMessage2, (Object)$minus$greater$extension_y2);
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray2);
        if (map$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        FetchRequest fetchRequest4 = this.createFetchRequest$1((Seq)shuffledTopicPartitions4, (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$2, (scala.collection.immutable.Seq)apply_elems), maxResponseBytes, maxPartitionBytes);
        FetchResponse<MemoryRecords> fetchResponse4 = this.sendFetchRequest(leaderId, fetchRequest4);
        Assert.assertEquals((Object)shuffledTopicPartitions4, (Object)AsScalaExtensions.SetHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, fetchResponse4.responseData().keySet()).asScala().toSeq());
        scala.collection.immutable.Seq nonEmptyPartitions4 = (scala.collection.immutable.Seq)AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.Map)fetchResponse4.responseData()).asScala().toSeq().collect((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ FetchRequestTest $outer;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<TopicPartition, FetchResponse.PartitionData<MemoryRecords>>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                if (x2 != null) {
                    TopicPartition tp = (TopicPartition)x2._1();
                    FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)x2._2();
                    if (BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.$outer.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)partitionData).map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)$anonfun$2.$anonfun$applyOrElse$1(x$3)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) > 0) {
                        object = tp;
                        return (B1)object;
                    }
                }
                object = function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<TopicPartition, FetchResponse.PartitionData<MemoryRecords>> x2) {
                FetchResponse.PartitionData partitionData;
                boolean bl = x2 != null && BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.$outer.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)(partitionData = (FetchResponse.PartitionData)x2._2())).map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)$anonfun$2.$anonfun$isDefinedAt$1(x$3)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) > 0;
                return bl;
            }

            public static final /* synthetic */ int $anonfun$applyOrElse$1(Record x$3) {
                return x$3.sizeInBytes();
            }

            public static final /* synthetic */ int $anonfun$isDefinedAt$1(Record x$3) {
                return x$3.sizeInBytes();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(org.apache.kafka.common.record.Record ), $anonfun$isDefinedAt$1$adapted(org.apache.kafka.common.record.Record )}, serializedLambda);
            }
        });
        Assert.assertEquals((Object)new .colon.colon((Object)partitionWithLargeMessage2, (List)Nil$.MODULE$), (Object)nonEmptyPartitions4);
        FetchResponse.PartitionData partitionData4 = (FetchResponse.PartitionData)fetchResponse4.responseData().get(partitionWithLargeMessage2);
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionData4.error());
        Assert.assertTrue((partitionData4.highWatermark() > 0L ? 1 : 0) != 0);
        int size4 = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)partitionData4).map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.sizeInBytes()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertTrue((String)new StringBuilder(28).append("Expected ").append(size4).append(" to be larger than ").append(maxResponseBytes).toString(), (size4 > maxResponseBytes ? 1 : 0) != 0);
        Assert.assertTrue((maxResponseBytes < ((MemoryRecords)partitionData4.records()).sizeInBytes() ? 1 : 0) != 0);
    }

    @Test
    public void testFetchRequestV2WithOversizedMessage() {
        this.initProducer();
        int maxPartitionBytes = 200;
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, this.createTopics$default$3()).head();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        int n = tuple2._2$mcI$sp();
        this.producer().send(new ProducerRecord(topicPartition.topic(), Integer.valueOf(topicPartition.partition()), (Object)"key", (Object)new String(new byte[maxPartitionBytes + 1]))).get();
        FetchRequest fetchRequest = FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(maxPartitionBytes, (Seq<TopicPartition>)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$), this.createPartitionMap$default$3())).build((short)2);
        FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)this.sendFetchRequest(n, fetchRequest).responseData().get(topicPartition);
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionData.error());
        Assert.assertTrue((partitionData.highWatermark() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)maxPartitionBytes, (long)((MemoryRecords)partitionData.records()).sizeInBytes());
        Assert.assertEquals((long)0L, (long)BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)partitionData).map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.sizeInBytes()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)));
    }

    @Test
    public void testFetchRequestV4WithReadCommitted() {
        this.initProducer();
        int maxPartitionBytes = 200;
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, this.createTopics$default$3()).head();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        int n = tuple2._2$mcI$sp();
        this.producer().send(new ProducerRecord(topicPartition.topic(), Integer.valueOf(topicPartition.partition()), (Object)"key", (Object)new String(new byte[maxPartitionBytes + 1]))).get();
        FetchRequest fetchRequest = FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(maxPartitionBytes, (Seq<TopicPartition>)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$), this.createPartitionMap$default$3())).isolationLevel(IsolationLevel.READ_COMMITTED).build((short)4);
        FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)this.sendFetchRequest(n, fetchRequest).responseData().get(topicPartition);
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionData.error());
        Assert.assertTrue((partitionData.lastStableOffset() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)partitionData).map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.sizeInBytes()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testFetchRequestToNonReplica() {
        String topic = "topic";
        int partition = 0;
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        int leader = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 1, (Seq<KafkaServer>)this.servers(), new Properties()).apply((Object)partition));
        Option nonReplicaOpt = this.servers().find((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)FetchRequestTest.$anonfun$testFetchRequestToNonReplica$1(leader, x$9)));
        Assert.assertTrue((boolean)nonReplicaOpt.isDefined());
        int nonReplicaId = ((KafkaServer)nonReplicaOpt.get()).config().brokerId();
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(1024, (Seq<TopicPartition>)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$), this.createPartitionMap$default$3())).build();
        FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)this.sendFetchRequest(nonReplicaId, fetchRequest).responseData().get(topicPartition);
        Assert.assertEquals((Object)Errors.NOT_LEADER_OR_FOLLOWER, (Object)partitionData.error());
    }

    @Test
    public void testLastFetchedEpochValidation() {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 3, (Seq<KafkaServer>)this.servers(), new Properties()).apply((Object)topicPartition.partition()));
        int firstLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(firstLeaderId, topicPartition, (Iterable<KafkaServer>)this.servers());
        this.initProducer();
        long firstEpochEndOffset = ((RecordMetadata)this.produceData((Iterable<TopicPartition>)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$), 100).lastOption().get()).offset() + 1L;
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange((Seq<KafkaServer>)this.servers(), topicPartition, firstLeaderId, 15000L);
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, topicPartition, (Iterable<KafkaServer>)this.servers());
        long secondEpochEndOffset = ((RecordMetadata)this.produceData((Iterable<TopicPartition>)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$), 100).lastOption().get()).offset() + 1L;
        long fetchOffset = secondEpochEndOffset + (secondEpochEndOffset - firstEpochEndOffset) / 2L;
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> partitionMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        partitionMap.put(topicPartition, new FetchRequest.PartitionData(fetchOffset, 0L, 1024, Optional.of(secondLeaderEpoch), Optional.of(firstLeaderEpoch)));
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((int)0, (int)1, partitionMap).build();
        FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)this.sendFetchRequest(secondLeaderId, fetchRequest).responseData().get(topicPartition);
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionData.error());
        Assert.assertEquals((long)0L, (long)((MemoryRecords)partitionData.records()).sizeInBytes());
        Assert.assertTrue((boolean)partitionData.divergingEpoch().isPresent());
        FetchResponseData.EpochEndOffset divergingEpoch = (FetchResponseData.EpochEndOffset)partitionData.divergingEpoch().get();
        Assert.assertEquals((long)firstLeaderEpoch, (long)divergingEpoch.epoch());
        Assert.assertEquals((long)firstEpochEndOffset, (long)divergingEpoch.endOffset());
    }

    @Test
    public void testCurrentEpochValidation() {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 3, (Seq<KafkaServer>)this.servers(), new Properties()).apply((Object)topicPartition.partition()));
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange((Seq<KafkaServer>)this.servers(), topicPartition, firstLeaderId, 15000L);
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, topicPartition, (Iterable<KafkaServer>)this.servers());
        this.assertResponseErrorForEpoch$1(Errors.NONE, secondLeaderId, Optional.empty(), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.NONE, secondLeaderId, Optional.of(secondLeaderEpoch), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.FENCED_LEADER_EPOCH, secondLeaderId, Optional.of(secondLeaderEpoch - 1), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.UNKNOWN_LEADER_EPOCH, secondLeaderId, Optional.of(secondLeaderEpoch + 1), topicPartition);
        int followerId = TestUtils$.MODULE$.findFollowerId(topicPartition, (Iterable<KafkaServer>)this.servers());
        this.assertResponseErrorForEpoch$1(Errors.NONE, followerId, Optional.empty(), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.NONE, followerId, Optional.of(secondLeaderEpoch), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.UNKNOWN_LEADER_EPOCH, followerId, Optional.of(secondLeaderEpoch + 1), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.FENCED_LEADER_EPOCH, followerId, Optional.of(secondLeaderEpoch - 1), topicPartition);
    }

    @Test
    public void testEpochValidationWithinFetchSession() {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 3, (Seq<KafkaServer>)this.servers(), new Properties()).apply((Object)topicPartition.partition()));
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange((Seq<KafkaServer>)this.servers(), topicPartition, firstLeaderId, 15000L);
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, topicPartition, (Iterable<KafkaServer>)this.servers());
        this.verifyFetchSessionErrors(topicPartition, secondLeaderEpoch, secondLeaderId);
        int followerId = TestUtils$.MODULE$.findFollowerId(topicPartition, (Iterable<KafkaServer>)this.servers());
        this.verifyFetchSessionErrors(topicPartition, secondLeaderEpoch, followerId);
    }

    private void verifyFetchSessionErrors(TopicPartition topicPartition, int leaderEpoch, int destinationBrokerId) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> partitionMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        partitionMap.put(topicPartition, new FetchRequest.PartitionData(0L, 0L, 1024, Optional.of(leaderEpoch)));
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((int)0, (int)1, partitionMap).metadata(FetchMetadata.INITIAL).build();
        int sessionId = this.sendFetchRequest(destinationBrokerId, fetchRequest).sessionId();
        this.assertResponseErrorForEpoch$2(Errors.FENCED_LEADER_EPOCH, 1, Optional.of(leaderEpoch - 1), topicPartition, sessionId, destinationBrokerId);
        this.assertResponseErrorForEpoch$2(Errors.UNKNOWN_LEADER_EPOCH, 2, Optional.of(leaderEpoch + 1), topicPartition, sessionId, destinationBrokerId);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDownConversionWithConnectionFailure() {
        Buffer buffer;
        IndexedSeq indexedSeq;
        None$ none$;
        None$ none$2;
        SecurityProtocol securityProtocol;
        String string;
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, this.createTopics$default$3()).head();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        int n = tuple2._2$mcI$sp();
        int msgValueLen = 100000;
        int batchSize = 4 * msgValueLen;
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), SecurityProtocol.PLAINTEXT);
        StringSerializer x$5 = new StringSerializer();
        ByteArraySerializer x$6 = new ByteArraySerializer();
        int n2 = -1;
        long l = 60000L;
        long l2 = 0x100000L;
        int n3 = Integer.MAX_VALUE;
        String string2 = string = "none";
        string = null;
        String x$11 = string2;
        int n4 = 20000;
        SecurityProtocol securityProtocol2 = securityProtocol = SecurityProtocol.PLAINTEXT;
        securityProtocol = null;
        SecurityProtocol x$13 = securityProtocol2;
        None$ none$3 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$14 = none$3;
        None$ none$4 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$15 = none$4;
        boolean bl = false;
        byte[] bytes = new byte[msgValueLen];
        try (KafkaProducer producer = TestUtils$.MODULE$.createProducer(x$1, n2, l, l2, n3, Integer.MAX_VALUE, Integer.MAX_VALUE, batchSize, x$11, n4, x$13, (Option<File>)x$14, (Option<Properties>)x$15, x$5, x$6, bl);){
            Future future;
            int n5 = 0;
            int to$extension_end = 1000;
            Range.Inclusive map_this = new Range.Inclusive(n5, to$extension_end, 1);
            map_this.scala$collection$immutable$Range$$validateMaxLength();
            Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
            for (Object object : map_this) {
                void map_strictOptimizedMap_$plus$eq_elem;
                Future future2;
                Future future3 = future2 = producer.send(new ProducerRecord(topicPartition.topic(), Integer.valueOf(topicPartition.partition()), (Object)"key", (Object)bytes));
                future2 = null;
                future = future3;
                if (map_strictOptimizedMap_b == null) {
                    throw null;
                }
                map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
                future = null;
            }
            indexedSeq = (IndexedSeq)map_strictOptimizedMap_b.result();
            Object var23_27 = null;
            Object var24_28 = null;
            Object var25_29 = null;
            future = null;
        }
        indexedSeq.foreach((Function1 & Serializable)x$12 -> (RecordMetadata)x$12.get());
        short version = (short)1;
        int n6 = 0;
        int to$extension_end = 15;
        Range.Inclusive foreach_this = new Range.Inclusive(n6, to$extension_end, 1);
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                this.fetch$1(version, msgValueLen * 1000, true, topicPartition, n, batchSize);
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement) break;
                foreach_i += foreach_this.step();
            }
        }
        Object var27_37 = null;
        Option response = this.fetch$1(version, batchSize, false, topicPartition, n, batchSize);
        if (response == null) {
            throw null;
        }
        if (response.isEmpty()) {
            throw new IllegalStateException("No fetch response");
        }
        FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)((FetchResponse)response.get()).responseData().get(topicPartition);
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionData.error());
        Iterable iterable = AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.lang.Iterable)((MemoryRecords)partitionData.records()).batches()).asScala();
        if (iterable == null) {
            throw null;
        }
        Iterable toBuffer_this = iterable;
        Buffer buffer2 = buffer = (Buffer)Buffer$.MODULE$.from((IterableOnce)toBuffer_this);
        Object var21_41 = null;
        buffer = null;
        Buffer batches = buffer2;
        if (batches == null) {
            throw null;
        }
        Assert.assertEquals((long)3L, (long)batches.length());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDownConversionFromBatchedToUnbatchedRespectsOffset() {
        IndexedSeq indexedSeq;
        Future future;
        IndexedSeq indexedSeq2;
        Future future2;
        void apply_elems;
        void $minus$greater$extension_y;
        None$ none$;
        None$ none$2;
        SecurityProtocol securityProtocol;
        String string;
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), SecurityProtocol.PLAINTEXT);
        StringSerializer x$3 = new StringSerializer();
        StringSerializer x$4 = new StringSerializer();
        int n = -1;
        long l = 60000L;
        long l2 = 0x100000L;
        int n2 = 16384;
        String string2 = string = "none";
        string = null;
        String x$11 = string2;
        int n3 = 20000;
        SecurityProtocol securityProtocol2 = securityProtocol = SecurityProtocol.PLAINTEXT;
        securityProtocol = null;
        SecurityProtocol x$13 = securityProtocol2;
        None$ none$3 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$14 = none$3;
        None$ none$4 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$152 = none$4;
        boolean bl = false;
        this.producer_$eq(TestUtils$.MODULE$.createProducer(x$1, n, l, l2, 5, 60000, 30000, n2, x$11, n3, x$13, (Option<File>)x$14, (Option<Properties>)x$152, x$3, x$4, bl));
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        String string3 = KAFKA_0_11_0_IV2$.MODULE$.version();
        String $minus$greater$extension_$this = LogConfig$.MODULE$.MessageFormatVersionProp();
        Object var14_19 = null;
        string3 = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        scala.collection.immutable.Map topicConfig = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems);
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, (scala.collection.immutable.Map<String, String>)topicConfig).head();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        int n4 = tuple2._2$mcI$sp();
        String topic = topicPartition.topic();
        int n5 = 0;
        int until$extension_end = 10;
        Range.Exclusive map_this = new Range.Exclusive(n5, until$extension_end, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        for (Object object : map_this) {
            void map_strictOptimizedMap_$plus$eq_elem;
            Future future3;
            Future future4 = future3 = FetchRequestTest.$anonfun$testDownConversionFromBatchedToUnbatchedRespectsOffset$1(this, topic, BoxesRunTime.unboxToInt((Object)object));
            future3 = null;
            future2 = future4;
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            future2 = null;
        }
        IndexedSeq indexedSeq3 = indexedSeq2 = (IndexedSeq)map_strictOptimizedMap_b.result();
        Object var19_28 = null;
        Object var20_29 = null;
        Object var21_30 = null;
        future2 = null;
        indexedSeq2 = null;
        IndexedSeq firstBatchFutures = indexedSeq3;
        this.producer().flush();
        int n6 = 10;
        int until$extension_end2 = 25;
        Range.Exclusive map_this2 = new Range.Exclusive(n6, until$extension_end2, 1);
        map_this2.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b2 = IndexedSeq$.MODULE$.newBuilder();
        for (Object object : map_this2) {
            void map_strictOptimizedMap_$plus$eq_elem;
            Future future5;
            Future future6 = future5 = FetchRequestTest.$anonfun$testDownConversionFromBatchedToUnbatchedRespectsOffset$2(this, topic, BoxesRunTime.unboxToInt((Object)object));
            future5 = null;
            future = future6;
            if (map_strictOptimizedMap_b2 == null) {
                throw null;
            }
            map_strictOptimizedMap_b2.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            future = null;
        }
        IndexedSeq indexedSeq4 = indexedSeq = (IndexedSeq)map_strictOptimizedMap_b2.result();
        Object var24_38 = null;
        Object var25_39 = null;
        Object var26_40 = null;
        future = null;
        indexedSeq = null;
        IndexedSeq secondBatchFutures = indexedSeq4;
        this.producer().flush();
        firstBatchFutures.foreach((Function1 & Serializable)x$15 -> (RecordMetadata)x$15.get());
        secondBatchFutures.foreach((Function1 & Serializable)x$16 -> (RecordMetadata)x$16.get());
        this.check$1(3L, (short)1, 3L, 22, (byte)0, topicPartition, n4);
        this.check$1(15L, (short)1, 15L, 10, (byte)0, topicPartition, n4);
        this.check$1(3L, (short)3, 3L, 22, (byte)1, topicPartition, n4);
        this.check$1(15L, (short)3, 15L, 10, (byte)1, topicPartition, n4);
        this.check$1(3L, (short)4, 0L, 2, (byte)2, topicPartition, n4);
        this.check$1(15L, (short)4, 10L, 1, (byte)2, topicPartition, n4);
        this.check$1(10L, (short)4, 10L, 1, (byte)2, topicPartition, n4);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateIncrementalFetchWithPartitionsInError() {
        void apply_elems;
        void $minus$greater$extension_y;
        void apply_elems2;
        Object object;
        void apply_elems3;
        void $minus$greater$extension_y2;
        void apply_elems4;
        Object object2;
        void $minus$greater$extension_y3;
        void apply_elems5;
        Object object3;
        TopicPartition foo0 = new TopicPartition("foo", 0);
        TopicPartition foo1 = new TopicPartition("foo", 1);
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[2];
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1});
        List$ apply_this = List$.MODULE$;
        Object object4 = object3 = IterableFactory.apply$((IterableFactory)apply_this, (scala.collection.immutable.Seq)apply_elems5);
        Object var18_4 = null;
        arraySeq = null;
        object3 = null;
        Object object5 = object4;
        Integer $minus$greater$extension_$this = 0;
        Object var12_7 = null;
        object5 = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y3);
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 2});
        List$ apply_this2 = List$.MODULE$;
        Object object6 = object2 = IterableFactory.apply$((IterableFactory)apply_this2, (scala.collection.immutable.Seq)apply_elems4);
        Object var21_9 = null;
        arraySeq2 = null;
        object2 = null;
        Object object7 = object6;
        Integer $minus$greater$extension_$this2 = 1;
        Object var14_12 = null;
        object7 = null;
        objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq3 = null;
        this.createTopic("foo", (Map<Object, Seq<Object>>)((Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems3)));
        TopicPartition bar0 = new TopicPartition("bar", 0);
        FetchRequest req1 = this.createFetchRequest$2((Seq)new .colon.colon((Object)foo0, (List)new .colon.colon((Object)foo1, (List)new .colon.colon((Object)bar0, (List)Nil$.MODULE$))), FetchMetadata.INITIAL, (Seq)Nil$.MODULE$);
        FetchResponse<MemoryRecords> resp1 = this.sendFetchRequest(0, req1);
        Assert.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assert.assertTrue((String)"Expected the broker to create a new incremental fetch session", (resp1.sessionId() > 0 ? 1 : 0) != 0);
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append("Test created an incremental fetch session ").append(resp1.sessionId()).toString());
        Assert.assertTrue((boolean)resp1.responseData().containsKey(foo0));
        Assert.assertTrue((boolean)resp1.responseData().containsKey(foo1));
        Assert.assertTrue((boolean)resp1.responseData().containsKey(bar0));
        Assert.assertEquals((Object)Errors.NONE, (Object)((FetchResponse.PartitionData)resp1.responseData().get(foo0)).error());
        Assert.assertEquals((Object)Errors.NONE, (Object)((FetchResponse.PartitionData)resp1.responseData().get(foo1)).error());
        Assert.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, (Object)((FetchResponse.PartitionData)resp1.responseData().get(bar0)).error());
        FetchRequest req2 = this.createFetchRequest$2((Seq)Nil$.MODULE$, new FetchMetadata(resp1.sessionId(), 1), (Seq)Nil$.MODULE$);
        FetchResponse<MemoryRecords> resp2 = this.sendFetchRequest(0, req2);
        Assert.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assert.assertEquals((String)"Expected the broker to continue the incremental fetch session", (long)resp1.sessionId(), (long)resp2.sessionId());
        Assert.assertFalse((boolean)resp2.responseData().containsKey(foo0));
        Assert.assertFalse((boolean)resp2.responseData().containsKey(foo1));
        Assert.assertTrue((boolean)resp2.responseData().containsKey(bar0));
        Assert.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, (Object)((FetchResponse.PartitionData)resp2.responseData().get(bar0)).error());
        Map$ map$2 = Predef$.MODULE$.Map();
        Object[] objectArray2 = new Tuple2[1];
        ArraySeq arraySeq4 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1});
        List$ apply_this3 = List$.MODULE$;
        Object object8 = object = IterableFactory.apply$((IterableFactory)apply_this3, (scala.collection.immutable.Seq)apply_elems2);
        Object var25_20 = null;
        arraySeq4 = null;
        object = null;
        Object object9 = object8;
        Integer $minus$greater$extension_$this3 = 0;
        Object var16_23 = null;
        object9 = null;
        objectArray2[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq5 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray2);
        if (map$2 == null) {
            throw null;
        }
        arraySeq5 = null;
        this.createTopic("bar", (Map<Object, Seq<Object>>)((Map)MapFactory.apply$((MapFactory)map$2, (scala.collection.immutable.Seq)apply_elems)));
        FetchRequest req3 = this.createFetchRequest$2((Seq)Nil$.MODULE$, new FetchMetadata(resp1.sessionId(), 2), (Seq)Nil$.MODULE$);
        FetchResponse<MemoryRecords> resp3 = this.sendFetchRequest(0, req3);
        Assert.assertEquals((Object)Errors.NONE, (Object)resp3.error());
        Assert.assertFalse((boolean)resp3.responseData().containsKey(foo0));
        Assert.assertFalse((boolean)resp3.responseData().containsKey(foo1));
        Assert.assertTrue((boolean)resp3.responseData().containsKey(bar0));
        Assert.assertEquals((Object)Errors.NONE, (Object)((FetchResponse.PartitionData)resp3.responseData().get(bar0)).error());
        FetchRequest req4 = this.createFetchRequest$2((Seq)Nil$.MODULE$, new FetchMetadata(resp1.sessionId(), 3), (Seq)Nil$.MODULE$);
        FetchResponse<MemoryRecords> resp4 = this.sendFetchRequest(0, req4);
        Assert.assertEquals((Object)Errors.NONE, (Object)resp4.error());
        Assert.assertFalse((boolean)resp4.responseData().containsKey(foo0));
        Assert.assertFalse((boolean)resp4.responseData().containsKey(foo1));
        Assert.assertFalse((boolean)resp4.responseData().containsKey(bar0));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZStdCompressedTopic() {
        None$ none$;
        None$ none$2;
        SecurityProtocol securityProtocol;
        String string;
        void apply_elems;
        void $minus$greater$extension_y;
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        String string2 = ZStdCompressionCodec$.MODULE$.name();
        String $minus$greater$extension_$this = LogConfig$.MODULE$.CompressionTypeProp();
        Object var15_2 = null;
        string2 = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        scala.collection.immutable.Map topicConfig = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems);
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, (scala.collection.immutable.Map<String, String>)topicConfig).head();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        int n = tuple2._2$mcI$sp();
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), SecurityProtocol.PLAINTEXT);
        StringSerializer x$2 = new StringSerializer();
        StringSerializer x$3 = new StringSerializer();
        int n2 = -1;
        long l = 60000L;
        long l2 = 0x100000L;
        int n3 = Integer.MAX_VALUE;
        int n4 = 30000;
        int n5 = 0;
        int n6 = 16384;
        String string3 = string = "none";
        string = null;
        String x$11 = string3;
        int n7 = 20000;
        SecurityProtocol securityProtocol2 = securityProtocol = SecurityProtocol.PLAINTEXT;
        securityProtocol = null;
        SecurityProtocol x$13 = securityProtocol2;
        None$ none$3 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$14 = none$3;
        None$ none$4 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$15 = none$4;
        boolean bl = false;
        this.producer_$eq(TestUtils$.MODULE$.createProducer(x$1, n2, l, l2, n3, n4, n5, n6, x$11, n7, x$13, (Option<File>)x$14, (Option<Properties>)x$15, x$2, x$3, bl));
        this.producer().send(new ProducerRecord(topicPartition.topic(), Integer.valueOf(topicPartition.partition()), (Object)"key1", (Object)"value1")).get();
        this.producer().send(new ProducerRecord(topicPartition.topic(), Integer.valueOf(topicPartition.partition()), (Object)"key2", (Object)"value2")).get();
        this.producer().send(new ProducerRecord(topicPartition.topic(), Integer.valueOf(topicPartition.partition()), (Object)"key3", (Object)"value3")).get();
        this.producer().close();
        if (Predef$.MODULE$.Map() == null) {
            throw null;
        }
        FetchRequest req0 = (FetchRequest)new FetchRequest.Builder(0, 9, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)Map.EmptyMap$.MODULE$)).setMaxBytes(800).build();
        FetchResponse.PartitionData data0 = (FetchResponse.PartitionData)this.sendFetchRequest(n, req0).responseData().get(topicPartition);
        Assert.assertEquals((Object)Errors.UNSUPPORTED_COMPRESSION_TYPE, (Object)data0.error());
        if (Predef$.MODULE$.Map() == null) {
            throw null;
        }
        FetchRequest req1 = (FetchRequest)new FetchRequest.Builder(0, 10, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)Map.EmptyMap$.MODULE$)).setMaxBytes(800).build();
        FetchResponse.PartitionData data1 = (FetchResponse.PartitionData)this.sendFetchRequest(n, req1).responseData().get(topicPartition);
        Assert.assertEquals((Object)Errors.NONE, (Object)data1.error());
        Seq<Record> seq = this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)data1);
        if (seq == null) {
            throw null;
        }
        Assert.assertEquals((long)3L, (long)seq.length());
    }

    @Test
    public void testPartitionDataEquals() {
        Assert.assertEquals((Object)new FetchRequest.PartitionData(300L, 0L, 300, Optional.of(300)), (Object)new FetchRequest.PartitionData(300L, 0L, 300, Optional.of(300)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZStdCompressedRecords() {
        void apply_elems;
        Long l;
        void apply_elems2;
        Long l2;
        None$ none$;
        None$ none$2;
        SecurityProtocol securityProtocol;
        None$ none$3;
        None$ none$4;
        SecurityProtocol securityProtocol2;
        void apply_elems3;
        void $minus$greater$extension_y;
        void $minus$greater$extension_y2;
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[2];
        String string = ProducerCompressionCodec$.MODULE$.name();
        String $minus$greater$extension_$this = LogConfig$.MODULE$.CompressionTypeProp();
        Object var30_2 = null;
        string = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y2);
        String string2 = "2.0.0";
        String $minus$greater$extension_$this2 = LogConfig$.MODULE$.MessageFormatVersionProp();
        Object var32_4 = null;
        string2 = null;
        objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        scala.collection.immutable.Map topicConfig = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems3);
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, (scala.collection.immutable.Map<String, String>)topicConfig).head();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        int n = tuple2._2$mcI$sp();
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), SecurityProtocol.PLAINTEXT);
        String x$2 = GZIPCompressionCodec$.MODULE$.name();
        StringSerializer x$3 = new StringSerializer();
        StringSerializer x$4 = new StringSerializer();
        int n2 = -1;
        long l3 = 60000L;
        long l4 = 0x100000L;
        int n3 = Integer.MAX_VALUE;
        int n4 = 30000;
        int n5 = 0;
        int n6 = 16384;
        int n7 = 20000;
        SecurityProtocol securityProtocol3 = securityProtocol2 = SecurityProtocol.PLAINTEXT;
        securityProtocol2 = null;
        SecurityProtocol x$13 = securityProtocol3;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$14 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$15 = none$6;
        boolean bl = false;
        KafkaProducer producer1 = TestUtils$.MODULE$.createProducer(x$1, n2, l3, l4, n3, n4, n5, n6, x$2, n7, x$13, (Option<File>)x$14, (Option<Properties>)x$15, x$3, x$4, bl);
        producer1.send(new ProducerRecord(topicPartition.topic(), Integer.valueOf(topicPartition.partition()), (Object)"key1", (Object)"value1")).get();
        producer1.close();
        String x$17 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), SecurityProtocol.PLAINTEXT);
        String x$18 = ZStdCompressionCodec$.MODULE$.name();
        StringSerializer x$19 = new StringSerializer();
        StringSerializer x$20 = new StringSerializer();
        int n8 = -1;
        long l5 = 60000L;
        long l6 = 0x100000L;
        int n9 = Integer.MAX_VALUE;
        int n10 = 30000;
        int n11 = 0;
        int n12 = 16384;
        int n13 = 20000;
        SecurityProtocol securityProtocol4 = securityProtocol = SecurityProtocol.PLAINTEXT;
        securityProtocol = null;
        SecurityProtocol x$29 = securityProtocol4;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$30 = none$7;
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$31 = none$8;
        boolean bl2 = false;
        KafkaProducer producer2 = TestUtils$.MODULE$.createProducer(x$17, n8, l5, l6, n9, n10, n11, n12, x$18, n13, x$29, (Option<File>)x$30, (Option<Properties>)x$31, x$19, x$20, bl2);
        producer2.send(new ProducerRecord(topicPartition.topic(), Integer.valueOf(topicPartition.partition()), (Object)"key2", (Object)"value2")).get();
        producer2.send(new ProducerRecord(topicPartition.topic(), Integer.valueOf(topicPartition.partition()), (Object)"key3", (Object)"value3")).get();
        producer2.close();
        if (Predef$.MODULE$.Map() == null) {
            throw null;
        }
        FetchRequest req0 = (FetchRequest)new FetchRequest.Builder(0, 1, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)Map.EmptyMap$.MODULE$)).setMaxBytes(800).build();
        FetchResponse.PartitionData data0 = (FetchResponse.PartitionData)this.sendFetchRequest(n, req0).responseData().get(topicPartition);
        Assert.assertEquals((Object)Errors.NONE, (Object)data0.error());
        Seq<Record> seq = this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)data0);
        if (seq == null) {
            throw null;
        }
        Assert.assertEquals((long)1L, (long)seq.length());
        Map$ map$2 = Predef$.MODULE$.Map();
        Object[] objectArray2 = new Tuple2[1];
        Long l7 = l2 = Long.valueOf(1L);
        l2 = null;
        Long $minus$greater$extension_y3 = l7;
        Object var34_53 = null;
        objectArray2[0] = new Tuple2((Object)topicPartition, (Object)$minus$greater$extension_y3);
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray2);
        if (map$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        FetchRequest req1 = (FetchRequest)new FetchRequest.Builder(0, 1, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$2, (scala.collection.immutable.Seq)apply_elems2)))).setMaxBytes(800).build();
        FetchResponse.PartitionData data1 = (FetchResponse.PartitionData)this.sendFetchRequest(n, req1).responseData().get(topicPartition);
        Assert.assertEquals((Object)Errors.UNSUPPORTED_COMPRESSION_TYPE, (Object)data1.error());
        if (Predef$.MODULE$.Map() == null) {
            throw null;
        }
        FetchRequest req2 = (FetchRequest)new FetchRequest.Builder(2, 3, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)Map.EmptyMap$.MODULE$)).setMaxBytes(800).build();
        FetchResponse.PartitionData data2 = (FetchResponse.PartitionData)this.sendFetchRequest(n, req2).responseData().get(topicPartition);
        Assert.assertEquals((Object)Errors.NONE, (Object)data2.error());
        Seq<Record> seq2 = this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)data2);
        if (seq2 == null) {
            throw null;
        }
        Assert.assertEquals((long)1L, (long)seq2.length());
        Map$ map$3 = Predef$.MODULE$.Map();
        Object[] objectArray3 = new Tuple2[1];
        Long l8 = l = Long.valueOf(1L);
        l = null;
        Long $minus$greater$extension_y4 = l8;
        Object var35_60 = null;
        objectArray3[0] = new Tuple2((Object)topicPartition, (Object)$minus$greater$extension_y4);
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray3);
        if (map$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        FetchRequest req3 = (FetchRequest)new FetchRequest.Builder(0, 1, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$3, (scala.collection.immutable.Seq)apply_elems)))).setMaxBytes(800).build();
        FetchResponse.PartitionData data3 = (FetchResponse.PartitionData)this.sendFetchRequest(n, req3).responseData().get(topicPartition);
        Assert.assertEquals((Object)Errors.UNSUPPORTED_COMPRESSION_TYPE, (Object)data3.error());
        if (Predef$.MODULE$.Map() == null) {
            throw null;
        }
        FetchRequest req4 = (FetchRequest)new FetchRequest.Builder(0, 10, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)Map.EmptyMap$.MODULE$)).setMaxBytes(800).build();
        FetchResponse.PartitionData data4 = (FetchResponse.PartitionData)this.sendFetchRequest(n, req4).responseData().get(topicPartition);
        Assert.assertEquals((Object)Errors.NONE, (Object)data4.error());
        Seq<Record> seq3 = this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)data4);
        if (seq3 == null) {
            throw null;
        }
        Assert.assertEquals((long)3L, (long)seq3.length());
    }

    public Seq<Record> kafka$server$FetchRequestTest$$records(FetchResponse.PartitionData<MemoryRecords> partitionData) {
        Iterable iterable = AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.lang.Iterable)((AbstractRecords)partitionData.records()).records()).asScala();
        if (iterable == null) {
            throw null;
        }
        Iterable toBuffer_this = iterable;
        return (Buffer)Buffer$.MODULE$.from((IterableOnce)toBuffer_this);
    }

    private void checkFetchResponse(Seq<TopicPartition> expectedPartitions, FetchResponse<MemoryRecords> fetchResponse, int maxPartitionBytes, int maxResponseBytes, int numMessagesPerPartition) {
        IntRef intRef;
        IntRef intRef2;
        BooleanRef booleanRef;
        Assert.assertEquals(expectedPartitions, (Object)AsScalaExtensions.SetHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, fetchResponse.responseData().keySet()).asScala().toSeq());
        boolean create_e = false;
        BooleanRef booleanRef2 = booleanRef = new BooleanRef(create_e);
        booleanRef = null;
        BooleanRef emptyResponseSeen = booleanRef2;
        int create_e2 = 0;
        IntRef intRef3 = intRef2 = new IntRef(create_e2);
        intRef2 = null;
        IntRef responseSize = intRef3;
        int create_e3 = 0;
        IntRef intRef4 = intRef = new IntRef(create_e3);
        intRef = null;
        IntRef responseBufferSize = intRef4;
        expectedPartitions.foreach((Function1 & Serializable)tp -> {
            FetchRequestTest.$anonfun$checkFetchResponse$1(fetchResponse, responseBufferSize, numMessagesPerPartition, responseSize, emptyResponseSeen, maxPartitionBytes, tp);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)(maxResponseBytes - maxResponseBytes % maxPartitionBytes), (long)responseBufferSize.elem);
        Assert.assertTrue((responseSize.elem <= maxResponseBytes ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    private scala.collection.immutable.Map<TopicPartition, Object> createTopics(int numTopics, int numPartitions, scala.collection.immutable.Map<String, String> configs) {
        IndexedSeq indexedSeq;
        String string;
        int n = 0;
        Range.Exclusive map_this = new Range.Exclusive(n, numTopics, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        Iterator map_strictOptimizedMap_it = map_this.iterator();
        while (map_strictOptimizedMap_it.hasNext()) {
            void map_strictOptimizedMap_$plus$eq_elem;
            String string2;
            String string3 = string2 = FetchRequestTest.$anonfun$createTopics$1(BoxesRunTime.unboxToInt((Object)map_strictOptimizedMap_it.next()));
            string2 = null;
            string = string3;
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            string = null;
        }
        IndexedSeq indexedSeq2 = indexedSeq = (IndexedSeq)map_strictOptimizedMap_b.result();
        Object var7_5 = null;
        Object var8_6 = null;
        Object var9_7 = null;
        string = null;
        indexedSeq = null;
        IndexedSeq topics = indexedSeq2;
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.MinInSyncReplicasProp(), ((Object)2).toString());
        configs.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String k = (String)x0$1._1();
            String v = (String)x0$1._2();
            Object object = topicConfig.setProperty(k, v);
            return object;
        });
        return ((IterableOnceOps)topics.flatMap((Function1 & Serializable)topic -> (scala.collection.immutable.Map)this.createTopic((String)topic, numPartitions, 2, topicConfig).map((Function1 & Serializable)x0$2 -> {
            void $minus$greater$extension_y;
            Tuple2 tuple2;
            Integer n;
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            int partition = x0$2._1$mcI$sp();
            int leader = x0$2._2$mcI$sp();
            Integer n2 = n = Integer.valueOf(leader);
            n = null;
            Integer n3 = n2;
            TopicPartition $minus$greater$extension_$this = new TopicPartition(topic, partition);
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            Object var5_6 = null;
            n3 = null;
            tuple2 = null;
            Tuple2 tuple23 = tuple22;
            return tuple23;
        }))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private scala.collection.immutable.Map<String, String> createTopics$default$3() {
        if (Predef$.MODULE$.Map() == null) {
            throw null;
        }
        return Map.EmptyMap$.MODULE$;
    }

    private Seq<RecordMetadata> produceData(Iterable<TopicPartition> topicPartitions, int numMessagesPerPartition) {
        return (Seq)((scala.collection.immutable.Seq)topicPartitions.toSeq().flatMap((Function1 & Serializable)tp -> {
            int n = 0;
            Range.Exclusive map_this = new Range.Exclusive(n, numMessagesPerPartition, 1);
            map_this.scala$collection$immutable$Range$$validateMaxLength();
            Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
            for (Object object : map_this) {
                void map_strictOptimizedMap_$plus$eq_elem;
                ProducerRecord producerRecord;
                ProducerRecord producerRecord2 = producerRecord = FetchRequestTest.$anonfun$produceData$2(tp, BoxesRunTime.unboxToInt((Object)object));
                producerRecord = null;
                ProducerRecord producerRecord3 = producerRecord2;
                if (map_strictOptimizedMap_b == null) {
                    throw null;
                }
                map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
                producerRecord3 = null;
            }
            return (IndexedSeq)map_strictOptimizedMap_b.result();
        })).map((Function1 & Serializable)x$20 -> (RecordMetadata)this.producer().send(x$20).get());
    }

    private final FetchRequest createFetchRequest$1(Seq topicPartitions, scala.collection.immutable.Map offsetMap, int maxResponseBytes$1, int maxPartitionBytes$2) {
        return this.createFetchRequest(maxResponseBytes$1, maxPartitionBytes$2, (Seq<TopicPartition>)topicPartitions, (scala.collection.immutable.Map<TopicPartition, Object>)offsetMap);
    }

    private static final scala.collection.immutable.Map createFetchRequest$default$2$1() {
        Predef$.MODULE$.Map();
        return Map.EmptyMap$.MODULE$;
    }

    public static final /* synthetic */ int $anonfun$testBrokerRespectsPartitionsOrderAndSizeLimits$2(FetchRequestTest $this, FetchResponse.PartitionData partitionData) {
        return BoxesRunTime.unboxToInt((Object)((IterableOnceOps)$this.kafka$server$FetchRequestTest$$records((FetchResponse.PartitionData<MemoryRecords>)partitionData).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.sizeInBytes()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public static final /* synthetic */ boolean $anonfun$testFetchRequestToNonReplica$1(int leader$1, KafkaServer x$9) {
        return x$9.config().brokerId() != leader$1;
    }

    private final void assertResponseErrorForEpoch$1(Errors error, int brokerId, Optional leaderEpoch, TopicPartition topicPartition$1) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> partitionMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        partitionMap.put(topicPartition$1, new FetchRequest.PartitionData(0L, 0L, 1024, leaderEpoch));
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((int)0, (int)1, partitionMap).build();
        FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)this.sendFetchRequest(brokerId, fetchRequest).responseData().get(topicPartition$1);
        Assert.assertEquals((Object)error, (Object)partitionData.error());
    }

    private final void assertResponseErrorForEpoch$2(Errors expectedError, int sessionFetchEpoch, Optional leaderEpoch, TopicPartition topicPartition$2, int sessionId$1, int destinationBrokerId$1) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> partitionMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        partitionMap.put(topicPartition$2, new FetchRequest.PartitionData(0L, 0L, 1024, leaderEpoch));
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((int)0, (int)1, partitionMap).metadata(new FetchMetadata(sessionId$1, sessionFetchEpoch)).build();
        FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)this.sendFetchRequest(destinationBrokerId$1, fetchRequest).responseData().get(topicPartition$2);
        Assert.assertEquals((Object)expectedError, (Object)partitionData.error());
    }

    private final Option fetch$1(short version, int maxPartitionBytes, boolean closeAfterPartialResponse, TopicPartition topicPartition$3, int leaderId$2, int batchSize$1) {
        Some some;
        FetchRequest fetchRequest = FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(maxPartitionBytes, (Seq<TopicPartition>)new .colon.colon((Object)topicPartition$3, (List)Nil$.MODULE$), this.createPartitionMap$default$3())).build(version);
        try (Socket socket = this.connect(this.brokerSocketServer(leaderId$2), this.connect$default$2());){
            this.send((AbstractRequest)fetchRequest, socket, this.send$default$3(), this.send$default$4());
            if (closeAfterPartialResponse) {
                int size = new DataInputStream(socket.getInputStream()).readInt();
                Assert.assertTrue((String)new StringBuilder(56).append("Fetch size too small ").append(size).append(", broker may have run out of memory").toString(), (size > maxPartitionBytes - batchSize$1 ? 1 : 0) != 0);
                some = None$.MODULE$;
            } else {
                some = new Some(this.receive(socket, ApiKeys.FETCH, version, ClassTag$.MODULE$.apply(FetchResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl())));
            }
        }
        return some;
    }

    public static final /* synthetic */ Nothing$ $anonfun$testDownConversionWithConnectionFailure$4() {
        throw new IllegalStateException("No fetch response");
    }

    public static final /* synthetic */ Future $anonfun$testDownConversionFromBatchedToUnbatchedRespectsOffset$1(FetchRequestTest $this, String topic$1, int i) {
        return $this.producer().send(new ProducerRecord(topic$1, (Object)new StringBuilder(4).append("key-").append(i).toString(), (Object)new StringBuilder(6).append("value-").append(i).toString()));
    }

    public static final /* synthetic */ Future $anonfun$testDownConversionFromBatchedToUnbatchedRespectsOffset$2(FetchRequestTest $this, String topic$1, int i) {
        return $this.producer().send(new ProducerRecord(topic$1, (Object)new StringBuilder(4).append("key-").append(i).toString(), (Object)new StringBuilder(6).append("value-").append(i).toString()));
    }

    /*
     * WARNING - void declaration
     */
    private final void check$1(long fetchOffset, short requestVersion, long expectedOffset, int expectedNumBatches, byte expectedMagic, TopicPartition topicPartition$4, int leaderId$3) {
        int batchesReceived;
        Buffer batches;
        long currentFetchOffset = fetchOffset;
        long currentExpectedOffset = expectedOffset;
        for (batchesReceived = 0; batchesReceived < expectedNumBatches; batchesReceived += batches.length()) {
            Iterable toBuffer_this;
            void apply_elems;
            Long l;
            Map$ map$ = Predef$.MODULE$.Map();
            Object[] objectArray = new Tuple2[1];
            Long l2 = l = Long.valueOf(currentFetchOffset);
            l = null;
            Long $minus$greater$extension_y = l2;
            Object var19_15 = null;
            objectArray[0] = new Tuple2((Object)topicPartition$4, (Object)$minus$greater$extension_y);
            ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
            if (map$ == null) {
                throw null;
            }
            arraySeq = null;
            FetchRequest fetchRequest = FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(Integer.MAX_VALUE, (Seq<TopicPartition>)new .colon.colon((Object)topicPartition$4, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems)))).build(requestVersion);
            FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)this.sendFetchRequest(leaderId$3, fetchRequest).responseData().get(topicPartition$4);
            Assert.assertEquals((Object)Errors.NONE, (Object)partitionData.error());
            Assert.assertTrue((partitionData.highWatermark() > 0L ? 1 : 0) != 0);
            if (AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.lang.Iterable)((MemoryRecords)partitionData.records()).batches()).asScala() == null) {
                throw null;
            }
            Object var20_16 = null;
            batches = (Buffer)Buffer$.MODULE$.from((IterableOnce)toBuffer_this);
            MutableRecordBatch batch = (MutableRecordBatch)batches.head();
            Assert.assertEquals((long)expectedMagic, (long)batch.magic());
            Assert.assertEquals((long)currentExpectedOffset, (long)batch.baseOffset());
            currentFetchOffset = ((RecordBatch)batches.last()).lastOffset() + 1L;
            currentExpectedOffset += ((RecordBatch)batches.last()).lastOffset() - ((RecordBatch)batches.head()).baseOffset() + 1L;
        }
        Assert.assertEquals((long)expectedNumBatches, (long)batchesReceived);
    }

    private final FetchRequest createFetchRequest$2(Seq topicPartitions, FetchMetadata metadata, Seq toForget) {
        if (Predef$.MODULE$.Map() == null) {
            throw null;
        }
        return (FetchRequest)FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(Integer.MAX_VALUE, (Seq<TopicPartition>)topicPartitions, (scala.collection.immutable.Map<TopicPartition, Object>)Map.EmptyMap$.MODULE$)).toForget(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)toForget).asJava()).metadata(metadata).build();
    }

    public static final /* synthetic */ void $anonfun$checkFetchResponse$1(FetchResponse fetchResponse$1, IntRef responseBufferSize$1, int numMessagesPerPartition$1, IntRef responseSize$1, BooleanRef emptyResponseSeen$1, int maxPartitionBytes$3, TopicPartition tp) {
        FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)fetchResponse$1.responseData().get(tp);
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionData.error());
        Assert.assertTrue((partitionData.highWatermark() > 0L ? 1 : 0) != 0);
        MemoryRecords records = (MemoryRecords)partitionData.records();
        responseBufferSize$1.elem += records.sizeInBytes();
        Iterable iterable = AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.lang.Iterable)records.batches()).asScala();
        if (iterable == null) {
            throw null;
        }
        Iterable toBuffer_this = iterable;
        Object var11_9 = null;
        Buffer batches = (Buffer)Buffer$.MODULE$.from((IterableOnce)toBuffer_this);
        if (batches == null) {
            throw null;
        }
        Assert.assertTrue((batches.length() < numMessagesPerPartition$1 ? 1 : 0) != 0);
        int batchesSize = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)batches.map((Function1 & Serializable)x$19 -> BoxesRunTime.boxToInteger((int)x$19.sizeInBytes()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        responseSize$1.elem += batchesSize;
        if (batchesSize == 0 && !emptyResponseSeen$1.elem) {
            Assert.assertEquals((long)0L, (long)records.sizeInBytes());
            emptyResponseSeen$1.elem = true;
            return;
        }
        if (batchesSize != 0 && !emptyResponseSeen$1.elem) {
            Assert.assertTrue((batchesSize <= maxPartitionBytes$3 ? 1 : 0) != 0);
            Assert.assertEquals((long)maxPartitionBytes$3, (long)records.sizeInBytes());
            return;
        }
        if (batchesSize != 0 && emptyResponseSeen$1.elem) {
            Assert.fail((String)new StringBuilder(53).append("Expected partition with size 0, but found ").append(tp).append(" with size ").append(batchesSize).toString());
            return;
        }
        if (records.sizeInBytes() != 0 && emptyResponseSeen$1.elem) {
            Assert.fail((String)new StringBuilder(60).append("Expected partition buffer with size 0, but found ").append(tp).append(" with size ").append(records.sizeInBytes()).toString());
        }
    }

    public static final /* synthetic */ String $anonfun$createTopics$1(int t) {
        return new StringBuilder(5).append("topic").append(t).toString();
    }

    public static final /* synthetic */ ProducerRecord $anonfun$produceData$2(TopicPartition tp$1, int messageIndex) {
        String suffix = new StringBuilder(1).append(tp$1).append("-").append(messageIndex).toString();
        return new ProducerRecord(tp$1.topic(), Integer.valueOf(tp$1.partition()), (Object)new StringBuilder(4).append("key ").append(suffix).toString(), (Object)new StringBuilder(6).append("value ").append(suffix).toString());
    }

    public static final /* synthetic */ Future $anonfun$testDownConversionWithConnectionFailure$1$adapted(KafkaProducer producer$1, TopicPartition topicPartition$3, byte[] bytes$1, Object x$11) {
        return producer$1.send(new ProducerRecord(topicPartition$3.topic(), Integer.valueOf(topicPartition$3.partition()), (Object)"key", (Object)bytes$1));
    }

    public static final /* synthetic */ Option $anonfun$testDownConversionWithConnectionFailure$3$adapted(FetchRequestTest $this, short version$1, int msgValueLen$1, TopicPartition topicPartition$3, int leaderId$2, int batchSize$1, Object x$13) {
        return $this.fetch$1(version$1, msgValueLen$1 * 1000, true, topicPartition$3, leaderId$2, batchSize$1);
    }

    public static final /* synthetic */ Future $anonfun$testDownConversionFromBatchedToUnbatchedRespectsOffset$1$adapted(FetchRequestTest $this, String topic$1, Object i) {
        return FetchRequestTest.$anonfun$testDownConversionFromBatchedToUnbatchedRespectsOffset$1($this, topic$1, BoxesRunTime.unboxToInt((Object)i));
    }

    public static final /* synthetic */ Future $anonfun$testDownConversionFromBatchedToUnbatchedRespectsOffset$2$adapted(FetchRequestTest $this, String topic$1, Object i) {
        return FetchRequestTest.$anonfun$testDownConversionFromBatchedToUnbatchedRespectsOffset$2($this, topic$1, BoxesRunTime.unboxToInt((Object)i));
    }

    public static final /* synthetic */ String $anonfun$createTopics$1$adapted(Object t) {
        return FetchRequestTest.$anonfun$createTopics$1(BoxesRunTime.unboxToInt((Object)t));
    }

    public static final /* synthetic */ ProducerRecord $anonfun$produceData$2$adapted(TopicPartition tp$1, Object messageIndex) {
        return FetchRequestTest.$anonfun$produceData$2(tp$1, BoxesRunTime.unboxToInt((Object)messageIndex));
    }
}

