/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry;

import com.netflix.config.DynamicPropertyFactory;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;
import org.apache.servicecomb.config.ConfigUtil;
import org.apache.servicecomb.config.archaius.sources.MicroserviceConfigLoader;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.apache.servicecomb.foundation.common.net.IpPort;
import org.apache.servicecomb.foundation.common.net.NetUtils;
import org.apache.servicecomb.serviceregistry.ServiceRegistry;
import org.apache.servicecomb.serviceregistry.api.registry.Microservice;
import org.apache.servicecomb.serviceregistry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.serviceregistry.cache.InstanceCacheManager;
import org.apache.servicecomb.serviceregistry.client.ServiceRegistryClient;
import org.apache.servicecomb.serviceregistry.client.http.MicroserviceInstances;
import org.apache.servicecomb.serviceregistry.config.ServiceRegistryConfig;
import org.apache.servicecomb.serviceregistry.definition.MicroserviceDefinition;
import org.apache.servicecomb.serviceregistry.registry.ServiceRegistryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RegistryUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegistryUtils.class);
    private static ServiceRegistry serviceRegistry;
    public static final String PUBLISH_ADDRESS = "cse.service.publishAddress";
    private static final String PUBLISH_PORT = "cse.{transport_name}.publishPort";

    private RegistryUtils() {
    }

    public static void init() {
        MicroserviceConfigLoader loader = ConfigUtil.getMicroserviceConfigLoader();
        MicroserviceDefinition microserviceDefinition = new MicroserviceDefinition(loader.getConfigModels());
        serviceRegistry = ServiceRegistryFactory.getOrCreate(EventManager.eventBus, ServiceRegistryConfig.INSTANCE, microserviceDefinition);
        serviceRegistry.init();
    }

    public static void run() {
        serviceRegistry.run();
    }

    public static void destroy() {
        serviceRegistry.destroy();
    }

    @Deprecated
    public static void destory() {
        RegistryUtils.destroy();
    }

    public static ServiceRegistry getServiceRegistry() {
        return serviceRegistry;
    }

    public static void setServiceRegistry(ServiceRegistry serviceRegistry) {
        RegistryUtils.serviceRegistry = serviceRegistry;
    }

    public static ServiceRegistryClient getServiceRegistryClient() {
        return serviceRegistry.getServiceRegistryClient();
    }

    public static InstanceCacheManager getInstanceCacheManager() {
        return serviceRegistry.getInstanceCacheManager();
    }

    public static String getAppId() {
        return serviceRegistry.getMicroservice().getAppId();
    }

    public static Microservice getMicroservice() {
        return serviceRegistry.getMicroservice();
    }

    public static MicroserviceInstance getMicroserviceInstance() {
        return serviceRegistry.getMicroserviceInstance();
    }

    public static String getPublishAddress() {
        String publicAddressSetting = DynamicPropertyFactory.getInstance().getStringProperty(PUBLISH_ADDRESS, "").get();
        if ((publicAddressSetting = publicAddressSetting.trim()).isEmpty()) {
            return NetUtils.getHostAddress();
        }
        if (publicAddressSetting.startsWith("{") && publicAddressSetting.endsWith("}")) {
            return NetUtils.ensureGetInterfaceAddress((String)publicAddressSetting.substring(1, publicAddressSetting.length() - 1)).getHostAddress();
        }
        return publicAddressSetting;
    }

    public static String getPublishHostName() {
        String publicAddressSetting = DynamicPropertyFactory.getInstance().getStringProperty(PUBLISH_ADDRESS, "").get();
        if ((publicAddressSetting = publicAddressSetting.trim()).isEmpty()) {
            return NetUtils.getHostName();
        }
        if (publicAddressSetting.startsWith("{") && publicAddressSetting.endsWith("}")) {
            return NetUtils.ensureGetInterfaceAddress((String)publicAddressSetting.substring(1, publicAddressSetting.length() - 1)).getHostName();
        }
        return publicAddressSetting;
    }

    public static String getPublishAddress(String schema, String address) {
        if (address == null) {
            return address;
        }
        try {
            URI originalURI = new URI(schema + "://" + address);
            IpPort ipPort = NetUtils.parseIpPort((String)originalURI.getAuthority());
            if (ipPort == null) {
                LOGGER.warn("address {} not valid.", (Object)address);
                return null;
            }
            IpPort publishIpPort = RegistryUtils.genPublishIpPort(schema, ipPort);
            URIBuilder builder = new URIBuilder(originalURI);
            return builder.setHost(publishIpPort.getHostOrIp()).setPort(publishIpPort.getPort()).build().toString();
        }
        catch (URISyntaxException e) {
            LOGGER.warn("address {} not valid.", (Object)address);
            return null;
        }
    }

    private static IpPort genPublishIpPort(String schema, IpPort ipPort) {
        String publicAddressSetting = DynamicPropertyFactory.getInstance().getStringProperty(PUBLISH_ADDRESS, "").get();
        if ((publicAddressSetting = publicAddressSetting.trim()).isEmpty()) {
            InetSocketAddress socketAddress = ipPort.getSocketAddress();
            if (socketAddress.getAddress().isAnyLocalAddress()) {
                String host = NetUtils.getHostAddress();
                LOGGER.warn("address {}, auto select a host address to publish {}:{}, maybe not the correct one", new Object[]{socketAddress, host, socketAddress.getPort()});
                return new IpPort(host, ipPort.getPort());
            }
            return ipPort;
        }
        if (publicAddressSetting.startsWith("{") && publicAddressSetting.endsWith("}")) {
            publicAddressSetting = NetUtils.ensureGetInterfaceAddress((String)publicAddressSetting.substring(1, publicAddressSetting.length() - 1)).getHostAddress();
        }
        String publishPortKey = PUBLISH_PORT.replace("{transport_name}", schema);
        int publishPortSetting = DynamicPropertyFactory.getInstance().getIntProperty(publishPortKey, 0).get();
        int publishPort = publishPortSetting == 0 ? ipPort.getPort() : publishPortSetting;
        return new IpPort(publicAddressSetting, publishPort);
    }

    public static List<MicroserviceInstance> findServiceInstance(String appId, String serviceName, String versionRule) {
        return serviceRegistry.findServiceInstance(appId, serviceName, versionRule);
    }

    public static boolean updateInstanceProperties(Map<String, String> instanceProperties) {
        return serviceRegistry.updateInstanceProperties(instanceProperties);
    }

    public static Microservice getMicroservice(String microserviceId) {
        return serviceRegistry.getRemoteMicroservice(microserviceId);
    }

    public static MicroserviceInstances findServiceInstances(String appId, String serviceName, String versionRule, String revision) {
        return serviceRegistry.findServiceInstances(appId, serviceName, versionRule, revision);
    }
}

