/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.module;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.skywalking.oap.server.library.module.CycleDependencyException;
import org.apache.skywalking.oap.server.library.module.ModuleDefine;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.ModuleNotFoundException;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BootstrapFlow {
    private static final Logger logger = LoggerFactory.getLogger(BootstrapFlow.class);
    private Map<String, ModuleDefine> loadedModules;
    private List<ModuleProvider> startupSequence;

    BootstrapFlow(Map<String, ModuleDefine> loadedModules) throws CycleDependencyException {
        this.loadedModules = loadedModules;
        this.startupSequence = new LinkedList<ModuleProvider>();
        this.makeSequence();
    }

    void start(ModuleManager moduleManager) throws ModuleNotFoundException, ServiceNotProvidedException, ModuleStartException {
        for (ModuleProvider provider : this.startupSequence) {
            String[] requiredModules = provider.requiredModules();
            if (requiredModules != null) {
                for (String module : requiredModules) {
                    if (moduleManager.has(module)) continue;
                    throw new ModuleNotFoundException(module + " is required by " + provider.getModuleName() + "." + provider.name() + ", but not found.");
                }
            }
            logger.info("start the provider {} in {} module.", (Object)provider.name(), (Object)provider.getModuleName());
            provider.requiredCheck(provider.getModule().services());
            provider.start();
        }
    }

    void notifyAfterCompleted() throws ServiceNotProvidedException, ModuleStartException {
        for (ModuleProvider provider : this.startupSequence) {
            provider.notifyAfterCompleted();
        }
    }

    private void makeSequence() throws CycleDependencyException {
        ArrayList allProviders = new ArrayList();
        this.loadedModules.forEach((moduleName, module) -> allProviders.addAll(module.providers()));
        do {
            int numOfToBeSequenced = allProviders.size();
            for (int i = 0; i < allProviders.size(); ++i) {
                ModuleProvider provider2 = (ModuleProvider)allProviders.get(i);
                Object[] requiredModules = provider2.requiredModules();
                if (CollectionUtils.isNotEmpty((Object[])requiredModules)) {
                    boolean isAllRequiredModuleStarted = true;
                    for (Object module2 : requiredModules) {
                        boolean exist = false;
                        for (ModuleProvider moduleProvider : this.startupSequence) {
                            if (!moduleProvider.getModuleName().equals(module2)) continue;
                            exist = true;
                            break;
                        }
                        if (exist) continue;
                        isAllRequiredModuleStarted = false;
                        break;
                    }
                    if (!isAllRequiredModuleStarted) continue;
                    this.startupSequence.add(provider2);
                    allProviders.remove(i);
                    --i;
                    continue;
                }
                this.startupSequence.add(provider2);
                allProviders.remove(i);
                --i;
            }
            if (numOfToBeSequenced != allProviders.size()) continue;
            StringBuilder unSequencedProviders = new StringBuilder();
            allProviders.forEach(provider -> unSequencedProviders.append(provider.getModuleName()).append("[provider=").append(provider.getClass().getName()).append("]\n"));
            throw new CycleDependencyException("Exist cycle module dependencies in \n" + unSequencedProviders.substring(0, unSequencedProviders.length() - 1));
        } while (allProviders.size() != 0);
    }
}

