/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.module;

import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.ServiceLoader;
import org.apache.skywalking.oap.server.library.module.ApplicationConfiguration;
import org.apache.skywalking.oap.server.library.module.DuplicateProviderException;
import org.apache.skywalking.oap.server.library.module.ModuleConfig;
import org.apache.skywalking.oap.server.library.module.ModuleConfigException;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleProviderHolder;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.ProviderNotFoundException;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ModuleDefine
implements ModuleProviderHolder {
    private static final Logger logger = LoggerFactory.getLogger(ModuleDefine.class);
    private final LinkedList<ModuleProvider> loadedProviders = new LinkedList();
    private final String name;

    public ModuleDefine(String name) {
        this.name = name;
    }

    public final String name() {
        return this.name;
    }

    public abstract Class[] services();

    void prepare(ModuleManager moduleManager, ApplicationConfiguration.ModuleConfiguration configuration, ServiceLoader<ModuleProvider> moduleProviderLoader) throws ProviderNotFoundException, ServiceNotProvidedException, ModuleConfigException, ModuleStartException {
        boolean providerExist = false;
        for (ModuleProvider provider : moduleProviderLoader) {
            ModuleProvider newProvider;
            if (!configuration.has(provider.name())) continue;
            providerExist = true;
            if (!provider.module().equals(this.getClass())) continue;
            try {
                newProvider = (ModuleProvider)provider.getClass().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new ProviderNotFoundException(e);
            }
            newProvider.setManager(moduleManager);
            newProvider.setModuleDefine(this);
            this.loadedProviders.add(newProvider);
        }
        if (!providerExist) {
            throw new ProviderNotFoundException(this.name() + " module no provider exists.");
        }
        for (ModuleProvider moduleProvider : this.loadedProviders) {
            logger.info("Prepare the {} provider in {} module.", (Object)moduleProvider.name(), (Object)this.name());
            try {
                this.copyProperties(moduleProvider.createConfigBeanIfAbsent(), configuration.getProviderConfiguration(moduleProvider.name()), this.name(), moduleProvider.name());
            }
            catch (IllegalAccessException e) {
                throw new ModuleConfigException(this.name() + " module config transport to config bean failure.", e);
            }
            moduleProvider.prepare();
        }
    }

    private void copyProperties(ModuleConfig dest, Properties src, String moduleName, String providerName) throws IllegalAccessException {
        if (dest == null) {
            return;
        }
        Enumeration<?> propertyNames = src.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String propertyName = (String)propertyNames.nextElement();
            Class<?> destClass = dest.getClass();
            try {
                Field field = this.getDeclaredField(destClass, propertyName);
                field.setAccessible(true);
                field.set(dest, src.get(propertyName));
            }
            catch (NoSuchFieldException e) {
                logger.warn(propertyName + " setting is not supported in " + providerName + " provider of " + moduleName + " module");
            }
        }
    }

    private Field getDeclaredField(Class<?> destClass, String fieldName) throws NoSuchFieldException {
        if (destClass != null) {
            Field[] fields;
            for (Field field : fields = destClass.getDeclaredFields()) {
                if (!field.getName().equals(fieldName)) continue;
                return field;
            }
            return this.getDeclaredField(destClass.getSuperclass(), fieldName);
        }
        throw new NoSuchFieldException();
    }

    final List<ModuleProvider> providers() {
        return this.loadedProviders;
    }

    @Override
    public final ModuleProvider provider() throws DuplicateProviderException, ProviderNotFoundException {
        if (this.loadedProviders.size() > 1) {
            throw new DuplicateProviderException(this.name() + " module exist " + this.loadedProviders.size() + " providers");
        }
        if (this.loadedProviders.size() == 0) {
            throw new ProviderNotFoundException("There is no module provider in " + this.name() + " module!");
        }
        return this.loadedProviders.getFirst();
    }
}

