/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.register.provider.handler.v5.grpc;

import com.google.protobuf.ProtocolStringList;
import io.grpc.stub.StreamObserver;
import org.apache.skywalking.apm.network.language.agent.KeyWithIntegerValue;
import org.apache.skywalking.apm.network.language.agent.NetworkAddressMappings;
import org.apache.skywalking.apm.network.language.agent.NetworkAddressRegisterServiceGrpc;
import org.apache.skywalking.apm.network.language.agent.NetworkAddresses;
import org.apache.skywalking.oap.server.core.register.service.INetworkAddressInventoryRegister;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.server.grpc.GRPCHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkAddressRegisterServiceHandler
extends NetworkAddressRegisterServiceGrpc.NetworkAddressRegisterServiceImplBase
implements GRPCHandler {
    private static final Logger logger = LoggerFactory.getLogger(NetworkAddressRegisterServiceHandler.class);
    private final INetworkAddressInventoryRegister networkAddressInventoryRegister;

    public NetworkAddressRegisterServiceHandler(ModuleManager moduleManager) {
        this.networkAddressInventoryRegister = (INetworkAddressInventoryRegister)moduleManager.find("core").provider().getService(INetworkAddressInventoryRegister.class);
    }

    public void batchRegister(NetworkAddresses request, StreamObserver<NetworkAddressMappings> responseObserver) {
        if (logger.isDebugEnabled()) {
            logger.debug("register application");
        }
        ProtocolStringList addressesList = request.getAddressesList();
        NetworkAddressMappings.Builder builder = NetworkAddressMappings.newBuilder();
        for (String networkAddress : addressesList) {
            int addressId = this.networkAddressInventoryRegister.getOrCreate(networkAddress, null);
            if (addressId == 0) continue;
            KeyWithIntegerValue value = KeyWithIntegerValue.newBuilder().setKey(networkAddress).setValue(addressId).build();
            builder.addAddressIds(value);
        }
        responseObserver.onNext((Object)builder.build());
        responseObserver.onCompleted();
    }
}

