/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.register.provider.handler.v5.rest;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.apache.skywalking.oap.server.core.cache.ServiceInventoryCache;
import org.apache.skywalking.oap.server.core.register.ServiceInstanceInventory;
import org.apache.skywalking.oap.server.core.register.ServiceInventory;
import org.apache.skywalking.oap.server.core.register.service.IServiceInstanceInventoryRegister;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.server.jetty.ArgumentsParseException;
import org.apache.skywalking.oap.server.library.server.jetty.JettyJsonHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceDiscoveryServletHandler
extends JettyJsonHandler {
    private static final Logger logger = LoggerFactory.getLogger(InstanceDiscoveryServletHandler.class);
    private final IServiceInstanceInventoryRegister serviceInstanceInventoryRegister;
    private final ServiceInventoryCache serviceInventoryCache;
    private final Gson gson = new Gson();
    private static final String APPLICATION_ID = "ai";
    private static final String AGENT_UUID = "au";
    private static final String REGISTER_TIME = "rt";
    private static final String INSTANCE_ID = "ii";
    private static final String OS_INFO = "oi";

    public InstanceDiscoveryServletHandler(ModuleManager moduleManager) {
        this.serviceInventoryCache = (ServiceInventoryCache)moduleManager.find("core").provider().getService(ServiceInventoryCache.class);
        this.serviceInstanceInventoryRegister = (IServiceInstanceInventoryRegister)moduleManager.find("core").provider().getService(IServiceInstanceInventoryRegister.class);
    }

    public String pathSpec() {
        return "/instance/register";
    }

    protected JsonElement doGet(HttpServletRequest req) throws ArgumentsParseException {
        throw new UnsupportedOperationException();
    }

    protected JsonElement doPost(HttpServletRequest req) throws ArgumentsParseException {
        JsonObject responseJson = new JsonObject();
        try {
            JsonObject instance = (JsonObject)this.gson.fromJson((Reader)req.getReader(), JsonObject.class);
            int applicationId = instance.get(APPLICATION_ID).getAsInt();
            String agentUUID = instance.get(AGENT_UUID).getAsString();
            long registerTime = instance.get(REGISTER_TIME).getAsLong();
            JsonObject osInfoJson = instance.get(OS_INFO).getAsJsonObject();
            ArrayList ipv4sList = new ArrayList();
            JsonArray ipv4s = osInfoJson.get("ipv4s").getAsJsonArray();
            ipv4s.forEach(ipv4 -> ipv4sList.add(ipv4.getAsString()));
            ServiceInventory serviceInventory = this.serviceInventoryCache.get(applicationId);
            JsonObject instanceProperties = new JsonObject();
            instanceProperties.addProperty("host_name", osInfoJson.get("hostName").getAsString());
            instanceProperties.addProperty("os_name", osInfoJson.get("osName").getAsString());
            instanceProperties.addProperty("process_no", osInfoJson.get("processId").getAsInt() + "");
            instanceProperties.addProperty("ipv4s", ServiceInstanceInventory.PropertyUtil.ipv4sSerialize(ipv4sList));
            String instanceName = serviceInventory.getName();
            if (instanceProperties.has("process_no")) {
                instanceName = instanceName + "-pid:" + instanceProperties.get("process_no").getAsString();
            }
            if (instanceProperties.has("host_name")) {
                instanceName = instanceName + "@" + instanceProperties.get("host_name").getAsString();
            }
            int instanceId = this.serviceInstanceInventoryRegister.getOrCreate(applicationId, instanceName, agentUUID, registerTime, instanceProperties);
            responseJson.addProperty(APPLICATION_ID, (Number)applicationId);
            responseJson.addProperty(INSTANCE_ID, (Number)instanceId);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return responseJson;
    }
}

