/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.register.provider.handler.v5.rest;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.Reader;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.skywalking.apm.network.language.agent.SpanType;
import org.apache.skywalking.oap.server.core.register.service.IEndpointInventoryRegister;
import org.apache.skywalking.oap.server.core.source.DetectPoint;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.server.jetty.ArgumentsParseException;
import org.apache.skywalking.oap.server.library.server.jetty.JettyJsonHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceNameDiscoveryServiceHandler
extends JettyJsonHandler {
    private static final Logger logger = LoggerFactory.getLogger(ServiceNameDiscoveryServiceHandler.class);
    private final IEndpointInventoryRegister inventoryService;
    private final Gson gson = new Gson();
    private static final String APPLICATION_ID = "ai";
    private static final String SERVICE_NAME = "sn";
    private static final String SRC_SPAN_TYPE = "st";
    private static final String SERVICE_ID = "si";
    private static final String ELEMENT = "el";

    public ServiceNameDiscoveryServiceHandler(ModuleManager moduleManager) {
        this.inventoryService = (IEndpointInventoryRegister)moduleManager.find("core").provider().getService(IEndpointInventoryRegister.class);
    }

    public String pathSpec() {
        return "/servicename/discovery";
    }

    protected JsonElement doGet(HttpServletRequest req) throws ArgumentsParseException {
        throw new UnsupportedOperationException();
    }

    protected JsonElement doPost(HttpServletRequest req) throws ArgumentsParseException {
        JsonArray responseArray = new JsonArray();
        try {
            JsonArray services = (JsonArray)this.gson.fromJson((Reader)req.getReader(), JsonArray.class);
            for (JsonElement service : services) {
                int serviceId;
                int applicationId = service.getAsJsonObject().get(APPLICATION_ID).getAsInt();
                String serviceName = service.getAsJsonObject().get(SERVICE_NAME).getAsString();
                int srcSpanType = service.getAsJsonObject().get(SRC_SPAN_TYPE).getAsInt();
                SpanType spanType = SpanType.forNumber((int)srcSpanType);
                if (!Objects.nonNull(spanType) || (serviceId = this.inventoryService.getOrCreate(applicationId, serviceName, DetectPoint.fromSpanType((SpanType)spanType))) == 0) continue;
                JsonObject responseJson = new JsonObject();
                responseJson.addProperty(SERVICE_ID, (Number)serviceId);
                responseJson.add(ELEMENT, service);
                responseArray.add((JsonElement)responseJson);
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return responseArray;
    }
}

