/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.register.provider.handler.v6.grpc;

import io.grpc.stub.StreamObserver;
import java.util.Objects;
import org.apache.skywalking.apm.network.common.Commands;
import org.apache.skywalking.apm.network.register.v2.ServiceInstancePingGrpc;
import org.apache.skywalking.apm.network.register.v2.ServiceInstancePingPkg;
import org.apache.skywalking.oap.server.core.cache.ServiceInstanceInventoryCache;
import org.apache.skywalking.oap.server.core.register.ServiceInstanceInventory;
import org.apache.skywalking.oap.server.core.register.service.IServiceInstanceInventoryRegister;
import org.apache.skywalking.oap.server.core.register.service.IServiceInventoryRegister;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.server.grpc.GRPCHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceInstancePingServiceHandler
extends ServiceInstancePingGrpc.ServiceInstancePingImplBase
implements GRPCHandler {
    private static final Logger logger = LoggerFactory.getLogger(ServiceInstancePingServiceHandler.class);
    private final ServiceInstanceInventoryCache serviceInstanceInventoryCache;
    private final IServiceInventoryRegister serviceInventoryRegister;
    private final IServiceInstanceInventoryRegister serviceInstanceInventoryRegister;

    public ServiceInstancePingServiceHandler(ModuleManager moduleManager) {
        this.serviceInstanceInventoryCache = (ServiceInstanceInventoryCache)moduleManager.find("core").provider().getService(ServiceInstanceInventoryCache.class);
        this.serviceInventoryRegister = (IServiceInventoryRegister)moduleManager.find("core").provider().getService(IServiceInventoryRegister.class);
        this.serviceInstanceInventoryRegister = (IServiceInstanceInventoryRegister)moduleManager.find("core").provider().getService(IServiceInstanceInventoryRegister.class);
    }

    public void doPing(ServiceInstancePingPkg request, StreamObserver<Commands> responseObserver) {
        int serviceInstanceId = request.getServiceInstanceId();
        long heartBeatTime = request.getTime();
        this.serviceInstanceInventoryRegister.heartbeat(serviceInstanceId, heartBeatTime);
        ServiceInstanceInventory serviceInstanceInventory = this.serviceInstanceInventoryCache.get(serviceInstanceId);
        if (Objects.nonNull(serviceInstanceInventory)) {
            this.serviceInventoryRegister.heartbeat(serviceInstanceInventory.getServiceId(), heartBeatTime);
        } else {
            logger.warn("Can't found service by service instance id from cache, service instance id is: {}", (Object)serviceInstanceId);
        }
        responseObserver.onNext((Object)Commands.getDefaultInstance());
        responseObserver.onCompleted();
    }
}

