/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch;

import java.io.IOException;
import org.apache.skywalking.apm.util.StringUtil;
import org.apache.skywalking.oap.server.core.config.ConfigService;
import org.apache.skywalking.oap.server.core.storage.IBatchDAO;
import org.apache.skywalking.oap.server.core.storage.IHistoryDeleteDAO;
import org.apache.skywalking.oap.server.core.storage.IRegisterLockDAO;
import org.apache.skywalking.oap.server.core.storage.StorageDAO;
import org.apache.skywalking.oap.server.core.storage.StorageException;
import org.apache.skywalking.oap.server.core.storage.StorageModule;
import org.apache.skywalking.oap.server.core.storage.cache.IEndpointInventoryCacheDAO;
import org.apache.skywalking.oap.server.core.storage.cache.INetworkAddressInventoryCacheDAO;
import org.apache.skywalking.oap.server.core.storage.cache.IServiceInstanceInventoryCacheDAO;
import org.apache.skywalking.oap.server.core.storage.cache.IServiceInventoryCacheDAO;
import org.apache.skywalking.oap.server.core.storage.query.IAggregationQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IAlarmQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ILogQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IMetadataQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IMetricsQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ITopNRecordsQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ITopologyQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.ITraceQueryDAO;
import org.apache.skywalking.oap.server.library.client.Client;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.library.module.ModuleConfig;
import org.apache.skywalking.oap.server.library.module.ModuleDefine;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.StorageModuleElasticsearchConfig;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.BatchProcessEsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.HistoryDeleteEsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.StorageEsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.StorageEsInstaller;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.cache.EndpointInventoryCacheEsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.cache.NetworkAddressInventoryCacheEsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.cache.ServiceInstanceInventoryCacheDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.cache.ServiceInventoryCacheEsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.lock.RegisterLockDAOImpl;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.lock.RegisterLockInstaller;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query.AggregationQueryEsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query.AlarmQueryEsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query.LogQueryEsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query.MetadataQueryEsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query.MetricsQueryEsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query.TopNRecordsQueryEsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query.TopologyQueryEsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query.TraceQueryEsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.ttl.ElasticsearchStorageTTL;

public class StorageModuleElasticsearchProvider
extends ModuleProvider {
    protected final StorageModuleElasticsearchConfig config = new StorageModuleElasticsearchConfig();
    protected ElasticSearchClient elasticSearchClient;

    public String name() {
        return "elasticsearch";
    }

    public Class<? extends ModuleDefine> module() {
        return StorageModule.class;
    }

    public ModuleConfig createConfigBeanIfAbsent() {
        return this.config;
    }

    public void prepare() throws ServiceNotProvidedException {
        if (!StringUtil.isEmpty((String)this.config.getNameSpace())) {
            this.config.setNameSpace(this.config.getNameSpace().toLowerCase());
        }
        this.elasticSearchClient = new ElasticSearchClient(this.config.getClusterNodes(), this.config.getNameSpace(), this.config.getUser(), this.config.getPassword());
        this.registerServiceImplementation(IBatchDAO.class, (Service)new BatchProcessEsDAO(this.elasticSearchClient, this.config.getBulkActions(), this.config.getBulkSize(), this.config.getFlushInterval(), this.config.getConcurrentRequests()));
        this.registerServiceImplementation(StorageDAO.class, (Service)new StorageEsDAO(this.elasticSearchClient));
        this.registerServiceImplementation(IRegisterLockDAO.class, (Service)new RegisterLockDAOImpl(this.elasticSearchClient));
        this.registerServiceImplementation(IHistoryDeleteDAO.class, (Service)new HistoryDeleteEsDAO((ModuleDefineHolder)this.getManager(), this.elasticSearchClient, new ElasticsearchStorageTTL()));
        this.registerServiceImplementation(IServiceInventoryCacheDAO.class, (Service)new ServiceInventoryCacheEsDAO(this.elasticSearchClient));
        this.registerServiceImplementation(IServiceInstanceInventoryCacheDAO.class, (Service)new ServiceInstanceInventoryCacheDAO(this.elasticSearchClient));
        this.registerServiceImplementation(IEndpointInventoryCacheDAO.class, (Service)new EndpointInventoryCacheEsDAO(this.elasticSearchClient));
        this.registerServiceImplementation(INetworkAddressInventoryCacheDAO.class, (Service)new NetworkAddressInventoryCacheEsDAO(this.elasticSearchClient));
        this.registerServiceImplementation(ITopologyQueryDAO.class, (Service)new TopologyQueryEsDAO(this.elasticSearchClient));
        this.registerServiceImplementation(IMetricsQueryDAO.class, (Service)new MetricsQueryEsDAO(this.elasticSearchClient));
        this.registerServiceImplementation(ITraceQueryDAO.class, (Service)new TraceQueryEsDAO(this.elasticSearchClient, this.config.getSegmentQueryMaxSize()));
        this.registerServiceImplementation(IMetadataQueryDAO.class, (Service)new MetadataQueryEsDAO(this.elasticSearchClient, this.config.getMetadataQueryMaxSize()));
        this.registerServiceImplementation(IAggregationQueryDAO.class, (Service)new AggregationQueryEsDAO(this.elasticSearchClient));
        this.registerServiceImplementation(IAlarmQueryDAO.class, (Service)new AlarmQueryEsDAO(this.elasticSearchClient));
        this.registerServiceImplementation(ITopNRecordsQueryDAO.class, (Service)new TopNRecordsQueryEsDAO(this.elasticSearchClient));
        this.registerServiceImplementation(ILogQueryDAO.class, (Service)new LogQueryEsDAO(this.elasticSearchClient));
    }

    public void start() throws ModuleStartException {
        this.overrideCoreModuleTTLConfig();
        try {
            this.elasticSearchClient.connect();
            StorageEsInstaller installer = new StorageEsInstaller(this.getManager(), this.config.getIndexShardsNumber(), this.config.getIndexReplicasNumber());
            installer.install((Client)this.elasticSearchClient);
            RegisterLockInstaller lockInstaller = new RegisterLockInstaller(this.elasticSearchClient);
            lockInstaller.install();
        }
        catch (IOException | StorageException e) {
            throw new ModuleStartException(e.getMessage(), e);
        }
    }

    public void notifyAfterCompleted() {
    }

    public String[] requiredModules() {
        return new String[]{"core"};
    }

    private void overrideCoreModuleTTLConfig() {
        ConfigService configService = (ConfigService)this.getManager().find("core").provider().getService(ConfigService.class);
        configService.getDataTTLConfig().setRecordDataTTL(this.config.getRecordDataTTL());
        configService.getDataTTLConfig().setMinuteMetricsDataTTL(this.config.getMinuteMetricsDataTTL());
        configService.getDataTTLConfig().setHourMetricsDataTTL(this.config.getHourMetricsDataTTL());
        configService.getDataTTLConfig().setDayMetricsDataTTL(this.config.getDayMetricsDataTTL());
        configService.getDataTTLConfig().setMonthMetricsDataTTL(this.config.getMonthMetricsDataTTL());
    }
}

