/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.skywalking.oap.server.core.query.sql.Where;
import org.apache.skywalking.oap.server.core.storage.AbstractDAO;
import org.apache.skywalking.oap.server.core.storage.type.StorageDataType;
import org.apache.skywalking.oap.server.library.client.Client;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public abstract class EsDAO
extends AbstractDAO<ElasticSearchClient> {
    public EsDAO(ElasticSearchClient client) {
        super((Client)client);
    }

    protected final void queryBuild(SearchSourceBuilder sourceBuilder, Where where, long startTB, long endTB) {
        RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)"time_bucket").gte((Object)startTB).lte((Object)endTB);
        if (where.getKeyValues().isEmpty()) {
            sourceBuilder.query((QueryBuilder)rangeQueryBuilder);
        } else {
            BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
            boolQuery.must().add(rangeQueryBuilder);
            where.getKeyValues().forEach(keyValues -> {
                if (keyValues.getValues().size() > 1) {
                    boolQuery.must().add(QueryBuilders.termsQuery((String)keyValues.getKey(), (Collection)keyValues.getValues()));
                } else {
                    boolQuery.must().add(QueryBuilders.termQuery((String)keyValues.getKey(), (String)((String)keyValues.getValues().get(0))));
                }
            });
            sourceBuilder.query((QueryBuilder)boolQuery);
        }
        sourceBuilder.size(0);
    }

    XContentBuilder map2builder(Map<String, Object> objectMap) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
        for (String key : objectMap.keySet()) {
            Object value = objectMap.get(key);
            if (value instanceof StorageDataType) {
                builder.field(key, ((StorageDataType)value).toStorageData());
                continue;
            }
            builder.field(key, value);
        }
        builder.endObject();
        return builder;
    }
}

