/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base;

import java.io.IOException;
import org.apache.skywalking.oap.server.core.register.RegisterSource;
import org.apache.skywalking.oap.server.core.storage.IRegisterDAO;
import org.apache.skywalking.oap.server.core.storage.StorageBuilder;
import org.apache.skywalking.oap.server.core.storage.StorageData;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class RegisterEsDAO
extends EsDAO
implements IRegisterDAO {
    private final StorageBuilder<RegisterSource> storageBuilder;

    RegisterEsDAO(ElasticSearchClient client, StorageBuilder<RegisterSource> storageBuilder) {
        super(client);
        this.storageBuilder = storageBuilder;
    }

    public RegisterSource get(String modelName, String id) throws IOException {
        GetResponse response = ((ElasticSearchClient)this.getClient()).get(modelName, id);
        if (response.isExists()) {
            return (RegisterSource)this.storageBuilder.map2Data(response.getSource());
        }
        return null;
    }

    public void forceInsert(String modelName, RegisterSource source) throws IOException {
        XContentBuilder builder = this.map2builder(this.storageBuilder.data2Map((StorageData)source));
        ((ElasticSearchClient)this.getClient()).forceInsert(modelName, source.id(), builder);
    }

    public void forceUpdate(String modelName, RegisterSource source) throws IOException {
        XContentBuilder builder = this.map2builder(this.storageBuilder.data2Map((StorageData)source));
        ((ElasticSearchClient)this.getClient()).forceUpdate(modelName, source.id(), builder);
    }
}

