/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base;

import org.apache.skywalking.oap.server.core.analysis.Downsampling;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.storage.model.Model;

public class TimeSeriesUtils {
    static String timeSeries(Model model) {
        long timeBucket = TimeBucket.getTimeBucket((long)System.currentTimeMillis(), (Downsampling)model.getDownsampling());
        return TimeSeriesUtils.timeSeries(model, timeBucket);
    }

    public static String timeSeries(String modelName, long timeBucket, Downsampling downsampling) {
        switch (downsampling) {
            case None: {
                return modelName;
            }
            case Hour: {
                return modelName + "-" + timeBucket / 100L;
            }
            case Minute: {
                return modelName + "-" + timeBucket / 10000L;
            }
            case Second: {
                return modelName + "-" + timeBucket / 1000000L;
            }
        }
        return modelName + "-" + timeBucket;
    }

    static String timeSeries(Model model, long timeBucket) {
        if (!model.isCapableOfTimeSeries()) {
            return model.getName();
        }
        return TimeSeriesUtils.timeSeries(model.getName(), timeBucket, model.getDownsampling());
    }

    static long indexTimeSeries(String indexName) {
        return Long.valueOf(indexName.substring(indexName.lastIndexOf("-") + 1));
    }
}

