/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.skywalking.oap.server.core.analysis.Downsampling;
import org.apache.skywalking.oap.server.core.query.entity.Order;
import org.apache.skywalking.oap.server.core.query.entity.TopNEntity;
import org.apache.skywalking.oap.server.core.storage.model.ModelName;
import org.apache.skywalking.oap.server.core.storage.query.IAggregationQueryDAO;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.avg.Avg;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public class AggregationQueryEsDAO
extends EsDAO
implements IAggregationQueryDAO {
    public AggregationQueryEsDAO(ElasticSearchClient client) {
        super(client);
    }

    public List<TopNEntity> getServiceTopN(String indName, String valueCName, int topN, Downsampling downsampling, long startTB, long endTB, Order order) throws IOException {
        String indexName = ModelName.build((Downsampling)downsampling, (String)indName);
        SearchSourceBuilder sourceBuilder = SearchSourceBuilder.searchSource();
        sourceBuilder.query((QueryBuilder)QueryBuilders.rangeQuery((String)"time_bucket").lte((Object)endTB).gte((Object)startTB));
        return this.aggregation(indexName, valueCName, sourceBuilder, topN, order);
    }

    public List<TopNEntity> getAllServiceInstanceTopN(String indName, String valueCName, int topN, Downsampling downsampling, long startTB, long endTB, Order order) throws IOException {
        String indexName = ModelName.build((Downsampling)downsampling, (String)indName);
        SearchSourceBuilder sourceBuilder = SearchSourceBuilder.searchSource();
        sourceBuilder.query((QueryBuilder)QueryBuilders.rangeQuery((String)"time_bucket").lte((Object)endTB).gte((Object)startTB));
        return this.aggregation(indexName, valueCName, sourceBuilder, topN, order);
    }

    public List<TopNEntity> getServiceInstanceTopN(int serviceId, String indName, String valueCName, int topN, Downsampling downsampling, long startTB, long endTB, Order order) throws IOException {
        String indexName = ModelName.build((Downsampling)downsampling, (String)indName);
        SearchSourceBuilder sourceBuilder = SearchSourceBuilder.searchSource();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        sourceBuilder.query((QueryBuilder)boolQueryBuilder);
        boolQueryBuilder.must().add(QueryBuilders.rangeQuery((String)"time_bucket").lte((Object)endTB).gte((Object)startTB));
        boolQueryBuilder.must().add(QueryBuilders.termQuery((String)"service_id", (int)serviceId));
        return this.aggregation(indexName, valueCName, sourceBuilder, topN, order);
    }

    public List<TopNEntity> getAllEndpointTopN(String indName, String valueCName, int topN, Downsampling downsampling, long startTB, long endTB, Order order) throws IOException {
        String indexName = ModelName.build((Downsampling)downsampling, (String)indName);
        SearchSourceBuilder sourceBuilder = SearchSourceBuilder.searchSource();
        sourceBuilder.query((QueryBuilder)QueryBuilders.rangeQuery((String)"time_bucket").lte((Object)endTB).gte((Object)startTB));
        return this.aggregation(indexName, valueCName, sourceBuilder, topN, order);
    }

    public List<TopNEntity> getEndpointTopN(int serviceId, String indName, String valueCName, int topN, Downsampling downsampling, long startTB, long endTB, Order order) throws IOException {
        String indexName = ModelName.build((Downsampling)downsampling, (String)indName);
        SearchSourceBuilder sourceBuilder = SearchSourceBuilder.searchSource();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        sourceBuilder.query((QueryBuilder)boolQueryBuilder);
        boolQueryBuilder.must().add(QueryBuilders.rangeQuery((String)"time_bucket").lte((Object)endTB).gte((Object)startTB));
        boolQueryBuilder.must().add(QueryBuilders.termQuery((String)"service_id", (int)serviceId));
        return this.aggregation(indexName, valueCName, sourceBuilder, topN, order);
    }

    private List<TopNEntity> aggregation(String indexName, String valueCName, SearchSourceBuilder sourceBuilder, int topN, Order order) throws IOException {
        boolean asc = false;
        if (order.equals((Object)Order.ASC)) {
            asc = true;
        }
        TermsAggregationBuilder aggregationBuilder = (TermsAggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"entity_id").field("entity_id")).order(BucketOrder.aggregation((String)valueCName, (boolean)asc)).size(topN).subAggregation((AggregationBuilder)AggregationBuilders.avg((String)valueCName).field(valueCName));
        sourceBuilder.aggregation((AggregationBuilder)aggregationBuilder);
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search(indexName, sourceBuilder);
        ArrayList<TopNEntity> topNEntities = new ArrayList<TopNEntity>();
        Terms idTerms = (Terms)response.getAggregations().get("entity_id");
        for (Terms.Bucket termsBucket : idTerms.getBuckets()) {
            TopNEntity topNEntity = new TopNEntity();
            topNEntity.setId(termsBucket.getKeyAsString());
            Avg value = (Avg)termsBucket.getAggregations().get(valueCName);
            topNEntity.setValue((long)value.getValue());
            topNEntities.add(topNEntity);
        }
        return topNEntities;
    }
}

