/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.Objects;
import org.apache.skywalking.oap.server.core.alarm.AlarmRecord;
import org.apache.skywalking.oap.server.core.query.entity.AlarmMessage;
import org.apache.skywalking.oap.server.core.query.entity.Alarms;
import org.apache.skywalking.oap.server.core.query.entity.Scope;
import org.apache.skywalking.oap.server.core.storage.query.IAlarmQueryDAO;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.MatchCNameBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public class AlarmQueryEsDAO
extends EsDAO
implements IAlarmQueryDAO {
    public AlarmQueryEsDAO(ElasticSearchClient client) {
        super(client);
    }

    public Alarms getAlarm(Integer scopeId, String keyword, int limit, int from, long startTB, long endTB) throws IOException {
        SearchSourceBuilder sourceBuilder = SearchSourceBuilder.searchSource();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must().add(QueryBuilders.rangeQuery((String)"time_bucket").gte((Object)startTB).lte((Object)endTB));
        if (Objects.nonNull(scopeId)) {
            boolQueryBuilder.must().add(QueryBuilders.termQuery((String)"scope", (int)scopeId));
        }
        if (!Strings.isNullOrEmpty((String)keyword)) {
            String matchCName = MatchCNameBuilder.INSTANCE.build("alarm_message");
            boolQueryBuilder.must().add(QueryBuilders.matchPhraseQuery((String)matchCName, (Object)keyword));
        }
        sourceBuilder.query((QueryBuilder)boolQueryBuilder);
        sourceBuilder.size(limit);
        sourceBuilder.from(from);
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search("alarm_record", sourceBuilder);
        Alarms alarms = new Alarms();
        alarms.setTotal((int)response.getHits().totalHits);
        for (SearchHit searchHit : response.getHits().getHits()) {
            AlarmRecord.Builder builder = new AlarmRecord.Builder();
            AlarmRecord alarmRecord = builder.map2Data(searchHit.getSourceAsMap());
            AlarmMessage message = new AlarmMessage();
            message.setId(String.valueOf(alarmRecord.getId0()));
            message.setMessage(alarmRecord.getAlarmMessage());
            message.setStartTime(Long.valueOf(alarmRecord.getStartTime()));
            message.setScope(Scope.Finder.valueOf((int)alarmRecord.getScope()));
            message.setScopeId(alarmRecord.getScope());
            alarms.getMsgs().add(message);
        }
        return alarms;
    }
}

