/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.skywalking.oap.server.core.query.entity.Attribute;
import org.apache.skywalking.oap.server.core.query.entity.Database;
import org.apache.skywalking.oap.server.core.query.entity.Endpoint;
import org.apache.skywalking.oap.server.core.query.entity.Language;
import org.apache.skywalking.oap.server.core.query.entity.LanguageTrans;
import org.apache.skywalking.oap.server.core.query.entity.Service;
import org.apache.skywalking.oap.server.core.query.entity.ServiceInstance;
import org.apache.skywalking.oap.server.core.register.NodeType;
import org.apache.skywalking.oap.server.core.register.ServiceInstanceInventory;
import org.apache.skywalking.oap.server.core.register.ServiceInventory;
import org.apache.skywalking.oap.server.core.source.DetectPoint;
import org.apache.skywalking.oap.server.core.storage.query.IMetadataQueryDAO;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.MatchCNameBuilder;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public class MetadataQueryEsDAO
extends EsDAO
implements IMetadataQueryDAO {
    private static final Gson GSON = new Gson();
    private final int queryMaxSize;

    public MetadataQueryEsDAO(ElasticSearchClient client, int queryMaxSize) {
        super(client);
        this.queryMaxSize = queryMaxSize;
    }

    public int numOfService(long startTimestamp, long endTimestamp) throws IOException {
        SearchSourceBuilder sourceBuilder = SearchSourceBuilder.searchSource();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must().add(this.timeRangeQueryBuild(startTimestamp, endTimestamp));
        boolQueryBuilder.must().add(QueryBuilders.termQuery((String)"is_address", (int)0));
        sourceBuilder.query((QueryBuilder)boolQueryBuilder);
        sourceBuilder.size(0);
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search("service_inventory", sourceBuilder);
        return (int)response.getHits().getTotalHits();
    }

    public int numOfEndpoint(long startTimestamp, long endTimestamp) throws IOException {
        SearchSourceBuilder sourceBuilder = SearchSourceBuilder.searchSource();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must().add(QueryBuilders.termQuery((String)"detect_point", (int)DetectPoint.SERVER.ordinal()));
        sourceBuilder.query((QueryBuilder)boolQueryBuilder);
        sourceBuilder.size(0);
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search("endpoint_inventory", sourceBuilder);
        return (int)response.getHits().getTotalHits();
    }

    public int numOfConjectural(long startTimestamp, long endTimestamp, int nodeTypeValue) throws IOException {
        SearchSourceBuilder sourceBuilder = SearchSourceBuilder.searchSource();
        sourceBuilder.query((QueryBuilder)QueryBuilders.termQuery((String)"node_type", (int)nodeTypeValue));
        sourceBuilder.size(0);
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search("service_inventory", sourceBuilder);
        return (int)response.getHits().getTotalHits();
    }

    public List<Service> getAllServices(long startTimestamp, long endTimestamp) throws IOException {
        SearchSourceBuilder sourceBuilder = SearchSourceBuilder.searchSource();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must().add(this.timeRangeQueryBuild(startTimestamp, endTimestamp));
        boolQueryBuilder.must().add(QueryBuilders.termQuery((String)"is_address", (int)0));
        sourceBuilder.query((QueryBuilder)boolQueryBuilder);
        sourceBuilder.size(this.queryMaxSize);
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search("service_inventory", sourceBuilder);
        return this.buildServices(response);
    }

    public List<Database> getAllDatabases() throws IOException {
        SearchSourceBuilder sourceBuilder = SearchSourceBuilder.searchSource();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must().add(QueryBuilders.termQuery((String)"node_type", (int)NodeType.Database.value()));
        sourceBuilder.query((QueryBuilder)boolQueryBuilder);
        sourceBuilder.size(this.queryMaxSize);
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search("service_inventory", sourceBuilder);
        ArrayList<Database> databases = new ArrayList<Database>();
        for (SearchHit searchHit : response.getHits()) {
            Map sourceAsMap = searchHit.getSourceAsMap();
            Database database = new Database();
            database.setId(((Number)sourceAsMap.get("sequence")).intValue());
            database.setName((String)sourceAsMap.get("name"));
            String propertiesString = (String)sourceAsMap.get("properties");
            if (!Strings.isNullOrEmpty((String)propertiesString)) {
                JsonObject properties = (JsonObject)GSON.fromJson(propertiesString, JsonObject.class);
                if (properties.has("database")) {
                    database.setType(properties.get("database").getAsString());
                } else {
                    database.setType("UNKNOWN");
                }
            }
            databases.add(database);
        }
        return databases;
    }

    public List<Service> searchServices(long startTimestamp, long endTimestamp, String keyword) throws IOException {
        SearchSourceBuilder sourceBuilder = SearchSourceBuilder.searchSource();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must().add(this.timeRangeQueryBuild(startTimestamp, endTimestamp));
        boolQueryBuilder.must().add(QueryBuilders.termQuery((String)"is_address", (int)0));
        if (!Strings.isNullOrEmpty((String)keyword)) {
            String matchCName = MatchCNameBuilder.INSTANCE.build("name");
            boolQueryBuilder.must().add(QueryBuilders.matchQuery((String)matchCName, (Object)keyword));
        }
        sourceBuilder.query((QueryBuilder)boolQueryBuilder);
        sourceBuilder.size(this.queryMaxSize);
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search("service_inventory", sourceBuilder);
        return this.buildServices(response);
    }

    public Service searchService(String serviceCode) throws IOException {
        GetResponse response = ((ElasticSearchClient)this.getClient()).get("service_inventory", ServiceInventory.buildId((String)serviceCode));
        if (response.isExists()) {
            Service service = new Service();
            service.setId(((Number)response.getSource().get("sequence")).intValue());
            service.setName((String)response.getSource().get("name"));
            return service;
        }
        return null;
    }

    public List<Endpoint> searchEndpoint(String keyword, String serviceId, int limit) throws IOException {
        SearchSourceBuilder sourceBuilder = SearchSourceBuilder.searchSource();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must().add(QueryBuilders.termQuery((String)"service_id", (String)serviceId));
        if (!Strings.isNullOrEmpty((String)keyword)) {
            String matchCName = MatchCNameBuilder.INSTANCE.build("name");
            boolQueryBuilder.must().add(QueryBuilders.matchQuery((String)matchCName, (Object)keyword));
        }
        boolQueryBuilder.must().add(QueryBuilders.termQuery((String)"detect_point", (int)DetectPoint.SERVER.ordinal()));
        sourceBuilder.query((QueryBuilder)boolQueryBuilder);
        sourceBuilder.size(limit);
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search("endpoint_inventory", sourceBuilder);
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        for (SearchHit searchHit : response.getHits()) {
            Map sourceAsMap = searchHit.getSourceAsMap();
            Endpoint endpoint = new Endpoint();
            endpoint.setId(((Number)sourceAsMap.get("sequence")).intValue());
            endpoint.setName((String)sourceAsMap.get("name"));
            endpoints.add(endpoint);
        }
        return endpoints;
    }

    public List<ServiceInstance> getServiceInstances(long startTimestamp, long endTimestamp, String serviceId) throws IOException {
        SearchSourceBuilder sourceBuilder = SearchSourceBuilder.searchSource();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must().add(this.timeRangeQueryBuild(startTimestamp, endTimestamp));
        boolQueryBuilder.must().add(QueryBuilders.termQuery((String)"service_id", (String)serviceId));
        sourceBuilder.query((QueryBuilder)boolQueryBuilder);
        sourceBuilder.size(this.queryMaxSize);
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search("service_instance_inventory", sourceBuilder);
        ArrayList<ServiceInstance> serviceInstances = new ArrayList<ServiceInstance>();
        for (SearchHit searchHit : response.getHits()) {
            Map sourceAsMap = searchHit.getSourceAsMap();
            ServiceInstance serviceInstance = new ServiceInstance();
            serviceInstance.setId(String.valueOf(sourceAsMap.get("sequence")));
            serviceInstance.setName((String)sourceAsMap.get("name"));
            String propertiesString = (String)sourceAsMap.get("properties");
            if (!Strings.isNullOrEmpty((String)propertiesString)) {
                JsonObject properties = (JsonObject)GSON.fromJson(propertiesString, JsonObject.class);
                if (properties.has("language")) {
                    serviceInstance.setLanguage(LanguageTrans.INSTANCE.value(properties.get("language").getAsString()));
                } else {
                    serviceInstance.setLanguage(Language.UNKNOWN);
                }
                if (properties.has("os_name")) {
                    serviceInstance.getAttributes().add(new Attribute("os_name", properties.get("os_name").getAsString()));
                }
                if (properties.has("host_name")) {
                    serviceInstance.getAttributes().add(new Attribute("host_name", properties.get("host_name").getAsString()));
                }
                if (properties.has("process_no")) {
                    serviceInstance.getAttributes().add(new Attribute("process_no", properties.get("process_no").getAsString()));
                }
                if (properties.has("ipv4s")) {
                    List ipv4s = ServiceInstanceInventory.PropertyUtil.ipv4sDeserialize((String)properties.get("ipv4s").getAsString());
                    for (String ipv4 : ipv4s) {
                        serviceInstance.getAttributes().add(new Attribute("ipv4s", ipv4));
                    }
                }
            } else {
                serviceInstance.setLanguage(Language.UNKNOWN);
            }
            serviceInstances.add(serviceInstance);
        }
        return serviceInstances;
    }

    private List<Service> buildServices(SearchResponse response) {
        ArrayList<Service> services = new ArrayList<Service>();
        for (SearchHit searchHit : response.getHits()) {
            Map sourceAsMap = searchHit.getSourceAsMap();
            Service service = new Service();
            service.setId(((Number)sourceAsMap.get("sequence")).intValue());
            service.setName((String)sourceAsMap.get("name"));
            services.add(service);
        }
        return services;
    }

    private BoolQueryBuilder timeRangeQueryBuild(long startTimestamp, long endTimestamp) {
        BoolQueryBuilder boolQuery1 = QueryBuilders.boolQuery();
        boolQuery1.must().add(QueryBuilders.rangeQuery((String)"heartbeat_time").gte((Object)endTimestamp));
        boolQuery1.must().add(QueryBuilders.rangeQuery((String)"register_time").lte((Object)endTimestamp));
        BoolQueryBuilder boolQuery2 = QueryBuilders.boolQuery();
        boolQuery2.must().add(QueryBuilders.rangeQuery((String)"register_time").lte((Object)endTimestamp));
        boolQuery2.must().add(QueryBuilders.rangeQuery((String)"heartbeat_time").gte((Object)startTimestamp));
        BoolQueryBuilder timeBoolQuery = QueryBuilders.boolQuery();
        timeBoolQuery.should().add(boolQuery1);
        timeBoolQuery.should().add(boolQuery2);
        return timeBoolQuery;
    }
}

