/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import org.apache.skywalking.oap.server.core.analysis.manual.segment.SegmentRecord;
import org.apache.skywalking.oap.server.core.query.entity.BasicTrace;
import org.apache.skywalking.oap.server.core.query.entity.QueryOrder;
import org.apache.skywalking.oap.server.core.query.entity.Span;
import org.apache.skywalking.oap.server.core.query.entity.TraceBrief;
import org.apache.skywalking.oap.server.core.query.entity.TraceState;
import org.apache.skywalking.oap.server.core.storage.query.ITraceQueryDAO;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.library.util.BooleanUtils;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.MatchCNameBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;

public class TraceQueryEsDAO
extends EsDAO
implements ITraceQueryDAO {
    private int segmentQueryMaxSize;

    public TraceQueryEsDAO(ElasticSearchClient client, int segmentQueryMaxSize) {
        super(client);
        this.segmentQueryMaxSize = segmentQueryMaxSize;
    }

    public TraceBrief queryBasicTraces(long startSecondTB, long endSecondTB, long minDuration, long maxDuration, String endpointName, int serviceId, int serviceInstanceId, int endpointId, String traceId, int limit, int from, TraceState traceState, QueryOrder queryOrder) throws IOException {
        SearchSourceBuilder sourceBuilder = SearchSourceBuilder.searchSource();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        sourceBuilder.query((QueryBuilder)boolQueryBuilder);
        List mustQueryList = boolQueryBuilder.must();
        if (startSecondTB != 0L && endSecondTB != 0L) {
            mustQueryList.add(QueryBuilders.rangeQuery((String)"time_bucket").gte((Object)startSecondTB).lte((Object)endSecondTB));
        }
        if (minDuration != 0L || maxDuration != 0L) {
            RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)"latency");
            if (minDuration != 0L) {
                rangeQueryBuilder.gte((Object)minDuration);
            }
            if (maxDuration != 0L) {
                rangeQueryBuilder.lte((Object)maxDuration);
            }
            boolQueryBuilder.must().add(rangeQueryBuilder);
        }
        if (!Strings.isNullOrEmpty((String)endpointName)) {
            String matchCName = MatchCNameBuilder.INSTANCE.build("endpoint_name");
            mustQueryList.add(QueryBuilders.matchPhraseQuery((String)matchCName, (Object)endpointName));
        }
        if (serviceId != 0) {
            boolQueryBuilder.must().add(QueryBuilders.termQuery((String)"service_id", (int)serviceId));
        }
        if (serviceInstanceId != 0) {
            boolQueryBuilder.must().add(QueryBuilders.termQuery((String)"service_instance_id", (int)serviceInstanceId));
        }
        if (endpointId != 0) {
            boolQueryBuilder.must().add(QueryBuilders.termQuery((String)"endpoint_id", (int)endpointId));
        }
        if (!Strings.isNullOrEmpty((String)traceId)) {
            boolQueryBuilder.must().add(QueryBuilders.termQuery((String)"trace_id", (String)traceId));
        }
        switch (traceState) {
            case ERROR: {
                mustQueryList.add(QueryBuilders.matchQuery((String)"is_error", (Object)1));
                break;
            }
            case SUCCESS: {
                mustQueryList.add(QueryBuilders.matchQuery((String)"is_error", (Object)0));
            }
        }
        switch (queryOrder) {
            case BY_START_TIME: {
                sourceBuilder.sort("start_time", SortOrder.DESC);
                break;
            }
            case BY_DURATION: {
                sourceBuilder.sort("latency", SortOrder.DESC);
            }
        }
        sourceBuilder.size(limit);
        sourceBuilder.from(from);
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search("segment", sourceBuilder);
        TraceBrief traceBrief = new TraceBrief();
        traceBrief.setTotal((int)response.getHits().totalHits);
        for (SearchHit searchHit : response.getHits().getHits()) {
            BasicTrace basicTrace = new BasicTrace();
            basicTrace.setSegmentId((String)searchHit.getSourceAsMap().get("segment_id"));
            basicTrace.setStart(String.valueOf(searchHit.getSourceAsMap().get("start_time")));
            basicTrace.getEndpointNames().add((String)searchHit.getSourceAsMap().get("endpoint_name"));
            basicTrace.setDuration(((Number)searchHit.getSourceAsMap().get("latency")).intValue());
            basicTrace.setError(BooleanUtils.valueToBoolean((int)((Number)searchHit.getSourceAsMap().get("is_error")).intValue()));
            basicTrace.getTraceIds().add((String)searchHit.getSourceAsMap().get("trace_id"));
            traceBrief.getTraces().add(basicTrace);
        }
        return traceBrief;
    }

    public List<SegmentRecord> queryByTraceId(String traceId) throws IOException {
        SearchSourceBuilder sourceBuilder = SearchSourceBuilder.searchSource();
        sourceBuilder.query((QueryBuilder)QueryBuilders.termQuery((String)"trace_id", (String)traceId));
        sourceBuilder.size(this.segmentQueryMaxSize);
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search("segment", sourceBuilder);
        ArrayList<SegmentRecord> segmentRecords = new ArrayList<SegmentRecord>();
        for (SearchHit searchHit : response.getHits().getHits()) {
            SegmentRecord segmentRecord = new SegmentRecord();
            segmentRecord.setSegmentId((String)searchHit.getSourceAsMap().get("segment_id"));
            segmentRecord.setTraceId((String)searchHit.getSourceAsMap().get("trace_id"));
            segmentRecord.setServiceId(((Number)searchHit.getSourceAsMap().get("service_id")).intValue());
            segmentRecord.setEndpointName((String)searchHit.getSourceAsMap().get("endpoint_name"));
            segmentRecord.setStartTime(((Number)searchHit.getSourceAsMap().get("start_time")).longValue());
            segmentRecord.setEndTime(((Number)searchHit.getSourceAsMap().get("end_time")).longValue());
            segmentRecord.setLatency(((Number)searchHit.getSourceAsMap().get("latency")).intValue());
            segmentRecord.setIsError(((Number)searchHit.getSourceAsMap().get("is_error")).intValue());
            String dataBinaryBase64 = (String)searchHit.getSourceAsMap().get("data_binary");
            if (!Strings.isNullOrEmpty((String)dataBinaryBase64)) {
                segmentRecord.setDataBinary(Base64.getDecoder().decode(dataBinaryBase64));
            }
            segmentRecord.setVersion(((Number)searchHit.getSourceAsMap().get("version")).intValue());
            segmentRecords.add(segmentRecord);
        }
        return segmentRecords;
    }

    public List<Span> doFlexibleTraceQuery(String traceId) throws IOException {
        return Collections.emptyList();
    }
}

