/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.AreaTreeModel;
import org.apache.fop.area.LineArea;
import org.apache.fop.area.OffDocumentItem;
import org.apache.fop.area.PageViewport;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.render.Renderer;
import org.xml.sax.SAXException;

public class RenderPagesModel
extends AreaTreeModel {
    protected Renderer renderer;
    protected List prepared = new ArrayList();
    private List pendingODI = new ArrayList();
    private List endDocODI = new ArrayList();

    public RenderPagesModel(FOUserAgent userAgent, String outputFormat, FontInfo fontInfo, OutputStream stream) throws FOPException {
        this.renderer = userAgent.getRendererFactory().createRenderer(userAgent, outputFormat);
        try {
            this.renderer.setupFontInfo(fontInfo);
            if (!fontInfo.isSetupValid()) {
                throw new FOPException("No default font defined by OutputConverter");
            }
            this.renderer.startRenderer(stream);
        }
        catch (IOException e) {
            throw new FOPException(e);
        }
    }

    public void startPageSequence(LineArea title) {
        super.startPageSequence(title);
        if (this.renderer.supportsOutOfOrder()) {
            this.renderer.startPageSequence(title);
        }
    }

    public void addPage(PageViewport page) {
        boolean ready;
        super.addPage(page);
        boolean bl = ready = this.renderer.supportsOutOfOrder() && page.isResolved();
        if (ready) {
            if (!this.renderer.supportsOutOfOrder() && page.getPageSequence().isFirstPage(page)) {
                this.renderer.startPageSequence(this.currentPageSequence.getTitle());
            }
            try {
                this.renderer.renderPage(page);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                String err = "Error while rendering page " + page.getPageNumberString();
                log.error((Object)err, (Throwable)e);
                throw new IllegalStateException("Fatal error occurred. Cannot continue. " + e.getClass().getName() + ": " + err);
            }
            page.clear();
        } else {
            this.preparePage(page);
        }
        boolean cont = this.checkPreparedPages(page, false);
        if (cont) {
            this.processOffDocumentItems(this.pendingODI);
            this.pendingODI.clear();
        }
    }

    protected boolean checkPreparedPages(PageViewport newPageViewport, boolean renderUnresolved) {
        Iterator iter = this.prepared.iterator();
        while (iter.hasNext()) {
            PageViewport pageViewport = (PageViewport)iter.next();
            if (pageViewport.isResolved() || renderUnresolved) {
                block7: {
                    if (!this.renderer.supportsOutOfOrder() && pageViewport.getPageSequence().isFirstPage(pageViewport)) {
                        this.renderer.startPageSequence(this.currentPageSequence.getTitle());
                    }
                    try {
                        this.renderer.renderPage(pageViewport);
                        if (!pageViewport.isResolved()) {
                            String[] idrefs = pageViewport.getIDRefs();
                            for (int count = 0; count < idrefs.length; ++count) {
                                log.warn((Object)("Page " + pageViewport.getPageNumberString() + ": Unresolved id reference \"" + idrefs[count] + "\" found."));
                            }
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)e);
                        if (!(e instanceof RuntimeException)) break block7;
                        throw (RuntimeException)e;
                    }
                }
                pageViewport.clear();
                iter.remove();
                continue;
            }
            if (this.renderer.supportsOutOfOrder()) continue;
            break;
        }
        return this.renderer.supportsOutOfOrder() || this.prepared.isEmpty();
    }

    protected void preparePage(PageViewport page) {
        if (this.renderer.supportsOutOfOrder()) {
            this.renderer.preparePage(page);
        }
        this.prepared.add(page);
    }

    public void handleOffDocumentItem(OffDocumentItem oDI) {
        switch (oDI.getWhenToProcess()) {
            case 0: {
                this.renderer.processOffDocumentItem(oDI);
                break;
            }
            case 1: {
                this.pendingODI.add(oDI);
                break;
            }
            case 2: {
                this.endDocODI.add(oDI);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    private void processOffDocumentItems(List list) {
        for (int count = 0; count < list.size(); ++count) {
            OffDocumentItem oDI = (OffDocumentItem)list.get(count);
            this.renderer.processOffDocumentItem(oDI);
        }
    }

    public void endDocument() throws SAXException {
        this.checkPreparedPages(null, true);
        this.processOffDocumentItems(this.pendingODI);
        this.pendingODI.clear();
        this.processOffDocumentItems(this.endDocODI);
        try {
            this.renderer.stopRenderer();
        }
        catch (IOException ex) {
            throw new SAXException(ex);
        }
    }
}

