/*
 * Decompiled with CFR 0.152.
 */
package org.csource.fastdfs;

import java.io.IOException;
import java.io.OutputStream;
import org.csource.fastdfs.DownloadCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadStream
implements DownloadCallback {
    private static final Logger logger = LoggerFactory.getLogger(DownloadStream.class);
    private OutputStream out;
    private long currentBytes = 0L;

    public DownloadStream(OutputStream out) {
        this.out = out;
    }

    @Override
    public int recv(long fileSize, byte[] data, int bytes) {
        try {
            this.out.write(data, 0, bytes);
        }
        catch (IOException ex) {
            logger.error("IOException when receive file content", (Throwable)ex);
            return -1;
        }
        this.currentBytes += (long)bytes;
        if (this.currentBytes == fileSize) {
            this.currentBytes = 0L;
        }
        return 0;
    }
}

