/*
 * Decompiled with CFR 0.152.
 */
package org.csource.fastdfs;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.csource.fastdfs.ClientGlobal;
import org.csource.fastdfs.TrackerServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackerGroup {
    private static final Logger logger = LoggerFactory.getLogger(TrackerGroup.class);
    protected Integer lock;
    public int tracker_server_index;
    public InetSocketAddress[] tracker_servers;

    public TrackerGroup(InetSocketAddress[] tracker_servers) {
        this.tracker_servers = tracker_servers;
        this.lock = new Integer(0);
        this.tracker_server_index = 0;
    }

    public TrackerServer getConnection(int serverIndex) throws IOException {
        Socket sock = new Socket();
        sock.setReuseAddress(true);
        sock.setSoTimeout(ClientGlobal.g_network_timeout);
        sock.connect(this.tracker_servers[serverIndex], ClientGlobal.g_connect_timeout);
        return new TrackerServer(sock, this.tracker_servers[serverIndex]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TrackerServer getConnection() throws IOException {
        int current_index;
        Integer n = this.lock;
        synchronized (n) {
            ++this.tracker_server_index;
            if (this.tracker_server_index >= this.tracker_servers.length) {
                this.tracker_server_index = 0;
            }
            current_index = this.tracker_server_index;
        }
        try {
            return this.getConnection(current_index);
        }
        catch (IOException ex) {
            logger.error("connect to server " + this.tracker_servers[current_index].getAddress().getHostAddress() + ":" + this.tracker_servers[current_index].getPort() + " fail");
            for (int i = 0; i < this.tracker_servers.length; ++i) {
                if (i == current_index) continue;
                try {
                    TrackerServer trackerServer = this.getConnection(i);
                    Integer n2 = this.lock;
                    synchronized (n2) {
                        if (this.tracker_server_index == current_index) {
                            this.tracker_server_index = i;
                        }
                    }
                    return trackerServer;
                }
                catch (IOException ex2) {
                    logger.error("connect to server " + this.tracker_servers[i].getAddress().getHostAddress() + ":" + this.tracker_servers[i].getPort() + " fail");
                }
            }
            return null;
        }
    }

    public Object clone() {
        InetSocketAddress[] trackerServers = new InetSocketAddress[this.tracker_servers.length];
        for (int i = 0; i < trackerServers.length; ++i) {
            trackerServers[i] = new InetSocketAddress(this.tracker_servers[i].getAddress().getHostAddress(), this.tracker_servers[i].getPort());
        }
        return new TrackerGroup(trackerServers);
    }
}

