/*
 * Decompiled with CFR 0.152.
 */
package org.csource.fastdfs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.csource.fastdfs.ClientGlobal;
import org.csource.fastdfs.ProtoCommon;

public class TrackerServer {
    protected Socket sock;
    protected InetSocketAddress inetSockAddr;

    public TrackerServer(Socket sock, InetSocketAddress inetSockAddr) {
        this.sock = sock;
        this.inetSockAddr = inetSockAddr;
    }

    public Socket getSocket() throws IOException {
        if (this.sock == null) {
            this.sock = ClientGlobal.getSocket(this.inetSockAddr);
        }
        return this.sock;
    }

    public InetSocketAddress getInetSocketAddress() {
        return this.inetSockAddr;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.sock.getOutputStream();
    }

    public InputStream getInputStream() throws IOException {
        return this.sock.getInputStream();
    }

    public void close() throws IOException {
        if (this.sock != null) {
            try {
                ProtoCommon.closeSocket(this.sock);
            }
            finally {
                this.sock = null;
            }
        }
    }
}

