/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2.director;

import java.io.File;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.eclipse.tycho.BuildOutputDirectory;
import org.eclipse.tycho.core.TargetPlatformConfiguration;
import org.eclipse.tycho.core.facade.TargetEnvironment;
import org.eclipse.tycho.core.utils.TychoProjectUtils;
import org.eclipse.tycho.plugins.p2.director.Product;
import org.eclipse.tycho.plugins.p2.director.ProductConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractProductMojo
extends AbstractMojo {
    private MavenProject project;
    private MavenSession session;
    private List<Product> products;

    AbstractProductMojo() {
    }

    MavenProject getProject() {
        return this.project;
    }

    MavenSession getSession() {
        return this.session;
    }

    BuildOutputDirectory getBuildDirectory() {
        return new BuildOutputDirectory(this.getProject().getBuild().getDirectory());
    }

    File getProductsBuildDirectory() {
        return this.getBuildDirectory().getChild("products");
    }

    File getProductMaterializeDirectory(Product product, TargetEnvironment env) {
        return new File(this.getProductsBuildDirectory(), product.getId() + "/" + AbstractProductMojo.getOsWsArch(env, '/'));
    }

    List<TargetEnvironment> getEnvironments() {
        TargetPlatformConfiguration configuration = TychoProjectUtils.getTargetPlatformConfiguration((MavenProject)this.project);
        return configuration.getEnvironments();
    }

    ProductConfig getProductConfig() throws MojoFailureException {
        return new ProductConfig(this.products, TychoProjectUtils.getDependencySeeds((MavenProject)this.project));
    }

    static String getOsWsArch(TargetEnvironment env, char separator) {
        return env.getOs() + separator + env.getWs() + separator + env.getArch();
    }
}

