/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2.director;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.tar.TarArchiver;
import org.codehaus.plexus.archiver.tar.TarLongFileMode;
import org.eclipse.tycho.core.facade.TargetEnvironment;
import org.eclipse.tycho.plugins.p2.director.AbstractProductMojo;
import org.eclipse.tycho.plugins.p2.director.Product;
import org.eclipse.tycho.plugins.p2.director.ProductConfig;

public final class ProductArchiverMojo
extends AbstractProductMojo {
    static final String DEFAULT_ARCHIVE_FORMAT = "zip";
    private final Map<String, ProductArchiver> productArchivers = new HashMap<String, ProductArchiver>();
    private Map<String, String> formats;
    private Archiver zipArchiver;
    private TarArchiver tarArchiver;
    private MavenProjectHelper helper;

    public ProductArchiverMojo() {
        this.productArchivers.put(DEFAULT_ARCHIVE_FORMAT, new ProductArchiver(){

            Archiver getArchiver() {
                return ProductArchiverMojo.this.zipArchiver;
            }
        });
        this.productArchivers.put("tar.gz", new ProductArchiver(){

            Archiver getArchiver() throws ArchiverException {
                TarArchiver.TarCompressionMethod tarCompressionMethod = new TarArchiver.TarCompressionMethod();
                tarCompressionMethod.setValue("gzip");
                ProductArchiverMojo.this.tarArchiver.setCompression(tarCompressionMethod);
                TarLongFileMode gnuMode = new TarLongFileMode();
                gnuMode.setValue("gnu");
                ProductArchiverMojo.this.tarArchiver.setLongfile(gnuMode);
                return ProductArchiverMojo.this.tarArchiver;
            }
        });
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        ProductConfig config = this.getProductConfig();
        if (!config.uniqueAttachIds()) {
            throw new MojoFailureException("Artifact file names for the archived products are not unique. Configure the attachId or select a subset of products. Current configuration: " + config.getProducts());
        }
        for (Product product : config.getProducts()) {
            for (TargetEnvironment env : this.getEnvironments()) {
                ProductArchiver productArchiver;
                String format;
                String string = format = this.formats != null ? this.formats.get(env.getOs()) : DEFAULT_ARCHIVE_FORMAT;
                if (format != null) {
                    format = format.trim();
                }
                if (format == null || format.length() == 0) {
                    format = DEFAULT_ARCHIVE_FORMAT;
                }
                if ((productArchiver = this.productArchivers.get(format)) == null) {
                    throw new MojoExecutionException("Unknown or unsupported archive format os=" + env.getOs() + " format=" + format);
                }
                File productArchive = new File(this.getProductsBuildDirectory(), ProductArchiverMojo.getArchiveFileName(product) + "-" + ProductArchiverMojo.getOsWsArch(env, '.') + "." + format);
                try {
                    Archiver archiver = productArchiver.getArchiver();
                    archiver.setDestFile(productArchive);
                    archiver.addDirectory(this.getProductMaterializeDirectory(product, env));
                    archiver.createArchive();
                }
                catch (ArchiverException e) {
                    throw new MojoExecutionException("Error packing product", (Exception)((Object)e));
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error packing product", (Exception)e);
                }
                String artifactClassifier = ProductArchiverMojo.getArtifactClassifier(product, env, format);
                this.helper.attachArtifact(this.getProject(), format, artifactClassifier, productArchive);
            }
        }
    }

    static String getArchiveFileName(Product product) {
        if (product.getArchiveFileName() != null) {
            return product.getArchiveFileName();
        }
        return product.getId();
    }

    static String getArtifactClassifier(Product product, TargetEnvironment environment, String format) {
        String artifactClassifier = product.getAttachId() == null ? ProductArchiverMojo.getOsWsArch(environment, '.') : product.getAttachId() + "-" + ProductArchiverMojo.getOsWsArch(environment, '.');
        return artifactClassifier;
    }

    private abstract class ProductArchiver {
        private ProductArchiver() {
        }

        abstract Archiver getArchiver() throws ArchiverException;
    }
}

