/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.h2;

import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record4;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SortOrder;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.TableOptions;
import org.jooq.impl.DSL;
import org.jooq.meta.AbstractDatabase;
import org.jooq.meta.AbstractIndexDefinition;
import org.jooq.meta.ArrayDefinition;
import org.jooq.meta.CatalogDefinition;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.Database;
import org.jooq.meta.DefaultCheckConstraintDefinition;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.DefaultDomainDefinition;
import org.jooq.meta.DefaultEnumDefinition;
import org.jooq.meta.DefaultIndexColumnDefinition;
import org.jooq.meta.DefaultRelations;
import org.jooq.meta.DefaultSequenceDefinition;
import org.jooq.meta.DomainDefinition;
import org.jooq.meta.EnumDefinition;
import org.jooq.meta.IndexColumnDefinition;
import org.jooq.meta.IndexDefinition;
import org.jooq.meta.PackageDefinition;
import org.jooq.meta.RoutineDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.SequenceDefinition;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.UDTDefinition;
import org.jooq.meta.h2.H2RoutineDefinition;
import org.jooq.meta.h2.H2TableDefinition;
import org.jooq.meta.h2.information_schema.Tables;
import org.jooq.tools.StringUtils;
import org.jooq.tools.csv.CSVReader;
import org.jooq.util.h2.H2DataType;

public class H2Database
extends AbstractDatabase {
    private static final long DEFAULT_SEQUENCE_CACHE = 32L;
    private static final long DEFAULT_SEQUENCE_MAXVALUE = Long.MAX_VALUE;
    private static Boolean is1_4_197;
    private static Boolean is1_4_198;
    private static Boolean is1_4_201;

    @Override
    protected DSLContext create0() {
        return DSL.using((Connection)this.getConnection(), (SQLDialect)SQLDialect.H2);
    }

    @Override
    protected boolean exists0(TableField<?, ?> field) {
        return this.exists1(field, Tables.COLUMNS, Tables.COLUMNS.TABLE_SCHEMA, Tables.COLUMNS.TABLE_NAME, Tables.COLUMNS.COLUMN_NAME);
    }

    @Override
    protected boolean exists0(Table<?> table) {
        return this.exists1(table, Tables.TABLES, Tables.TABLES.TABLE_SCHEMA, Tables.TABLES.TABLE_NAME);
    }

    @Override
    protected List<IndexDefinition> getIndexes0() throws SQLException {
        ArrayList<IndexDefinition> result = new ArrayList<IndexDefinition>();
        Map indexes = this.create().select(Tables.INDEXES.TABLE_SCHEMA, Tables.INDEXES.TABLE_NAME, Tables.INDEXES.INDEX_NAME, Tables.INDEXES.NON_UNIQUE, Tables.INDEXES.COLUMN_NAME, Tables.INDEXES.ORDINAL_POSITION, Tables.INDEXES.ASC_OR_DESC).from((TableLike)Tables.INDEXES).where(Tables.INDEXES.TABLE_SCHEMA.in(this.getInputSchemata())).and(this.getIncludeSystemIndexes() ? DSL.noCondition() : DSL.not((Condition)DSL.condition(Tables.INDEXES.IS_GENERATED))).orderBy(Tables.INDEXES.TABLE_SCHEMA, Tables.INDEXES.TABLE_NAME, Tables.INDEXES.INDEX_NAME, Tables.INDEXES.ORDINAL_POSITION).fetchGroups(new Field[]{Tables.INDEXES.TABLE_SCHEMA, Tables.INDEXES.TABLE_NAME, Tables.INDEXES.INDEX_NAME, Tables.INDEXES.NON_UNIQUE}, new Field[]{Tables.INDEXES.COLUMN_NAME, Tables.INDEXES.ORDINAL_POSITION});
        block0: for (Map.Entry entry : indexes.entrySet()) {
            Record index = (Record)entry.getKey();
            final Result columns = (Result)entry.getValue();
            SchemaDefinition tableSchema = this.getSchema((String)index.get(Tables.INDEXES.TABLE_SCHEMA));
            if (tableSchema == null) continue;
            String indexName = (String)index.get(Tables.INDEXES.INDEX_NAME);
            String tableName = (String)index.get(Tables.INDEXES.TABLE_NAME);
            final TableDefinition table = this.getTable(tableSchema, tableName);
            if (table == null) continue;
            boolean unique = (Boolean)index.get(Tables.INDEXES.NON_UNIQUE, Boolean.TYPE) == false;
            for (Record column : columns) {
                if (table.getColumn((String)column.get(Tables.INDEXES.COLUMN_NAME)) != null) continue;
                continue block0;
            }
            result.add(new AbstractIndexDefinition(tableSchema, indexName, table, unique){
                List<IndexColumnDefinition> indexColumns;
                {
                    super(schema, name, table2, unique);
                    this.indexColumns = new ArrayList<IndexColumnDefinition>();
                    for (Record column : columns) {
                        this.indexColumns.add(new DefaultIndexColumnDefinition(this, table.getColumn((String)column.get(Tables.INDEXES.COLUMN_NAME)), SortOrder.ASC, (Integer)column.get(Tables.INDEXES.ORDINAL_POSITION, Integer.TYPE)));
                    }
                }

                @Override
                protected List<IndexColumnDefinition> getIndexColumns0() {
                    return this.indexColumns;
                }
            });
        }
        return result;
    }

    @Override
    protected void loadPrimaryKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.fetchKeys("PRIMARY KEY", "PRIMARY_KEY")) {
            SchemaDefinition schema = this.getSchema((String)record.get(Tables.CONSTRAINTS.TABLE_SCHEMA));
            if (schema == null) continue;
            String tableName = (String)record.get(Tables.CONSTRAINTS.TABLE_NAME);
            String primaryKey = (String)record.get(Tables.CONSTRAINTS.CONSTRAINT_NAME);
            String columnName = (String)record.get(Tables.INDEXES.COLUMN_NAME);
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            relations2.addPrimaryKey(primaryKey, table, table.getColumn(columnName));
        }
    }

    @Override
    protected void loadUniqueKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.fetchKeys("UNIQUE")) {
            SchemaDefinition schema = this.getSchema((String)record.get(Tables.CONSTRAINTS.TABLE_SCHEMA));
            if (schema == null) continue;
            String tableName = (String)record.get(Tables.CONSTRAINTS.TABLE_NAME);
            String primaryKey = (String)record.get(Tables.CONSTRAINTS.CONSTRAINT_NAME);
            String columnName = (String)record.get(Tables.INDEXES.COLUMN_NAME);
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            relations2.addUniqueKey(primaryKey, table, table.getColumn(columnName));
        }
    }

    private Result<Record4<String, String, String, String>> fetchKeys(String ... constraintTypes) {
        return this.create().select(Tables.CONSTRAINTS.TABLE_SCHEMA, Tables.CONSTRAINTS.TABLE_NAME, Tables.CONSTRAINTS.CONSTRAINT_NAME, Tables.INDEXES.COLUMN_NAME).from((TableLike)Tables.CONSTRAINTS).join((TableLike)Tables.INDEXES).on(Tables.CONSTRAINTS.TABLE_SCHEMA.eq(Tables.INDEXES.TABLE_SCHEMA)).and(Tables.CONSTRAINTS.TABLE_NAME.eq(Tables.INDEXES.TABLE_NAME)).and(Tables.CONSTRAINTS.UNIQUE_INDEX_NAME.eq(Tables.INDEXES.INDEX_NAME)).where(Tables.CONSTRAINTS.TABLE_SCHEMA.in(this.getInputSchemata())).and(Tables.CONSTRAINTS.CONSTRAINT_TYPE.in((Object[])constraintTypes)).orderBy(Tables.CONSTRAINTS.TABLE_SCHEMA, Tables.CONSTRAINTS.CONSTRAINT_NAME, Tables.INDEXES.ORDINAL_POSITION).fetch();
    }

    @Override
    protected void loadForeignKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.create().select(Tables.CROSS_REFERENCES.FK_NAME, Tables.CROSS_REFERENCES.FKTABLE_NAME, Tables.CROSS_REFERENCES.FKTABLE_SCHEMA, Tables.CROSS_REFERENCES.FKCOLUMN_NAME, Tables.CROSS_REFERENCES.PKCOLUMN_NAME, Tables.CROSS_REFERENCES.referencedConstraint().CONSTRAINT_NAME, Tables.CROSS_REFERENCES.referencedConstraint().TABLE_NAME, Tables.CROSS_REFERENCES.referencedConstraint().CONSTRAINT_SCHEMA).from((TableLike)Tables.CROSS_REFERENCES).where(Tables.CROSS_REFERENCES.FKTABLE_SCHEMA.in(this.getInputSchemata())).and(Tables.CROSS_REFERENCES.referencedConstraint().CONSTRAINT_TYPE.in((Object[])new String[]{"PRIMARY KEY", "PRIMARY_KEY", "UNIQUE"})).orderBy((OrderField)Tables.CROSS_REFERENCES.FKTABLE_SCHEMA.asc(), (OrderField)Tables.CROSS_REFERENCES.FK_NAME.asc(), (OrderField)Tables.CROSS_REFERENCES.ORDINAL_POSITION.asc()).fetch()) {
            SchemaDefinition foreignKeySchema = this.getSchema((String)record.get(Tables.CROSS_REFERENCES.FKTABLE_SCHEMA));
            SchemaDefinition uniqueKeySchema = this.getSchema((String)record.get(Tables.CROSS_REFERENCES.referencedConstraint().CONSTRAINT_SCHEMA));
            if (foreignKeySchema == null || uniqueKeySchema == null) continue;
            String foreignKey = (String)record.get(Tables.CROSS_REFERENCES.FK_NAME);
            String foreignKeyTableName = (String)record.get(Tables.CROSS_REFERENCES.FKTABLE_NAME);
            String foreignKeyColumn = (String)record.get(Tables.CROSS_REFERENCES.FKCOLUMN_NAME);
            String uniqueKey = (String)record.get(Tables.CROSS_REFERENCES.referencedConstraint().CONSTRAINT_NAME);
            String uniqueKeyTableName = (String)record.get(Tables.CROSS_REFERENCES.referencedConstraint().TABLE_NAME);
            String uniqueKeyColumn = (String)record.get(Tables.CROSS_REFERENCES.PKCOLUMN_NAME);
            TableDefinition foreignKeyTable = this.getTable(foreignKeySchema, foreignKeyTableName);
            TableDefinition uniqueKeyTable = this.getTable(uniqueKeySchema, uniqueKeyTableName);
            if (foreignKeyTable == null || uniqueKeyTable == null) continue;
            relations2.addForeignKey(foreignKey, foreignKeyTable, foreignKeyTable.getColumn(foreignKeyColumn), uniqueKey, uniqueKeyTable, uniqueKeyTable.getColumn(uniqueKeyColumn), true);
        }
    }

    @Override
    protected void loadCheckConstraints(DefaultRelations relations2) throws SQLException {
        SelectConditionStep inlineChecks = this.is1_4_201() ? DSL.select((SelectField)DSL.inline((String)""), (SelectField)DSL.inline((String)""), (SelectField)DSL.inline((String)""), (SelectField)DSL.inline((String)"")).where((Condition)DSL.falseCondition()) : DSL.select(Tables.COLUMNS.TABLE_SCHEMA, Tables.COLUMNS.TABLE_NAME, Tables.COLUMNS.CHECK_CONSTRAINT, Tables.COLUMNS.CHECK_CONSTRAINT).from((TableLike)Tables.COLUMNS).where(Tables.COLUMNS.CHECK_CONSTRAINT.nvl((Object)"").ne((Object)"")).and(Tables.COLUMNS.TABLE_SCHEMA.in(this.getInputSchemata()));
        for (Record record : this.create().select(Tables.CONSTRAINTS.TABLE_SCHEMA, Tables.CONSTRAINTS.TABLE_NAME, Tables.CONSTRAINTS.CONSTRAINT_NAME, Tables.CONSTRAINTS.CHECK_EXPRESSION).from((TableLike)Tables.CONSTRAINTS).where(Tables.CONSTRAINTS.CONSTRAINT_TYPE.eq((Object)"CHECK")).and(Tables.CONSTRAINTS.TABLE_SCHEMA.in(this.getInputSchemata())).union((Select)inlineChecks)) {
            TableDefinition table;
            SchemaDefinition schema = this.getSchema((String)record.get(Tables.CONSTRAINTS.TABLE_SCHEMA));
            if (schema == null || (table = this.getTable(schema, (String)record.get(Tables.CONSTRAINTS.TABLE_NAME))) == null) continue;
            relations2.addCheckConstraint(table, new DefaultCheckConstraintDefinition(schema, table, (String)record.get(Tables.CONSTRAINTS.CONSTRAINT_NAME), (String)record.get(Tables.CONSTRAINTS.CHECK_EXPRESSION)));
        }
    }

    @Override
    protected List<CatalogDefinition> getCatalogs0() throws SQLException {
        ArrayList<CatalogDefinition> result = new ArrayList<CatalogDefinition>();
        result.add(new CatalogDefinition((Database)this, "", ""));
        return result;
    }

    @Override
    protected List<SchemaDefinition> getSchemata0() throws SQLException {
        ArrayList<SchemaDefinition> result = new ArrayList<SchemaDefinition>();
        for (Record record : this.create().select(Tables.SCHEMATA.SCHEMA_NAME, Tables.SCHEMATA.REMARKS).from((TableLike)Tables.SCHEMATA).fetch()) {
            result.add(new SchemaDefinition((Database)this, (String)record.get(Tables.SCHEMATA.SCHEMA_NAME), (String)record.get(Tables.SCHEMATA.REMARKS)));
        }
        return result;
    }

    @Override
    protected List<SequenceDefinition> getSequences0() throws SQLException {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        for (Record record : this.create().select(Tables.SEQUENCES.SEQUENCE_SCHEMA, Tables.SEQUENCES.SEQUENCE_NAME, (SelectField)DSL.nullif(Tables.SEQUENCES.INCREMENT, (Object)DSL.one()).as(Tables.SEQUENCES.INCREMENT), (SelectField)DSL.nullif(Tables.SEQUENCES.MIN_VALUE, (Object)DSL.one()).as(Tables.SEQUENCES.MIN_VALUE), (SelectField)DSL.nullif(Tables.SEQUENCES.MAX_VALUE, (Field)DSL.inline((long)Long.MAX_VALUE)).as(Tables.SEQUENCES.MAX_VALUE), Tables.SEQUENCES.IS_CYCLE, (SelectField)DSL.nullif(Tables.SEQUENCES.CACHE, (Field)DSL.inline((long)32L)).as(Tables.SEQUENCES.CACHE)).from((TableLike)Tables.SEQUENCES).where(Tables.SEQUENCES.SEQUENCE_SCHEMA.in(this.getInputSchemata())).and(Tables.SEQUENCES.SEQUENCE_NAME.upper().notLike("SYSTEM!_SEQUENCE!_%", '!')).orderBy(Tables.SEQUENCES.SEQUENCE_SCHEMA, Tables.SEQUENCES.SEQUENCE_NAME).fetch()) {
            SchemaDefinition schema = this.getSchema((String)record.get(Tables.SEQUENCES.SEQUENCE_SCHEMA));
            if (schema == null) continue;
            String name = (String)record.get(Tables.SEQUENCES.SEQUENCE_NAME);
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this, schema, H2DataType.BIGINT.getTypeName());
            result.add(new DefaultSequenceDefinition(schema, name, type, null, null, (Number)record.get(Tables.SEQUENCES.INCREMENT), (Number)record.get(Tables.SEQUENCES.MIN_VALUE), (Number)record.get(Tables.SEQUENCES.MAX_VALUE), (Boolean)record.get(Tables.SEQUENCES.IS_CYCLE), (Number)record.get(Tables.SEQUENCES.CACHE)));
        }
        return result;
    }

    @Override
    protected List<TableDefinition> getTables0() throws SQLException {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        for (Record record : this.create().select(Tables.TABLES.TABLE_SCHEMA, Tables.TABLES.TABLE_NAME, (SelectField)DSL.when((Condition)Tables.TABLES.TABLE_TYPE.eq((Field)DSL.inline((String)"VIEW")), (Field)DSL.inline((String)TableOptions.TableType.VIEW.name())).when((Condition)Tables.TABLES.STORAGE_TYPE.like((Field)DSL.inline((String)"%TEMPORARY%")), (Field)DSL.inline((String)TableOptions.TableType.TEMPORARY.name())).else_((Field)DSL.inline((String)TableOptions.TableType.TABLE.name())).as("table_type"), Tables.TABLES.REMARKS, Tables.VIEWS.VIEW_DEFINITION).from((TableLike)Tables.TABLES).leftJoin((TableLike)Tables.VIEWS).on(Tables.TABLES.TABLE_SCHEMA.eq(Tables.VIEWS.TABLE_SCHEMA)).and(Tables.TABLES.TABLE_NAME.eq(Tables.VIEWS.TABLE_NAME)).where(Tables.TABLES.TABLE_SCHEMA.in(this.getInputSchemata())).orderBy(Tables.TABLES.TABLE_SCHEMA, Tables.TABLES.TABLE_NAME)) {
            SchemaDefinition schema = this.getSchema((String)record.get(Tables.TABLES.TABLE_SCHEMA));
            if (schema == null) continue;
            String name = (String)record.get(Tables.TABLES.TABLE_NAME);
            String comment = (String)record.get(Tables.TABLES.REMARKS);
            TableOptions.TableType tableType = (TableOptions.TableType)record.get("table_type", TableOptions.TableType.class);
            String source = (String)record.get(Tables.VIEWS.VIEW_DEFINITION);
            H2TableDefinition table = new H2TableDefinition(schema, name, comment, tableType, source);
            result.add(table);
        }
        return result;
    }

    @Override
    protected List<RoutineDefinition> getRoutines0() throws SQLException {
        ArrayList<RoutineDefinition> result = new ArrayList<RoutineDefinition>();
        Field overloaded = DSL.field((Select)DSL.select((SelectField)DSL.field((Condition)DSL.exists((Select)DSL.select((SelectField)DSL.one()).from((TableLike)Tables.FUNCTION_ALIASES.as("a")).where(DSL.field((Name)DSL.name((String[])new String[]{"a", Tables.FUNCTION_ALIASES.ALIAS_SCHEMA.getName()})).eq(Tables.FUNCTION_ALIASES.ALIAS_SCHEMA)).and(DSL.field((Name)DSL.name((String[])new String[]{"a", Tables.FUNCTION_ALIASES.ALIAS_NAME.getName()})).eq(Tables.FUNCTION_ALIASES.ALIAS_NAME)).and(DSL.field((Name)DSL.name((String[])new String[]{"a", Tables.FUNCTION_ALIASES.COLUMN_COUNT.getName()})).ne(Tables.FUNCTION_ALIASES.COLUMN_COUNT)))))).as("overloaded");
        for (Record record : this.create().select(Tables.FUNCTION_ALIASES.ALIAS_SCHEMA, Tables.FUNCTION_ALIASES.ALIAS_NAME, Tables.FUNCTION_ALIASES.REMARKS, Tables.FUNCTION_ALIASES.DATA_TYPE, Tables.FUNCTION_ALIASES.RETURNS_RESULT, Tables.FUNCTION_ALIASES.COLUMN_COUNT, (SelectField)overloaded, Tables.TYPE_INFO.TYPE_NAME, Tables.TYPE_INFO.PRECISION, Tables.TYPE_INFO.MAXIMUM_SCALE).from((TableLike)Tables.FUNCTION_ALIASES).leftOuterJoin((TableLike)Tables.TYPE_INFO).on(Tables.FUNCTION_ALIASES.DATA_TYPE.equal(Tables.TYPE_INFO.DATA_TYPE)).and(Tables.TYPE_INFO.POS.equal((Object)0)).where(Tables.FUNCTION_ALIASES.ALIAS_SCHEMA.in(this.getInputSchemata())).and(Tables.FUNCTION_ALIASES.RETURNS_RESULT.in((Object[])new Short[]{(short)1, (short)2})).orderBy(Tables.FUNCTION_ALIASES.ALIAS_NAME).fetch()) {
            SchemaDefinition schema = this.getSchema((String)record.get(Tables.FUNCTION_ALIASES.ALIAS_SCHEMA));
            if (schema == null) continue;
            String name = (String)record.get(Tables.FUNCTION_ALIASES.ALIAS_NAME);
            String comment = (String)record.get(Tables.FUNCTION_ALIASES.REMARKS);
            String typeName = (String)record.get(Tables.TYPE_INFO.TYPE_NAME);
            Integer precision = (Integer)record.get(Tables.TYPE_INFO.PRECISION);
            Short scale = (Short)record.get(Tables.TYPE_INFO.MAXIMUM_SCALE);
            String overload = (Boolean)record.get(overloaded) != false ? (String)record.get(Tables.FUNCTION_ALIASES.COLUMN_COUNT, String.class) : null;
            result.add(new H2RoutineDefinition(schema, name, comment, typeName, precision, scale, overload));
        }
        return result;
    }

    @Override
    protected List<PackageDefinition> getPackages0() throws SQLException {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        return result;
    }

    @Override
    protected List<EnumDefinition> getEnums0() throws SQLException {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        if (!this.is1_4_197()) {
            return result;
        }
        this.getInlineEnums(result);
        this.getDomainEnums(result);
        return result;
    }

    private void getInlineEnums(List<EnumDefinition> result) {
        for (Record record : this.create().select(Tables.COLUMNS.TABLE_SCHEMA, Tables.COLUMNS.TABLE_NAME, Tables.COLUMNS.COLUMN_NAME, Tables.COLUMNS.COLUMN_TYPE).from((TableLike)Tables.COLUMNS).where(Tables.COLUMNS.COLUMN_TYPE.like("ENUM(%)%").and(Tables.COLUMNS.TABLE_SCHEMA.in(this.getInputSchemata()))).orderBy((OrderField)Tables.COLUMNS.TABLE_SCHEMA.asc(), (OrderField)Tables.COLUMNS.TABLE_NAME.asc(), (OrderField)Tables.COLUMNS.COLUMN_NAME.asc())) {
            ColumnDefinition columnDefinition;
            SchemaDefinition schema = this.getSchema((String)record.get(Tables.COLUMNS.TABLE_SCHEMA));
            if (schema == null) continue;
            String table = (String)record.get(Tables.COLUMNS.TABLE_NAME);
            String column = (String)record.get(Tables.COLUMNS.COLUMN_NAME);
            String name = table + "_" + column;
            String columnType = (String)record.get(Tables.COLUMNS.COLUMN_TYPE);
            TableDefinition tableDefinition = this.getTable(schema, table);
            if (tableDefinition == null || (columnDefinition = tableDefinition.getColumn(column)) == null || this.getConfiguredForcedType(columnDefinition, columnDefinition.getType()) != null) continue;
            DefaultEnumDefinition definition = new DefaultEnumDefinition(schema, name, "");
            CSVReader reader = new CSVReader((Reader)new StringReader(columnType.replaceAll("(^enum\\()|(\\).*$)", "")), ',', '\'', true);
            for (String string : reader.next()) {
                definition.addLiteral(string);
            }
            result.add(definition);
        }
    }

    private void getDomainEnums(List<EnumDefinition> result) {
        for (Record record : this.create().select(Tables.DOMAINS.DOMAIN_SCHEMA, Tables.DOMAINS.DOMAIN_NAME, Tables.DOMAINS.SQL).from((TableLike)Tables.DOMAINS).where(Tables.DOMAINS.TYPE_NAME.eq((Field)DSL.inline((String)"ENUM"))).and(Tables.DOMAINS.DOMAIN_SCHEMA.in(this.getInputSchemata())).orderBy(Tables.DOMAINS.DOMAIN_SCHEMA, Tables.DOMAINS.DOMAIN_NAME)) {
            SchemaDefinition schema = this.getSchema((String)record.get(Tables.DOMAINS.DOMAIN_SCHEMA));
            if (schema == null) continue;
            String name = (String)record.get(Tables.DOMAINS.DOMAIN_NAME);
            String sql = (String)record.get(Tables.DOMAINS.SQL);
            DefaultEnumDefinition definition = new DefaultEnumDefinition(schema, name, "");
            CSVReader reader = new CSVReader((Reader)new StringReader(sql.replaceAll("(?i:(^.*as enum\\()|(\\).*$))", "")), ',', '\'', true);
            for (String string : reader.next()) {
                definition.addLiteral(string);
            }
            result.add(definition);
        }
    }

    @Override
    protected List<DomainDefinition> getDomains0() throws SQLException {
        ArrayList<DomainDefinition> result = new ArrayList<DomainDefinition>();
        for (Record record : this.create().select(Tables.DOMAINS.DOMAIN_SCHEMA, Tables.DOMAINS.DOMAIN_NAME, Tables.DOMAINS.TYPE_NAME, Tables.DOMAINS.PRECISION, Tables.DOMAINS.SCALE, Tables.DOMAINS.IS_NULLABLE, Tables.DOMAINS.COLUMN_DEFAULT, Tables.DOMAINS.CHECK_CONSTRAINT).from((TableLike)Tables.DOMAINS).where(Tables.DOMAINS.DOMAIN_SCHEMA.in(this.getInputSchemata())).and(Tables.DOMAINS.TYPE_NAME.ne((Field)DSL.inline((String)"ENUM"))).orderBy(Tables.DOMAINS.DOMAIN_SCHEMA, Tables.DOMAINS.DOMAIN_NAME)) {
            boolean isTimestamp = ((String)record.get(Tables.DOMAINS.TYPE_NAME)).trim().toLowerCase().startsWith("timestamp");
            SchemaDefinition schema = this.getSchema((String)record.get(Tables.DOMAINS.DOMAIN_SCHEMA));
            DefaultDataTypeDefinition baseType = new DefaultDataTypeDefinition((Database)this, schema, (String)record.get(Tables.DOMAINS.TYPE_NAME), (Number)record.get(Tables.DOMAINS.PRECISION), isTimestamp ? (Number)((Number)record.get(Tables.DOMAINS.SCALE)) : (Number)((Number)record.get(Tables.DOMAINS.PRECISION)), isTimestamp ? (Number)0 : (Number)((Number)record.get(Tables.DOMAINS.SCALE)), (Boolean)((Boolean)record.get(Tables.DOMAINS.IS_NULLABLE, Boolean.TYPE) == false ? 1 : 0), (String)record.get(Tables.DOMAINS.COLUMN_DEFAULT));
            DefaultDomainDefinition domain = new DefaultDomainDefinition(schema, (String)record.get(Tables.DOMAINS.DOMAIN_NAME), baseType);
            if (!StringUtils.isBlank((String)((String)record.get(Tables.DOMAINS.CHECK_CONSTRAINT)))) {
                domain.addCheckClause((String)record.get(Tables.DOMAINS.CHECK_CONSTRAINT));
            }
            result.add(domain);
        }
        return result;
    }

    @Override
    protected List<UDTDefinition> getUDTs0() throws SQLException {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        return result;
    }

    @Override
    protected List<ArrayDefinition> getArrays0() throws SQLException {
        ArrayList<ArrayDefinition> result = new ArrayList<ArrayDefinition>();
        return result;
    }

    boolean is1_4_197() {
        if (is1_4_197 == null) {
            is1_4_197 = this.exists(Tables.COLUMNS.COLUMN_TYPE);
        }
        return is1_4_197;
    }

    boolean is1_4_198() {
        if (is1_4_198 == null) {
            is1_4_198 = this.exists(Tables.COLUMNS.IS_VISIBLE);
        }
        return is1_4_198;
    }

    boolean is1_4_201() {
        if (is1_4_201 == null) {
            is1_4_201 = !this.exists(Tables.COLUMNS.CHECK_CONSTRAINT);
        }
        return is1_4_201;
    }
}

