/*
 * Decompiled with CFR 0.152.
 */
package org.lokra.seaweedfs.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.cache.HttpCacheStorage;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CachingHttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.ehcache.CacheManager;
import org.ehcache.config.Builder;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.expiry.Duration;
import org.ehcache.expiry.Expirations;
import org.lokra.seaweedfs.core.MasterWrapper;
import org.lokra.seaweedfs.core.contect.ForceGarbageCollectionParams;
import org.lokra.seaweedfs.core.contect.LookupVolumeResult;
import org.lokra.seaweedfs.core.contect.PreAllocateVolumesParams;
import org.lokra.seaweedfs.core.http.HeaderResponse;
import org.lokra.seaweedfs.core.http.JsonResponse;
import org.lokra.seaweedfs.core.http.StreamResponse;
import org.lokra.seaweedfs.core.topology.DataCenter;
import org.lokra.seaweedfs.core.topology.DataNode;
import org.lokra.seaweedfs.core.topology.Layout;
import org.lokra.seaweedfs.core.topology.MasterStatus;
import org.lokra.seaweedfs.core.topology.Rack;
import org.lokra.seaweedfs.core.topology.SystemClusterStatus;
import org.lokra.seaweedfs.core.topology.SystemTopologyStatus;
import org.lokra.seaweedfs.core.topology.VolumeStatus;
import org.lokra.seaweedfs.exception.SeaweedfsException;
import org.lokra.seaweedfs.util.ConnectionUtil;

class Connection {
    static final String LOOKUP_VOLUME_CACHE_ALIAS = "lookupVolumeCache";
    private static final Log log = LogFactory.getLog(Connection.class);
    private String leaderUrl;
    private long statusExpiry;
    private int connectionTimeout;
    private boolean connectionClose = true;
    private boolean enableFileStreamCache;
    private int fileStreamCacheEntries;
    private long fileStreamCacheSize;
    private HttpCacheStorage fileStreamCacheStorage;
    private boolean enableLookupVolumeCache;
    private long lookupVolumeCacheExpiry;
    private int lookupVolumeCacheEntries;
    private long idleConnectionExpiry;
    private SystemClusterStatus systemClusterStatus;
    private SystemTopologyStatus systemTopologyStatus;
    private PollClusterStatusThread pollClusterStatusThread;
    private ObjectMapper objectMapper = new ObjectMapper();
    private PoolingHttpClientConnectionManager clientConnectionManager;
    private IdleConnectionMonitorThread idleConnectionMonitorThread;
    private CloseableHttpClient httpClient;
    private CacheManager cacheManager = null;

    Connection(String leaderUrl, int connectionTimeout, long statusExpiry, long idleConnectionExpiry, int maxConnection, int maxConnectionsPreRoute, boolean enableLookupVolumeCache, long lookupVolumeCacheExpiry, int lookupVolumeCacheEntries, boolean enableFileStreamCache, int fileStreamCacheEntries, long fileStreamCacheSize, HttpCacheStorage fileStreamCacheStorage) throws IOException {
        this.leaderUrl = leaderUrl;
        this.statusExpiry = statusExpiry;
        this.connectionTimeout = connectionTimeout;
        this.idleConnectionExpiry = idleConnectionExpiry;
        this.enableLookupVolumeCache = enableLookupVolumeCache;
        this.lookupVolumeCacheExpiry = lookupVolumeCacheExpiry;
        this.lookupVolumeCacheEntries = lookupVolumeCacheEntries;
        this.pollClusterStatusThread = new PollClusterStatusThread();
        this.idleConnectionMonitorThread = new IdleConnectionMonitorThread();
        this.clientConnectionManager = new PoolingHttpClientConnectionManager();
        this.clientConnectionManager.setMaxTotal(maxConnection);
        this.clientConnectionManager.setDefaultMaxPerRoute(maxConnectionsPreRoute);
        this.enableFileStreamCache = enableFileStreamCache;
        this.fileStreamCacheEntries = fileStreamCacheEntries;
        this.fileStreamCacheSize = fileStreamCacheSize;
        this.fileStreamCacheStorage = fileStreamCacheStorage;
    }

    void startup() {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.connectionTimeout).build();
        if (this.enableFileStreamCache) {
            if (this.fileStreamCacheStorage == null) {
                CacheConfig cacheConfig = CacheConfig.custom().setMaxCacheEntries(this.fileStreamCacheEntries).setMaxObjectSize(this.fileStreamCacheSize).setHeuristicCachingEnabled(true).setHeuristicCoefficient(0.8f).build();
                this.httpClient = CachingHttpClients.custom().setCacheConfig(cacheConfig).setConnectionManager((HttpClientConnectionManager)this.clientConnectionManager).setDefaultRequestConfig(requestConfig).build();
            } else {
                this.httpClient = CachingHttpClients.custom().setHttpCacheStorage(this.fileStreamCacheStorage).setConnectionManager((HttpClientConnectionManager)this.clientConnectionManager).setDefaultRequestConfig(requestConfig).build();
            }
        } else {
            this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.clientConnectionManager).setDefaultRequestConfig(requestConfig).build();
        }
        this.initCache();
        this.pollClusterStatusThread.updateSystemStatus(true, true);
        this.pollClusterStatusThread.start();
        this.idleConnectionMonitorThread.start();
        log.info((Object)"seaweedfs master server connection is startup");
    }

    void stop() {
        this.closeCache();
        this.pollClusterStatusThread.shutdown();
        this.idleConnectionMonitorThread.shutdown();
        log.info((Object)"seaweedfs master server connection is shutdown");
    }

    SystemClusterStatus getSystemClusterStatus() {
        return this.systemClusterStatus;
    }

    SystemTopologyStatus getSystemTopologyStatus() {
        return this.systemTopologyStatus;
    }

    VolumeStatus getVolumeStatus(String volumeUrl) throws IOException {
        HttpGet request = new HttpGet(volumeUrl + "/status");
        JsonResponse jsonResponse = this.fetchJsonResultByRequest((HttpRequestBase)request);
        VolumeStatus volumeStatus = (VolumeStatus)this.objectMapper.readValue(jsonResponse.json.replace("{}", "null"), VolumeStatus.class);
        volumeStatus.setUrl(volumeUrl);
        return volumeStatus;
    }

    boolean isConnectionClose() {
        return this.connectionClose;
    }

    CacheManager getCacheManager() {
        return this.cacheManager;
    }

    String getLeaderUrl() {
        return this.leaderUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JsonResponse fetchJsonResultByRequest(HttpRequestBase request) throws IOException {
        Map map;
        String errorMsg;
        CloseableHttpResponse response = null;
        request.setHeader("Connection", "close");
        JsonResponse jsonResponse = null;
        try {
            response = this.httpClient.execute((HttpUriRequest)request, (HttpContext)HttpClientContext.create());
            HttpEntity entity = response.getEntity();
            jsonResponse = new JsonResponse(EntityUtils.toString((HttpEntity)entity), response.getStatusLine().getStatusCode());
            EntityUtils.consume((HttpEntity)entity);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException entity) {}
            }
            request.releaseConnection();
        }
        if (jsonResponse.json.contains("\"error\":\"") && (errorMsg = (String)(map = (Map)this.objectMapper.readValue(jsonResponse.json, Map.class)).get("error")) != null) {
            throw new SeaweedfsException(errorMsg);
        }
        return jsonResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int fetchStatusCodeByRequest(HttpHead request) throws IOException {
        int statusCode;
        CloseableHttpResponse response = null;
        request.setHeader("Connection", "close");
        try {
            response = this.httpClient.execute((HttpUriRequest)request, (HttpContext)HttpClientContext.create());
            statusCode = response.getStatusLine().getStatusCode();
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException iOException) {}
            }
            request.releaseConnection();
        }
        return statusCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StreamResponse fetchStreamCacheByRequest(HttpRequestBase request) throws IOException {
        StreamResponse cache;
        CloseableHttpResponse response = null;
        request.setHeader("Connection", "close");
        try {
            response = this.httpClient.execute((HttpUriRequest)request, (HttpContext)HttpClientContext.create());
            HttpEntity entity = response.getEntity();
            cache = new StreamResponse(entity.getContent(), response.getStatusLine().getStatusCode());
            EntityUtils.consume((HttpEntity)entity);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException iOException) {}
            }
            request.releaseConnection();
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HeaderResponse fetchHeaderByRequest(HttpHead request) throws IOException {
        HeaderResponse headerResponse;
        CloseableHttpResponse response = null;
        request.setHeader("Connection", "close");
        try {
            response = this.httpClient.execute((HttpUriRequest)request, (HttpContext)HttpClientContext.create());
            headerResponse = new HeaderResponse(response.getAllHeaders(), response.getStatusLine().getStatusCode());
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException iOException) {}
            }
            request.releaseConnection();
        }
        return headerResponse;
    }

    void forceGarbageCollection(float garbageThreshold) throws IOException {
        MasterWrapper masterWrapper = new MasterWrapper(this);
        masterWrapper.forceGarbageCollection(new ForceGarbageCollectionParams(Float.valueOf(garbageThreshold)));
    }

    void forceGarbageCollection() throws IOException {
        MasterWrapper masterWrapper = new MasterWrapper(this);
        masterWrapper.forceGarbageCollection(new ForceGarbageCollectionParams());
    }

    void preAllocateVolumes(int sameRackCount, int diffRackCount, int diffDataCenterCount, int count, String dataCenter, String ttl) throws IOException {
        MasterWrapper masterWrapper = new MasterWrapper(this);
        masterWrapper.preAllocateVolumes(new PreAllocateVolumesParams(String.valueOf(diffDataCenterCount) + String.valueOf(diffRackCount) + String.valueOf(sameRackCount), count, dataCenter, ttl));
    }

    private SystemClusterStatus fetchSystemClusterStatus(String masterUrl) throws IOException {
        HttpGet request = new HttpGet(masterUrl + "/cluster/status");
        JsonResponse jsonResponse = this.fetchJsonResultByRequest((HttpRequestBase)request);
        Map map = (Map)this.objectMapper.readValue(jsonResponse.json, Map.class);
        if (map.get("Leader") == null) {
            throw new SeaweedfsException("not found seaweedfs core leader");
        }
        MasterStatus leader = new MasterStatus((String)map.get("Leader"));
        ArrayList<MasterStatus> peers = new ArrayList<MasterStatus>();
        if (map.get("Peers") != null) {
            List rawPeerList = (List)map.get("Peers");
            for (String url : rawPeerList) {
                MasterStatus peer = new MasterStatus(url);
                peers.add(peer);
            }
        }
        if (map.get("IsLeader") == null || !((Boolean)map.get("IsLeader")).booleanValue()) {
            peers.add(new MasterStatus(masterUrl.replace("http://", "")));
            peers.remove(leader);
            leader.setActive(ConnectionUtil.checkUriAlive(this.httpClient, leader.getUrl()));
            if (!leader.isActive()) {
                throw new SeaweedfsException("seaweedfs core leader is failover");
            }
        } else {
            leader.setActive(true);
        }
        for (MasterStatus item : peers) {
            item.setActive(ConnectionUtil.checkUriAlive(this.httpClient, item.getUrl()));
        }
        return new SystemClusterStatus(leader, peers);
    }

    private String findLeaderUriByPeers(List<MasterStatus> peers) throws IOException {
        if (peers == null || peers.size() == 0) {
            return null;
        }
        for (MasterStatus item : peers) {
            String result;
            Map responseMap;
            HttpGet request = new HttpGet(item.getUrl() + "/cluster/status");
            try {
                JsonResponse jsonResponse = this.fetchJsonResultByRequest((HttpRequestBase)request);
                responseMap = (Map)this.objectMapper.readValue(jsonResponse.json, Map.class);
            }
            catch (IOException e) {
                continue;
            }
            if (responseMap.get("Leader") == null || !ConnectionUtil.checkUriAlive(this.httpClient, result = ConnectionUtil.convertUrlWithScheme((String)responseMap.get("Leader")))) continue;
            return result;
        }
        return null;
    }

    private SystemTopologyStatus fetchSystemTopologyStatus(String masterUrl) throws IOException {
        HttpGet request = new HttpGet(masterUrl + "/dir/status");
        JsonResponse jsonResponse = this.fetchJsonResultByRequest((HttpRequestBase)request);
        Map map = (Map)this.objectMapper.readValue(jsonResponse.json, Map.class);
        ArrayList<DataCenter> dataCenters = new ArrayList<DataCenter>();
        ArrayList rawDcs = (ArrayList)((Map)map.get("Topology")).get("DataCenters");
        if (rawDcs != null) {
            for (Map rawDc : rawDcs) {
                DataCenter dc = new DataCenter();
                dc.setFree((Integer)rawDc.get("Free"));
                dc.setId((String)rawDc.get("Id"));
                dc.setMax((Integer)rawDc.get("Max"));
                ArrayList<Rack> racks = new ArrayList<Rack>();
                ArrayList rawRks = (ArrayList)rawDc.get("Racks");
                if (rawRks != null) {
                    for (Map rawRk : rawRks) {
                        Rack rk = new Rack();
                        rk.setMax((Integer)rawRk.get("Max"));
                        rk.setId((String)rawRk.get("Id"));
                        rk.setFree((Integer)rawRk.get("Free"));
                        ArrayList<DataNode> dataNodes = new ArrayList<DataNode>();
                        ArrayList rawDns = (ArrayList)rawRk.get("DataNodes");
                        if (rawDns != null) {
                            for (Map rawDn : rawDns) {
                                DataNode dn = new DataNode();
                                dn.setFree((Integer)rawDn.get("Free"));
                                dn.setMax((Integer)rawDn.get("Max"));
                                dn.setVolumes((Integer)rawDn.get("Volumes"));
                                dn.setUrl((String)rawDn.get("Url"));
                                dn.setPubilcUrl((String)rawDn.get("PublicUrl"));
                                dataNodes.add(dn);
                            }
                        }
                        rk.setDataNodes(dataNodes);
                        racks.add(rk);
                    }
                }
                dc.setRacks(racks);
                dataCenters.add(dc);
            }
        }
        ArrayList<Layout> layouts = new ArrayList<Layout>();
        ArrayList rawLos = (ArrayList)((Map)map.get("Topology")).get("layouts");
        if (rawLos != null) {
            for (Map rawLo : rawLos) {
                Layout layout = new Layout();
                if (rawLo.get("collection") != null || !((String)rawLo.get("collection")).isEmpty()) {
                    layout.setCollection((String)rawLo.get("collection"));
                }
                if (rawLo.get("replication") != null || !((String)rawLo.get("replication")).isEmpty()) {
                    layout.setReplication((String)rawLo.get("replication"));
                }
                if (rawLo.get("ttl") != null || !((String)rawLo.get("ttl")).isEmpty()) {
                    layout.setTtl((String)rawLo.get("ttl"));
                }
                if (rawLo.get("writables") != null) {
                    layout.setWritables((ArrayList)rawLo.get("writables"));
                }
                layouts.add(layout);
            }
        }
        SystemTopologyStatus systemTopologyStatus = new SystemTopologyStatus();
        systemTopologyStatus.setDataCenters(dataCenters);
        systemTopologyStatus.setLayouts(layouts);
        systemTopologyStatus.setFree((Integer)((Map)map.get("Topology")).get("Free"));
        systemTopologyStatus.setMax((Integer)((Map)map.get("Topology")).get("Max"));
        systemTopologyStatus.setVersion((String)map.get("Version"));
        return systemTopologyStatus;
    }

    private void initCache() {
        if (this.enableLookupVolumeCache) {
            CacheManagerBuilder builder = CacheManagerBuilder.newCacheManagerBuilder();
            this.cacheManager = builder.build(true);
            if (this.enableLookupVolumeCache) {
                this.cacheManager.createCache(LOOKUP_VOLUME_CACHE_ALIAS, CacheConfigurationBuilder.newCacheConfigurationBuilder(Long.class, LookupVolumeResult.class, (Builder)ResourcePoolsBuilder.heap((long)this.lookupVolumeCacheEntries)).withExpiry(Expirations.timeToLiveExpiration((Duration)Duration.of((long)this.lookupVolumeCacheExpiry, (TimeUnit)TimeUnit.SECONDS))).build());
            }
        }
    }

    private void closeCache() {
        if (this.cacheManager != null) {
            this.cacheManager.removeCache(LOOKUP_VOLUME_CACHE_ALIAS);
            this.cacheManager.close();
        }
    }

    private class IdleConnectionMonitorThread
    extends Thread {
        private volatile boolean shutdown;

        private IdleConnectionMonitorThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!this.shutdown) {
                    IdleConnectionMonitorThread idleConnectionMonitorThread = this;
                    synchronized (idleConnectionMonitorThread) {
                        this.wait(Connection.this.statusExpiry);
                        Connection.this.clientConnectionManager.closeExpiredConnections();
                        Connection.this.clientConnectionManager.closeIdleConnections(Connection.this.idleConnectionExpiry, TimeUnit.SECONDS);
                        log.debug((Object)("http client pool state [" + Connection.this.clientConnectionManager.getTotalStats().toString() + "]"));
                    }
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void shutdown() {
            this.shutdown = true;
            this.interrupt();
            IdleConnectionMonitorThread idleConnectionMonitorThread = this;
            synchronized (idleConnectionMonitorThread) {
                this.notifyAll();
            }
        }
    }

    private class PollClusterStatusThread
    extends Thread {
        private volatile boolean shutdown;

        private PollClusterStatusThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.shutdown) {
                PollClusterStatusThread pollClusterStatusThread = this;
                synchronized (pollClusterStatusThread) {
                    this.updateSystemStatus(false, false);
                }
            }
        }

        void updateSystemStatus(boolean immediate, boolean disposable) {
            if (!immediate) {
                try {
                    Thread.sleep(Connection.this.statusExpiry * 1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            try {
                this.fetchSystemStatus(Connection.this.leaderUrl);
                Connection.this.connectionClose = false;
            }
            catch (IOException e) {
                Connection.this.connectionClose = true;
                log.error((Object)("unable connect to the target seaweedfs core [" + Connection.this.leaderUrl + "]"));
            }
            try {
                if (Connection.this.connectionClose) {
                    log.info((Object)"lookup seaweedfs core leader by peers");
                    if (Connection.this.systemClusterStatus == null || Connection.this.systemClusterStatus.getPeers().size() == 0) {
                        log.error((Object)"cloud not found the seaweedfs core peers");
                    } else {
                        String url = Connection.this.findLeaderUriByPeers(Connection.this.systemClusterStatus.getPeers());
                        if (url != null) {
                            log.error((Object)"seaweedfs core cluster is failover");
                            this.fetchSystemStatus(url);
                            Connection.this.connectionClose = false;
                        } else {
                            log.error((Object)"seaweedfs core cluster is down");
                            Connection.this.systemClusterStatus.getLeader().setActive(false);
                            Connection.this.connectionClose = true;
                        }
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                log.error((Object)"unable connect to the seaweedfs core leader");
            }
            if (immediate && !disposable) {
                try {
                    Thread.sleep(Connection.this.statusExpiry * 1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        private void fetchSystemStatus(String url) throws IOException {
            Connection.this.systemClusterStatus = Connection.this.fetchSystemClusterStatus(url);
            Connection.this.systemTopologyStatus = Connection.this.fetchSystemTopologyStatus(url);
            if (!Connection.this.leaderUrl.equals(Connection.this.systemClusterStatus.getLeader().getUrl())) {
                Connection.this.leaderUrl = Connection.this.systemClusterStatus.getLeader().getUrl();
                log.info((Object)("seaweedfs core leader is change to [" + Connection.this.leaderUrl + "]"));
            }
            log.debug((Object)("seaweedfs core leader is found [" + Connection.this.leaderUrl + "]"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void shutdown() {
            this.shutdown = true;
            this.interrupt();
            PollClusterStatusThread pollClusterStatusThread = this;
            synchronized (pollClusterStatusThread) {
                this.notifyAll();
            }
        }
    }
}

