/*
 * Decompiled with CFR 0.152.
 */
package org.lokra.seaweedfs.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.lokra.seaweedfs.core.Connection;
import org.lokra.seaweedfs.core.contect.AssignFileKeyParams;
import org.lokra.seaweedfs.core.contect.AssignFileKeyResult;
import org.lokra.seaweedfs.core.contect.ForceGarbageCollectionParams;
import org.lokra.seaweedfs.core.contect.LookupVolumeParams;
import org.lokra.seaweedfs.core.contect.LookupVolumeResult;
import org.lokra.seaweedfs.core.contect.PreAllocateVolumesParams;
import org.lokra.seaweedfs.core.contect.PreAllocateVolumesResult;
import org.lokra.seaweedfs.core.http.JsonResponse;
import org.lokra.seaweedfs.exception.SeaweedfsException;

class MasterWrapper {
    private Connection connection;
    private Cache<Long, LookupVolumeResult> lookupVolumeCache;
    private ObjectMapper objectMapper = new ObjectMapper();

    MasterWrapper(Connection connection) {
        this.connection = connection;
        CacheManager cacheManager = connection.getCacheManager();
        if (cacheManager != null) {
            this.lookupVolumeCache = cacheManager.getCache("lookupVolumeCache", Long.class, LookupVolumeResult.class);
        }
    }

    AssignFileKeyResult assignFileKey(AssignFileKeyParams params) throws IOException {
        this.checkConnection();
        String url = this.connection.getLeaderUrl() + "/dir/assign" + params.toUrlParams();
        HttpGet request = new HttpGet(url);
        JsonResponse jsonResponse = this.connection.fetchJsonResultByRequest((HttpRequestBase)request);
        return (AssignFileKeyResult)this.objectMapper.readValue(jsonResponse.json, AssignFileKeyResult.class);
    }

    void forceGarbageCollection(ForceGarbageCollectionParams params) throws IOException {
        this.checkConnection();
        String url = this.connection.getLeaderUrl() + "/vol/vacuum" + params.toUrlParams();
        HttpGet request = new HttpGet(url);
        this.connection.fetchJsonResultByRequest((HttpRequestBase)request);
    }

    PreAllocateVolumesResult preAllocateVolumes(PreAllocateVolumesParams params) throws IOException {
        this.checkConnection();
        String url = this.connection.getLeaderUrl() + "/vol/grow" + params.toUrlParams();
        HttpGet request = new HttpGet(url);
        JsonResponse jsonResponse = this.connection.fetchJsonResultByRequest((HttpRequestBase)request);
        return (PreAllocateVolumesResult)this.objectMapper.readValue(jsonResponse.json, PreAllocateVolumesResult.class);
    }

    LookupVolumeResult lookupVolume(LookupVolumeParams params) throws IOException {
        this.checkConnection();
        if (this.lookupVolumeCache != null) {
            LookupVolumeResult result = (LookupVolumeResult)this.lookupVolumeCache.get((Object)params.getVolumeId());
            if (result != null) {
                return result;
            }
            result = this.fetchLookupVolumeResult(params);
            this.lookupVolumeCache.put((Object)params.getVolumeId(), (Object)result);
            return result;
        }
        return this.fetchLookupVolumeResult(params);
    }

    private LookupVolumeResult fetchLookupVolumeResult(LookupVolumeParams params) throws IOException {
        this.checkConnection();
        String url = this.connection.getLeaderUrl() + "/dir/lookup" + params.toUrlParams();
        HttpGet request = new HttpGet(url);
        JsonResponse jsonResponse = this.connection.fetchJsonResultByRequest((HttpRequestBase)request);
        return (LookupVolumeResult)this.objectMapper.readValue(jsonResponse.json, LookupVolumeResult.class);
    }

    private void checkConnection() throws SeaweedfsException {
        if (this.connection.isConnectionClose()) {
            throw new SeaweedfsException("connection is closed");
        }
    }
}

