/*
 * Decompiled with CFR 0.152.
 */
package org.lokra.seaweedfs.core.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamResponse {
    private ByteArrayOutputStream byteArrayOutputStream;
    private int httpResponseStatusCode;
    private long length = 0L;

    public StreamResponse(InputStream inputStream, int httpResponseStatusCode) throws IOException {
        int length;
        this.httpResponseStatusCode = httpResponseStatusCode;
        if (inputStream == null) {
            return;
        }
        this.byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = inputStream.read(buffer)) > -1) {
            this.byteArrayOutputStream.write(buffer, 0, length);
            this.length += (long)length;
        }
        this.byteArrayOutputStream.flush();
    }

    public InputStream getInputStream() {
        if (this.byteArrayOutputStream == null) {
            return null;
        }
        return new ByteArrayInputStream(this.byteArrayOutputStream.toByteArray());
    }

    public int getHttpResponseStatusCode() {
        return this.httpResponseStatusCode;
    }

    public OutputStream getOutputStream() {
        return this.byteArrayOutputStream;
    }

    public long getLength() {
        return this.length;
    }

    public String toString() {
        return "StreamResponse{byteArrayOutputStream=" + this.byteArrayOutputStream + ", httpResponseStatusCode=" + this.httpResponseStatusCode + ", length=" + this.length + '}';
    }
}

