/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.test.assertj;

import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.record.TimestampType;
import org.assertj.core.api.Condition;

public final class KafkaConditions {
    private KafkaConditions() {
    }

    public static <K> Condition<ConsumerRecord<K, ?>> key(K key) {
        return new ConsumerRecordKeyCondition<K>(key);
    }

    public static <V> Condition<ConsumerRecord<?, V>> value(V value) {
        return new ConsumerRecordValueCondition<V>(value);
    }

    public static Condition<ConsumerRecord<?, ?>> timestamp(long value) {
        return KafkaConditions.timestamp(TimestampType.CREATE_TIME, value);
    }

    public static Condition<ConsumerRecord<?, ?>> timestamp(TimestampType type, long value) {
        return new ConsumerRecordTimestampCondition(type, value);
    }

    public static Condition<ConsumerRecord<?, ?>> partition(int partition) {
        return new ConsumerRecordPartitionCondition(partition);
    }

    public static class ConsumerRecordPartitionCondition
    extends Condition<ConsumerRecord<?, ?>> {
        private final int partition;

        public ConsumerRecordPartitionCondition(int partition) {
            super("a ConsumerRecord with 'partition' " + partition);
            this.partition = partition;
        }

        public boolean matches(ConsumerRecord<?, ?> value) {
            return value != null && value.partition() == this.partition;
        }
    }

    public static class ConsumerRecordTimestampCondition
    extends Condition<ConsumerRecord<?, ?>> {
        private final TimestampType type;
        private final long ts;

        public ConsumerRecordTimestampCondition(TimestampType type, long ts) {
            super("a ConsumerRecord with timestamp of type: " + type + " and timestamp: " + ts);
            this.type = type;
            this.ts = ts;
        }

        public boolean matches(ConsumerRecord<?, ?> value) {
            return value != null && value.timestampType() == this.type && value.timestamp() == this.ts;
        }
    }

    public static class ConsumerRecordValueCondition<V>
    extends Condition<ConsumerRecord<?, V>> {
        private final V payload;

        public ConsumerRecordValueCondition(V payload) {
            super("a ConsumerRecord with 'value' " + payload);
            this.payload = payload;
        }

        public boolean matches(ConsumerRecord<?, V> value) {
            return value != null && value.value().equals(this.payload);
        }
    }

    public static class ConsumerRecordKeyCondition<K>
    extends Condition<ConsumerRecord<K, ?>> {
        private final K key;

        public ConsumerRecordKeyCondition(K key) {
            super("a ConsumerRecord with 'key' " + key);
            this.key = key;
        }

        public boolean matches(ConsumerRecord<K, ?> value) {
            return value != null && (value.key() == null && this.key == null || value.key().equals(this.key));
        }
    }
}

