/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class KafkaAdmin
implements ApplicationContextAware,
SmartInitializingSingleton {
    private static final int DEFAULT_CLOSE_TIMEOUT = 10;
    private static final Log logger = LogFactory.getLog(KafkaAdmin.class);
    private final Map<String, Object> config;
    private ApplicationContext applicationContext;
    private int closeTimeout = 10;
    private boolean fatalIfBrokerNotAvailable;
    private boolean autoCreate = true;
    private boolean initializingContext;

    public KafkaAdmin(Map<String, Object> config) {
        this.config = new HashMap<String, Object>(config);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setCloseTimeout(int closeTimeout) {
        this.closeTimeout = closeTimeout;
    }

    public void setFatalIfBrokerNotAvailable(boolean fatalIfBrokerNotAvailable) {
        this.fatalIfBrokerNotAvailable = fatalIfBrokerNotAvailable;
    }

    public void setAutoCreate(boolean autoCreate) {
        this.autoCreate = autoCreate;
    }

    public Map<String, Object> getConfig() {
        return Collections.unmodifiableMap(this.config);
    }

    public void afterSingletonsInstantiated() {
        this.initializingContext = true;
        if (this.autoCreate) {
            this.initialize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean initialize() {
        Collection<NewTopic> newTopics = this.applicationContext.getBeansOfType(NewTopic.class, false, false).values();
        if (newTopics.size() > 0) {
            AdminClient adminClient;
            block11: {
                adminClient = null;
                try {
                    adminClient = AdminClient.create(this.config);
                }
                catch (Exception e) {
                    if (this.initializingContext && !this.fatalIfBrokerNotAvailable) break block11;
                    throw new IllegalStateException("Could not create admin", e);
                }
            }
            if (adminClient != null) {
                try {
                    this.addTopicsIfNeeded(adminClient, newTopics);
                    boolean e = true;
                    return e;
                }
                catch (Throwable e) {
                    if (e instanceof Error) {
                        throw (Error)e;
                    }
                    if (!this.initializingContext || this.fatalIfBrokerNotAvailable) {
                        throw new IllegalStateException("Could not configure topics", e);
                    }
                }
                finally {
                    this.initializingContext = false;
                    adminClient.close((long)this.closeTimeout, TimeUnit.SECONDS);
                }
            }
        }
        this.initializingContext = false;
        return false;
    }

    private void addTopicsIfNeeded(AdminClient adminClient, Collection<NewTopic> topics) throws Throwable {
        if (topics.size() > 0) {
            HashMap topicNameToTopic = new HashMap();
            topics.forEach(t -> topicNameToTopic.compute(t.name(), (k, v) -> {
                v = t;
                return v;
            }));
            DescribeTopicsResult topicInfo = adminClient.describeTopics((Collection)topics.stream().map(NewTopic::name).collect(Collectors.toList()));
            ArrayList topicsToAdd = new ArrayList();
            topicInfo.values().forEach((n, f) -> {
                try {
                    TopicDescription topicDescription = (TopicDescription)f.get();
                    if (((NewTopic)topicNameToTopic.get(n)).numPartitions() != topicDescription.partitions().size() && logger.isInfoEnabled()) {
                        logger.info((Object)String.format("Topic '%s' exists but has a different partition count: %d not %d", n, topicDescription.partitions().size(), ((NewTopic)topicNameToTopic.get(n)).numPartitions()));
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    topicsToAdd.add(topicNameToTopic.get(n));
                }
            });
            if (topicsToAdd.size() > 0) {
                CreateTopicsResult topicResults = adminClient.createTopics(topicsToAdd);
                try {
                    topicResults.all().get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.error((Object)"Interrupted while waiting for topic creation results", (Throwable)e);
                }
                catch (ExecutionException e) {
                    logger.error((Object)"Failed to create topics", e.getCause());
                    throw e.getCause();
                }
            }
        }
    }
}

