/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.rsocket.authentication;

import java.util.List;
import org.springframework.core.Ordered;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.security.rsocket.api.PayloadExchange;
import org.springframework.security.rsocket.api.PayloadInterceptor;
import org.springframework.security.rsocket.api.PayloadInterceptorChain;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class AnonymousPayloadInterceptor
implements PayloadInterceptor,
Ordered {
    private String key;
    private Object principal;
    private List<GrantedAuthority> authorities;
    private int order;

    public AnonymousPayloadInterceptor(String key) {
        this(key, "anonymousUser", AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_ANONYMOUS"}));
    }

    public AnonymousPayloadInterceptor(String key, Object principal, List<GrantedAuthority> authorities) {
        Assert.hasLength((String)key, (String)"key cannot be null or empty");
        Assert.notNull((Object)principal, (String)"Anonymous authentication principal must be set");
        Assert.notNull(authorities, (String)"Anonymous authorities must be set");
        this.key = key;
        this.principal = principal;
        this.authorities = authorities;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public Mono<Void> intercept(PayloadExchange exchange, PayloadInterceptorChain chain) {
        return ReactiveSecurityContextHolder.getContext().switchIfEmpty(Mono.defer(() -> {
            AnonymousAuthenticationToken authentication = new AnonymousAuthenticationToken(this.key, this.principal, this.authorities);
            return chain.next(exchange).subscriberContext(ReactiveSecurityContextHolder.withAuthentication((Authentication)authentication)).then(Mono.empty());
        })).flatMap(securityContext -> chain.next(exchange));
    }
}

