/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.registration;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrationRepository;
import org.springframework.util.Assert;

public class InMemoryRelyingPartyRegistrationRepository
implements RelyingPartyRegistrationRepository,
Iterable<RelyingPartyRegistration> {
    private final Map<String, RelyingPartyRegistration> byRegistrationId;

    public InMemoryRelyingPartyRegistrationRepository(RelyingPartyRegistration ... registrations) {
        this(Arrays.asList(registrations));
    }

    public InMemoryRelyingPartyRegistrationRepository(Collection<RelyingPartyRegistration> registrations) {
        Assert.notEmpty(registrations, (String)"registrations cannot be empty");
        this.byRegistrationId = InMemoryRelyingPartyRegistrationRepository.createMappingToIdentityProvider(registrations);
    }

    private static Map<String, RelyingPartyRegistration> createMappingToIdentityProvider(Collection<RelyingPartyRegistration> rps) {
        LinkedHashMap<String, RelyingPartyRegistration> result = new LinkedHashMap<String, RelyingPartyRegistration>();
        for (RelyingPartyRegistration rp : rps) {
            Assert.notNull((Object)rp, (String)"relying party collection cannot contain null values");
            String key = rp.getRegistrationId();
            Assert.notNull((Object)rp, (String)"relying party identifier cannot be null");
            Assert.isNull(result.get(key), () -> "relying party duplicate identifier '" + key + "' detected.");
            result.put(key, rp);
        }
        return Collections.unmodifiableMap(result);
    }

    @Override
    public RelyingPartyRegistration findByRegistrationId(String id) {
        return this.byRegistrationId.get(id);
    }

    @Override
    public Iterator<RelyingPartyRegistration> iterator() {
        return this.byRegistrationId.values().iterator();
    }
}

