/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.script.parsing.ast.statement;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.ssssssss.script.compile.MagicScriptCompiler;
import org.ssssssss.script.parsing.Span;
import org.ssssssss.script.parsing.VarIndex;
import org.ssssssss.script.parsing.ast.Expression;
import org.ssssssss.script.parsing.ast.statement.LambdaFunction;
import org.ssssssss.script.parsing.ast.statement.Return;
import org.ssssssss.script.runtime.Variables;
import org.ssssssss.script.runtime.function.MagicScriptLambdaFunction;

public class AsyncCall
extends Expression {
    private static ThreadPoolExecutor threadPoolExecutor = AsyncCall.setThreadPoolExecutorSize(Runtime.getRuntime().availableProcessors() * 2);
    private final LambdaFunction expression;

    public AsyncCall(Span span, Expression expression) {
        super(span);
        this.expression = expression instanceof LambdaFunction ? (LambdaFunction)expression : new LambdaFunction(span, Collections.emptyList(), Collections.singletonList(new Return(span, expression)));
        this.expression.setAsync(true);
    }

    public static ThreadPoolExecutor setThreadPoolExecutorSize(int size) {
        if (size > 0) {
            threadPoolExecutor = new ThreadPoolExecutor(size, size, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(size * 2), new AsyncThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());
        }
        return threadPoolExecutor;
    }

    public static FutureTask<Object> execute(MagicScriptLambdaFunction function, Variables variables, Object[] args) {
        FutureTask<Object> futureTask = new FutureTask<Object>(() -> function.apply(variables, args));
        if (Thread.currentThread().getThreadGroup() == AsyncThreadFactory.ASYNC_THREAD_GROUP) {
            futureTask.run();
        } else {
            threadPoolExecutor.submit(futureTask);
        }
        return futureTask;
    }

    @Override
    public void visitMethod(MagicScriptCompiler compiler) {
        this.expression.visitMethod(compiler);
    }

    @Override
    public void compile(MagicScriptCompiler compiler) {
        List<VarIndex> parameters = this.expression.getParameters();
        compiler.compile(this.expression).load2();
        parameters.forEach(compiler::load);
        compiler.call("call_async", parameters.size() + 2);
    }

    static class AsyncThreadFactory
    implements ThreadFactory {
        private static final ThreadGroup ASYNC_THREAD_GROUP = new ThreadGroup("magic-async-group");
        private final AtomicLong threadNumber = new AtomicLong(1L);
        private final String namePrefix = "magic-async-";

        AsyncThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(ASYNC_THREAD_GROUP, r, "magic-async-" + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

