/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.integration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;

public class DataProvider
implements Iterator<Object[]> {
    private List<Object[]> data = new ArrayList<Object[]>();
    private Iterator<Object[]> it = null;
    private Lock lock = new ReentrantLock();
    private int index = 1;
    private int prev = 0;
    private String ERROR_MSG = "DataProvider error, the previous data length is %d, but current data(data index %d) %s length is %d.";

    public DataProvider data(Object ... data) {
        this.checkDataLength(data);
        this.data.add(data);
        ++this.index;
        return this;
    }

    @Override
    public boolean hasNext() {
        this.initIterator();
        return this.it.hasNext();
    }

    @Override
    public Object[] next() {
        this.initIterator();
        return this.it.next();
    }

    @Override
    public void remove() {
        this.initIterator();
        this.it.remove();
    }

    private void initIterator() {
        if (this.it == null) {
            try {
                this.lock.lock();
                if (this.it == null) {
                    this.it = this.data.iterator();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private void checkDataLength(Object ... data) {
        int length = data.length;
        if (length == 0) {
            throw new RuntimeException(String.format("provider data(index %d) error, can't be empty.", this.index));
        }
        if (this.prev != 0 && this.prev != length) {
            String str = Arrays.stream(data).map(String::valueOf).collect(Collectors.joining(", ", "[", "]"));
            String error = String.format(this.ERROR_MSG, this.prev, this.index, str, length);
            throw new RuntimeException(error);
        }
        this.prev = length;
    }
}

